/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Arg;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.Verifier;
import com.twitter.common.args.Verifiers;
import com.twitter.common.args.constraints.NotNullVerifier;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.collections.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ArgumentInfo<T> {
    static final ImmutableSet<String> HELP_ARGS = ImmutableSet.of((Object)"h", (Object)"help");
    private final String help;
    private final Arg<T> arg;
    private final TypeToken<T> type;
    private final List<Annotation> verifierAnnotations;
    @Nullable
    private final Class<? extends Parser<? extends T>> parser;

    public ArgumentInfo(String help, Arg<T> arg, TypeToken<T> type, List<Annotation> verifierAnnotations, @Nullable Class<? extends Parser<? extends T>> parser) {
        this.help = MorePreconditions.checkNotBlank((String)help);
        this.arg = (Arg)Preconditions.checkNotNull(arg);
        this.type = (TypeToken)Preconditions.checkNotNull(type);
        this.verifierAnnotations = ImmutableList.copyOf(verifierAnnotations);
        this.parser = parser;
    }

    public abstract String getName();

    protected Parser<? extends T> getParser(ParserOracle parserOracle) {
        Preconditions.checkNotNull((Object)parserOracle);
        if (this.parser == null || Parser.class.equals(this.parser)) {
            return parserOracle.get(this.type);
        }
        try {
            return this.parser.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to instantiate parser " + this.parser);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No access to instantiate parser " + this.parser);
        }
    }

    private Iterable<Pair<? extends Verifier<? super T>, Annotation>> getVerifiers(final Verifiers verifierOracle) {
        Function toVerifier = new Function<Annotation, Pair<? extends Verifier<? super T>, Annotation>>(){

            public Pair<? extends Verifier<? super T>, Annotation> apply(Annotation annotation) {
                Verifier verifier = verifierOracle.get(ArgumentInfo.this.type, annotation);
                return verifier != null ? Pair.of(verifier, (Object)annotation) : null;
            }
        };
        return Iterables.filter((Iterable)Iterables.transform(this.verifierAnnotations, (Function)toVerifier), (Predicate)Predicates.notNull());
    }

    public String getHelp() {
        return this.help;
    }

    public Arg<T> getArg() {
        return this.arg;
    }

    public TypeToken<T> getType() {
        return this.type;
    }

    protected void setValue(T value) {
        this.arg.set(value);
    }

    abstract String getCanonicalName();

    protected static Arg<?> getArgForField(Field field) {
        Preconditions.checkArgument((field.getType() == Arg.class ? 1 : 0) != 0, (Object)("Field is annotated for argument parsing but is not of Arg type: " + field));
        Preconditions.checkArgument((boolean)Modifier.isStatic(field.getModifiers()), (Object)("Non-static argument fields are not supported, found " + field));
        field.setAccessible(true);
        try {
            return (Arg)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot get arg value for " + field);
        }
    }

    void verify(Verifiers verifierOracle) {
        Object value = this.getArg().uncheckedGet();
        for (Pair<Verifier<T>, Annotation> pair : this.getVerifiers(verifierOracle)) {
            Verifier verifier = (Verifier)pair.getFirst();
            Annotation annotation = (Annotation)pair.getSecond();
            if (value == null && !(verifier instanceof NotNullVerifier)) continue;
            verifier.verify(value, annotation);
        }
    }

    void collectConstraints(Verifiers verifierOracle, ImmutableList.Builder<String> constraints) {
        for (Pair<Verifier<T>, Annotation> pair : this.getVerifiers(verifierOracle)) {
            Verifier verifier = (Verifier)pair.getFirst();
            Annotation annotation = (Annotation)pair.getSecond();
            Class rawType = this.type.getRawType();
            String constraint = verifier.toString(rawType, annotation);
            constraints.add((Object)constraint);
        }
    }
}

