/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Arg;
import com.twitter.common.args.ArgumentInfo;
import com.twitter.common.args.CmdLine;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.TypeUtil;
import com.twitter.common.args.apt.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class OptionInfo<T>
extends ArgumentInfo<T> {
    static final String ARG_NAME_RE = "[\\w\\-\\.]+";
    static final Pattern ARG_NAME_PATTERN = Pattern.compile("[\\w\\-\\.]+");
    static final String NEGATE_BOOLEAN = "no_";
    private final String name;
    private final String prefix;

    public OptionInfo(String name, String help, Arg<T> arg, TypeToken<T> type, String prefix, List<Annotation> verifierAnnotations, @Nullable Class<? extends Parser<? extends T>> parser) {
        super(help, arg, type, verifierAnnotations, parser);
        this.name = name;
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix);
    }

    static OptionInfo createFromField(Field field) {
        Preconditions.checkNotNull((Object)field);
        CmdLine cmdLine = field.getAnnotation(CmdLine.class);
        if (cmdLine == null) {
            throw new Configuration.ConfigurationException("No @CmdLine Arg annotation for field " + field, new Object[0]);
        }
        OptionInfo optionInfo = new OptionInfo(OptionInfo.checkValidName(cmdLine.name()), cmdLine.help(), ArgumentInfo.getArgForField(field), TypeUtil.getTypeParamTypeToken(field), field.getDeclaringClass().getCanonicalName(), Arrays.asList(field.getAnnotations()), cmdLine.parser());
        return optionInfo;
    }

    public static <T> OptionInfo<T> create(String name, String help, String prefix, Class<T> type) {
        return new OptionInfo<T>(OptionInfo.checkValidName(name), help, Arg.create(), TypeToken.of(type), prefix, (List<Annotation>)ImmutableList.of(), null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    String getNegatedName() {
        return NEGATE_BOOLEAN + this.name;
    }

    void load(ParserOracle parserOracle, String optionName, String value) {
        Parser parser = this.getParser(parserOracle);
        Object result = parser.parse(parserOracle, this.getType().getType(), value);
        if (this.isBoolean() && Predicates.in(Arrays.asList(this.getNegatedName(), this.getCanonicalNegatedName())).apply((Object)optionName)) {
            result = (Boolean)result == false;
        }
        Object parsed = result;
        this.setValue(parsed);
    }

    @Override
    String getCanonicalName() {
        return this.prefix + "." + this.name;
    }

    boolean isBoolean() {
        return this.getType().getRawType() == Boolean.class;
    }

    String getCanonicalNegatedName() {
        return this.prefix + "." + NEGATE_BOOLEAN + this.name;
    }

    private static String checkValidName(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!HELP_ARGS.contains((Object)name) ? 1 : 0) != 0, (Object)String.format("Argument name '%s' is reserved for builtin argument help", name));
        Preconditions.checkArgument((boolean)ARG_NAME_PATTERN.matcher(name).matches(), (Object)String.format("Argument name '%s' does not match required pattern %s", name, ARG_NAME_RE));
        return name;
    }
}

