/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.parsers;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.Parsers;
import com.twitter.common.args.parsers.TypeParameterizedParser;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class MapParser
extends TypeParameterizedParser<Map> {
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on((String)"=").trimResults().omitEmptyStrings();

    public MapParser() {
        super(2);
    }

    @Override
    Map doParse(ParserOracle parserOracle, String raw, List<Type> typeParams) {
        Type keyType = typeParams.get(0);
        Parser keyParser = parserOracle.get(TypeToken.of((Type)keyType));
        Type valueType = typeParams.get(1);
        Parser valueParser = parserOracle.get(TypeToken.of((Type)valueType));
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (String keyAndValue : Parsers.MULTI_VALUE_SPLITTER.split((CharSequence)raw)) {
            ImmutableList fields = ImmutableList.copyOf((Iterable)KEY_VALUE_SPLITTER.split((CharSequence)keyAndValue));
            Preconditions.checkArgument((fields.size() == 2 ? 1 : 0) != 0, (Object)("Failed to parse key/value pair " + keyAndValue));
            map.put(keyParser.parse(parserOracle, keyType, (String)fields.get(0)), valueParser.parse(parserOracle, valueType, (String)fields.get(1)));
        }
        return map.build();
    }
}

