/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Arg;
import com.twitter.common.args.NoParser;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.Verifier;
import com.twitter.common.args.Verifiers;
import com.twitter.common.args.constraints.NotNullVerifier;
import com.twitter.common.base.MorePreconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ArgumentInfo<T> {
    static final ImmutableSet<String> HELP_ARGS = ImmutableSet.of((Object)"h", (Object)"help");
    private final String canonicalName;
    private final String name;
    private final String help;
    private final Arg<T> arg;
    private final TypeToken<T> type;
    private final List<Annotation> verifierAnnotations;
    @Nullable
    private final Class<? extends Parser<? extends T>> parser;

    protected static Arg<?> getArgForField(Field field, Optional<?> instance) {
        Preconditions.checkArgument((field.getType() == Arg.class ? 1 : 0) != 0, (Object)("Field is annotated for argument parsing but is not of Arg type: " + field));
        Preconditions.checkArgument((Modifier.isStatic(field.getModifiers()) || instance.isPresent() ? 1 : 0) != 0, (Object)("Non-static argument fields are not supported, found " + field));
        field.setAccessible(true);
        try {
            return (Arg)field.get(instance.orNull());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot get arg value for " + field);
        }
    }

    protected ArgumentInfo(String canonicalName, String name, String help, Arg<T> arg, TypeToken<T> type, List<Annotation> verifierAnnotations, @Nullable Class<? extends Parser<? extends T>> parser) {
        this.canonicalName = MorePreconditions.checkNotBlank((String)canonicalName);
        this.name = MorePreconditions.checkNotBlank((String)name);
        this.help = MorePreconditions.checkNotBlank((String)help);
        this.arg = (Arg)Preconditions.checkNotNull(arg);
        this.type = (TypeToken)Preconditions.checkNotNull(type);
        this.verifierAnnotations = ImmutableList.copyOf(verifierAnnotations);
        this.parser = parser;
    }

    public final String getName() {
        return this.name;
    }

    public final String getCanonicalName() {
        return this.canonicalName;
    }

    public String getHelp() {
        return this.help;
    }

    public Arg<T> getArg() {
        return this.arg;
    }

    protected void setValue(@Nullable T value) {
        this.arg.set(value);
    }

    public TypeToken<T> getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        return object instanceof ArgumentInfo && this.arg.equals(((ArgumentInfo)object).arg);
    }

    public int hashCode() {
        return this.arg.hashCode();
    }

    protected Parser<? extends T> getParser(ParserOracle parserOracle) {
        Preconditions.checkNotNull((Object)parserOracle);
        if (this.parser == null || NoParser.class.equals(this.parser)) {
            return parserOracle.get(this.type);
        }
        try {
            return this.parser.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to instantiate parser " + this.parser);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No access to instantiate parser " + this.parser);
        }
    }

    private Iterable<ValueVerifier<T>> getVerifiers(final Verifiers verifierOracle) {
        Function toVerifier = new Function<Annotation, Optional<ValueVerifier<T>>>(){

            public Optional<ValueVerifier<T>> apply(Annotation annotation) {
                Verifier verifier = verifierOracle.get(ArgumentInfo.this.type, annotation);
                if (verifier != null) {
                    return Optional.of(new ValueVerifier(verifier, annotation));
                }
                return Optional.absent();
            }
        };
        return Optional.presentInstances((Iterable)Iterables.transform(this.verifierAnnotations, (Function)toVerifier));
    }

    void verify(Verifiers verifierOracle) {
        Object value = this.getArg().uncheckedGet();
        for (ValueVerifier<Object> valueVerifier : this.getVerifiers(verifierOracle)) {
            valueVerifier.verify(value);
        }
    }

    ImmutableList<String> collectConstraints(Verifiers verifierOracle) {
        final Class rawType = this.type.getRawType();
        return FluentIterable.from(this.getVerifiers(verifierOracle)).transform(new Function<ValueVerifier<T>, String>(){

            public String apply(ValueVerifier<T> verifier) {
                return verifier.toString(rawType);
            }
        }).toList();
    }

    static class ValueVerifier<T> {
        private final Verifier<? super T> verifier;
        private final Annotation annotation;

        ValueVerifier(Verifier<? super T> verifier, Annotation annotation) {
            this.verifier = verifier;
            this.annotation = annotation;
        }

        void verify(@Nullable T value) {
            if (value != null || this.verifier instanceof NotNullVerifier) {
                this.verifier.verify(value, this.annotation);
            }
        }

        String toString(Class<? extends T> rawType) {
            return this.verifier.toString(rawType, this.annotation);
        }
    }
}

