/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.reflect.TypeToken;
import com.twitter.common.args.Arg;
import com.twitter.common.args.ArgumentInfo;
import com.twitter.common.args.CmdLine;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.TypeUtil;
import com.twitter.common.args.apt.Configuration;
import com.twitter.common.base.Function;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class OptionInfo<T>
extends ArgumentInfo<T> {
    static final String ARG_NAME_RE = "[\\w\\-\\.]+";
    private static final Pattern ARG_NAME_PATTERN = Pattern.compile("[\\w\\-\\.]+");
    private static final String NEGATE_BOOLEAN = "no_";
    private final Function<String, String> canonicalizer;

    static OptionInfo<?> createFromField(Field field) {
        return OptionInfo.createFromField(field, null);
    }

    static OptionInfo<?> createFromField(final Field field, @Nullable Object instance) {
        CmdLine cmdLine = field.getAnnotation(CmdLine.class);
        if (cmdLine == null) {
            throw new Configuration.ConfigurationException("No @CmdLine Arg annotation for field " + field, new Object[0]);
        }
        String name = cmdLine.name();
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!HELP_ARGS.contains((Object)name) ? 1 : 0) != 0, (Object)String.format("Argument name '%s' is reserved for builtin argument help", name));
        Preconditions.checkArgument((boolean)ARG_NAME_PATTERN.matcher(name).matches(), (Object)String.format("Argument name '%s' does not match required pattern %s", name, ARG_NAME_RE));
        Function<String, String> canonicalizer = new Function<String, String>(){

            public String apply(String name) {
                return field.getDeclaringClass().getCanonicalName() + "." + name;
            }
        };
        OptionInfo optionInfo = new OptionInfo(canonicalizer, name, cmdLine.help(), ArgumentInfo.getArgForField(field, Optional.fromNullable((Object)instance)), TypeUtil.getTypeParamTypeToken(field), Arrays.asList(field.getAnnotations()), cmdLine.parser());
        return optionInfo;
    }

    private OptionInfo(Function<String, String> canonicalizer, String name, String help, Arg<T> arg, TypeToken<T> type, List<Annotation> verifierAnnotations, @Nullable Class<? extends Parser<T>> parser) {
        super((String)canonicalizer.apply((Object)name), name, help, arg, type, verifierAnnotations, parser);
        this.canonicalizer = canonicalizer;
    }

    void load(ParserOracle parserOracle, String optionName, String value) {
        Parser parser = this.getParser(parserOracle);
        Object result = parser.parse(parserOracle, this.getType().getType(), value);
        if (this.isBoolean() && Predicates.in(Arrays.asList(this.getNegatedName(), this.getCanonicalNegatedName())).apply((Object)optionName)) {
            result = (Boolean)result == false;
        }
        Object parsed = result;
        this.setValue(parsed);
    }

    boolean isBoolean() {
        return this.getType().getRawType() == Boolean.class;
    }

    String getNegatedName() {
        return NEGATE_BOOLEAN + this.getName();
    }

    String getCanonicalNegatedName() {
        return (String)this.canonicalizer.apply((Object)this.getNegatedName());
    }
}

