/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.Stats;
import com.twitter.common.stats.StatsProvider;

public class Config {
    private static final Amount<Long, Time> DEADLINE_BLOCKING = Amount.of((long)0L, (Unit)Time.MILLISECONDS);
    @VisibleForTesting
    static final Amount<Long, Time> DEFAULT_CONNECT_TIMEOUT = Amount.of((long)5L, (Unit)Time.SECONDS);
    private Amount<Long, Time> requestTimeout = DEADLINE_BLOCKING;
    private Amount<Long, Time> connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private int maxRetries;
    private ImmutableSet<Class<? extends Exception>> retryableExceptions = ImmutableSet.of();
    private boolean debug = false;
    private boolean enableStats = true;
    private StatsProvider statsProvider = Stats.STATS_PROVIDER;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Config config) {
        Preconditions.checkNotNull((Object)config);
        return new Builder(config);
    }

    private Config() {
    }

    private Config(Config copyFrom) {
        this.requestTimeout = copyFrom.requestTimeout;
        this.maxRetries = copyFrom.maxRetries;
        this.retryableExceptions = copyFrom.retryableExceptions;
        this.debug = copyFrom.debug;
        this.statsProvider = copyFrom.statsProvider;
    }

    public Amount<Long, Time> getRequestTimeout() {
        return this.requestTimeout;
    }

    public Amount<Long, Time> getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public ImmutableSet<Class<? extends Exception>> getRetryableExceptions() {
        return this.retryableExceptions;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean enableStats() {
        return this.enableStats;
    }

    public StatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        private Builder() {
        }

        private Builder(Config template) {
            super(template);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Config create() {
            return this.getConfig();
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder> {
        private final Config config;

        AbstractBuilder() {
            this.config = new Config();
        }

        AbstractBuilder(Config template) {
            Preconditions.checkNotNull((Object)template);
            this.config = new Config(template);
        }

        protected abstract T getThis();

        public final T blocking() {
            this.config.requestTimeout = DEADLINE_BLOCKING;
            return this.getThis();
        }

        public final T withRequestTimeout(Amount<Long, Time> timeout) {
            Preconditions.checkNotNull(timeout);
            Preconditions.checkArgument(((Long)timeout.getValue() >= 0L ? 1 : 0) != 0, (String)"A negative deadline is invalid: %s", (Object[])new Object[]{timeout});
            this.config.requestTimeout = timeout;
            return this.getThis();
        }

        public final T withConnectTimeout(Amount<Long, Time> timeout) {
            Preconditions.checkNotNull(timeout);
            Preconditions.checkArgument(((Long)timeout.getValue() >= 0L ? 1 : 0) != 0, (String)"A negative deadline is invalid: %s", (Object[])new Object[]{timeout});
            this.config.connectTimeout = timeout;
            return this.getThis();
        }

        public final T noRetries() {
            this.config.maxRetries = 0;
            this.config.retryableExceptions = ImmutableSet.of();
            return this.getThis();
        }

        public final T withRetries(int retries) {
            Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (String)"A negative retry count is invalid: %d", (Object[])new Object[]{retries});
            this.config.maxRetries = retries;
            return this.getThis();
        }

        public final T retryOn(Iterable<? extends Class<? extends Exception>> retryableExceptions) {
            Preconditions.checkNotNull(retryableExceptions);
            ImmutableSet classes = ImmutableSet.copyOf((Iterable)Iterables.filter(retryableExceptions, (Predicate)Predicates.notNull()));
            Preconditions.checkArgument((!classes.isEmpty() ? 1 : 0) != 0, (Object)"Must provide at least one retryable exception class");
            this.config.retryableExceptions = classes;
            return this.getThis();
        }

        public final T retryOn(Class<? extends Exception> exception) {
            Preconditions.checkNotNull(exception);
            this.config.retryableExceptions = ImmutableSet.builder().add(exception).build();
            return this.getThis();
        }

        public final T withDebug(boolean debug) {
            this.config.debug = debug;
            return this.getThis();
        }

        public T disableStats() {
            this.config.enableStats = false;
            return this.getThis();
        }

        public T withStatsProvider(StatsProvider statsProvider) {
            this.config.statsProvider = (StatsProvider)Preconditions.checkNotNull((Object)statsProvider);
            return this.getThis();
        }

        protected final Config getConfig() {
            return this.config;
        }
    }
}

