/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift;

import com.google.common.base.Preconditions;
import com.twitter.common.net.pool.Connection;
import java.net.InetSocketAddress;
import org.apache.thrift.transport.TTransport;

public class TTransportConnection
implements Connection<TTransport, InetSocketAddress> {
    private final TTransport transport;
    private final InetSocketAddress endpoint;

    public TTransportConnection(TTransport transport, InetSocketAddress endpoint) {
        this.transport = (TTransport)Preconditions.checkNotNull((Object)transport);
        this.endpoint = (InetSocketAddress)Preconditions.checkNotNull((Object)endpoint);
    }

    public boolean isValid() {
        return this.transport.isOpen();
    }

    public TTransport get() {
        return this.transport;
    }

    public void close() {
        this.transport.close();
    }

    public InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        return this.endpoint.toString();
    }
}

