/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.net.loadbalancing.RequestTracker;
import com.twitter.common.net.pool.Connection;
import com.twitter.common.net.pool.ObjectPool;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.StatsProvider;
import com.twitter.common.thrift.Config;
import com.twitter.common.thrift.callers.Caller;
import com.twitter.common.thrift.callers.DeadlineCaller;
import com.twitter.common.thrift.callers.DebugCaller;
import com.twitter.common.thrift.callers.RetryingCaller;
import com.twitter.common.thrift.callers.StatTrackingCaller;
import com.twitter.common.thrift.callers.ThriftCaller;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class Thrift<T> {
    public static final Config DEFAULT_CONFIG = ((Config.Builder)((Config.Builder)((Config.Builder)Config.builder().withRequestTimeout((Amount<Long, Time>)Amount.of((long)1L, (Unit)Time.SECONDS))).noRetries()).retryOn(TTransportException.class)).create();
    public static final Config DEFAULT_ASYNC_CONFIG = ((Config.Builder)((Config.Builder)((Config.Builder)Config.builder(DEFAULT_CONFIG).withRequestTimeout((Amount<Long, Time>)Amount.of((long)0L, (Unit)Time.SECONDS))).noRetries()).retryOn((Iterable<Class<Exception>>)ImmutableSet.builder().add(IOException.class).add(TTransportException.class).build())).create();
    private final Config defaultConfig;
    private final ExecutorService executorService;
    private final ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool;
    private final RequestTracker<InetSocketAddress> requestTracker;
    private final String serviceName;
    private final Class<T> serviceInterface;
    private final Function<TTransport, T> clientFactory;
    private final boolean async;
    private final boolean withSsl;

    public Thrift(ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool, RequestTracker<InetSocketAddress> requestTracker, String serviceName, Class<T> serviceInterface, Function<TTransport, T> clientFactory) {
        this(DEFAULT_CONFIG, connectionPool, requestTracker, serviceName, serviceInterface, clientFactory, false, false);
    }

    public Thrift(ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool, RequestTracker<InetSocketAddress> requestTracker, String serviceName, Class<T> serviceInterface, Function<TTransport, T> clientFactory, boolean async) {
        this(Thrift.getConfig(async), connectionPool, requestTracker, serviceName, serviceInterface, clientFactory, async, false);
    }

    public Thrift(ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool, RequestTracker<InetSocketAddress> requestTracker, String serviceName, Class<T> serviceInterface, Function<TTransport, T> clientFactory, boolean async, boolean ssl) {
        this(Thrift.getConfig(async), connectionPool, requestTracker, serviceName, serviceInterface, clientFactory, async, ssl);
    }

    public Thrift(Config config, ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool, RequestTracker<InetSocketAddress> requestTracker, String serviceName, Class<T> serviceInterface, Function<TTransport, T> clientFactory, boolean async, boolean ssl) {
        this(config, Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Thrift[" + serviceName + "][%d]").build()), connectionPool, requestTracker, serviceName, serviceInterface, clientFactory, async, ssl);
    }

    public Thrift(ExecutorService executorService, ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool, RequestTracker<InetSocketAddress> requestTracker, String serviceName, Class<T> serviceInterface, Function<TTransport, T> clientFactory, boolean async, boolean ssl) {
        this(Thrift.getConfig(async), executorService, connectionPool, requestTracker, serviceName, serviceInterface, clientFactory, async, ssl);
    }

    private static Config getConfig(boolean async) {
        return async ? DEFAULT_ASYNC_CONFIG : DEFAULT_CONFIG;
    }

    public Thrift(Config config, ExecutorService executorService, ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool, RequestTracker<InetSocketAddress> requestTracker, String serviceName, Class<T> serviceInterface, Function<TTransport, T> clientFactory, boolean async, boolean ssl) {
        this.defaultConfig = (Config)Preconditions.checkNotNull((Object)config);
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.connectionPool = (ObjectPool)Preconditions.checkNotNull(connectionPool);
        this.requestTracker = (RequestTracker)Preconditions.checkNotNull(requestTracker);
        this.serviceName = MorePreconditions.checkNotBlank((String)serviceName);
        this.serviceInterface = Thrift.checkServiceInterface(serviceInterface);
        this.clientFactory = (Function)Preconditions.checkNotNull(clientFactory);
        this.async = async;
        this.withSsl = ssl;
    }

    static <I> Class<I> checkServiceInterface(Class<I> serviceInterface) {
        Preconditions.checkNotNull(serviceInterface);
        Preconditions.checkArgument((boolean)serviceInterface.isInterface(), (String)"%s must be a thrift service interface", (Object[])new Object[]{serviceInterface});
        return serviceInterface;
    }

    public void close() {
        this.connectionPool.close();
        this.executorService.shutdown();
    }

    public ClientBuilder builder() {
        return this.builder(this.defaultConfig);
    }

    public ClientBuilder builder(Config config) {
        Preconditions.checkNotNull((Object)config);
        return new ClientBuilder(config);
    }

    public T create() {
        return this.createClient(this.defaultConfig);
    }

    private T createClient(Config config) {
        StatsProvider statsProvider = config.getStatsProvider();
        boolean debug = config.isDebug();
        Caller decorated = new ThriftCaller<T>(this.connectionPool, this.requestTracker, this.clientFactory, config.getConnectTimeout(), debug);
        if (config.getMaxRetries() > 0) {
            decorated = new RetryingCaller(decorated, this.async, statsProvider, this.serviceName, config.getMaxRetries(), config.getRetryableExceptions(), debug);
        }
        if ((Long)config.getRequestTimeout().getValue() > 0L) {
            Preconditions.checkArgument((!this.async ? 1 : 0) != 0, (Object)"Request deadlines may not be used with an asynchronous client.");
            decorated = new DeadlineCaller(decorated, this.async, this.executorService, config.getRequestTimeout());
        }
        if (debug) {
            decorated = new DebugCaller(decorated, this.async);
        }
        if (config.enableStats()) {
            decorated = new StatTrackingCaller(decorated, this.async, statsProvider, this.serviceName);
        }
        final ThriftCaller<T> caller = decorated;
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] args) throws Throwable {
                AsyncMethodCallback callback = null;
                if (args != null && Thrift.this.async) {
                    ArrayList argsList = Lists.newArrayList((Object[])args);
                    callback = Thrift.extractCallback(argsList);
                    args = argsList.toArray();
                }
                return caller.call(method, args, callback, null);
            }
        };
        Object instance = Proxy.newProxyInstance(this.serviceInterface.getClassLoader(), new Class[]{this.serviceInterface}, invocationHandler);
        return (T)instance;
    }

    private static AsyncMethodCallback extractCallback(List<Object> args) {
        Preconditions.checkArgument((args.size() > 0 ? 1 : 0) != 0);
        Object lastArg = args.get(args.size() - 1);
        Preconditions.checkArgument((boolean)(lastArg instanceof AsyncMethodCallback), (Object)"Last argument of an async thrift call is expected to be of type AsyncMethodCallback.");
        return (AsyncMethodCallback)args.remove(args.size() - 1);
    }

    public final class ClientBuilder
    extends Config.AbstractBuilder<ClientBuilder> {
        private ClientBuilder(Config template) {
            super(template);
        }

        @Override
        protected ClientBuilder getThis() {
            return this;
        }

        public T create() {
            return Thrift.this.createClient(this.getConfig());
        }
    }
}

