/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.twitter.thrift.Endpoint;
import com.twitter.thrift.ServiceInstance;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;

public class Util {
    public static Function<ServiceInstance, InetSocketAddress> GET_ADDRESS = new Function<ServiceInstance, InetSocketAddress>(){

        public InetSocketAddress apply(ServiceInstance serviceInstance) {
            Endpoint endpoint = serviceInstance.getServiceEndpoint();
            return InetSocketAddress.createUnresolved(endpoint.getHost(), endpoint.getPort());
        }
    };
    public static final Predicate<ServiceInstance> IS_ALIVE = new Predicate<ServiceInstance>(){

        public boolean apply(ServiceInstance serviceInstance) {
            switch (serviceInstance.getStatus()) {
                case ALIVE: {
                    return true;
                }
                case WARNING: {
                    return true;
                }
            }
            return false;
        }
    };
    private static final String METADATA_MAP_FIELD_NAME = "metaDataMap";

    public static String prettyPrint(TBase t) {
        return t == null ? "null" : Util.printTbase(t, 0);
    }

    private static String printValue(Object o, int depth) {
        if (o == null) {
            return "null";
        }
        if (TBase.class.isAssignableFrom(o.getClass())) {
            return "\n" + Util.printTbase((TBase)o, depth + 1);
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            return Util.printMap((Map)o, depth + 1);
        }
        if (List.class.isAssignableFrom(o.getClass())) {
            return Util.printList((List)o, depth + 1);
        }
        if (Set.class.isAssignableFrom(o.getClass())) {
            return Util.printSet((Set)o, depth + 1);
        }
        if (String.class == o.getClass()) {
            return '\"' + o.toString() + '\"';
        }
        return o.toString();
    }

    private static String printTbase(TBase t, int depth) {
        ArrayList fields = Lists.newArrayList();
        for (Map.Entry entry : FieldMetaData.getStructMetaDataMap(t.getClass()).entrySet()) {
            String strValue;
            boolean fieldSet = t.isSet((TFieldIdEnum)entry.getKey());
            if (fieldSet) {
                Object value = t.getFieldValue((TFieldIdEnum)entry.getKey());
                strValue = Util.printValue(value, depth);
            } else {
                strValue = "not set";
            }
            fields.add(Util.tabs(depth) + ((FieldMetaData)entry.getValue()).fieldName + ": " + strValue);
        }
        return Joiner.on((String)"\n").join((Iterable)fields);
    }

    private static String printMap(Map<?, ?> map, int depth) {
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            entries.add(Util.tabs(depth) + Util.printValue(entry.getKey(), depth) + " = " + Util.printValue(entry.getValue(), depth));
        }
        return entries.isEmpty() ? "{}" : String.format("{\n%s\n%s}", Joiner.on((String)",\n").join((Iterable)entries), Util.tabs(depth - 1));
    }

    private static String printList(List<?> list, int depth) {
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            entries.add(String.format("%sItem[%d] = %s", Util.tabs(depth), i, Util.printValue(list.get(i), depth)));
        }
        return entries.isEmpty() ? "[]" : String.format("[\n%s\n%s]", Joiner.on((String)",\n").join((Iterable)entries), Util.tabs(depth - 1));
    }

    private static String printSet(Set<?> set, int depth) {
        ArrayList entries = Lists.newArrayList();
        for (Object item : set) {
            entries.add(String.format("%sItem = %s", Util.tabs(depth), Util.printValue(item, depth)));
        }
        return entries.isEmpty() ? "{}" : String.format("{\n%s\n%s}", Joiner.on((String)",\n").join((Iterable)entries), Util.tabs(depth - 1));
    }

    private static String tabs(int n) {
        return Strings.repeat((String)"  ", (int)n);
    }

    private Util() {
    }
}

