/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.callers;

import com.google.common.base.Preconditions;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

public interface Caller {
    public Object call(Method var1, Object[] var2, @Nullable AsyncMethodCallback var3, @Nullable Amount<Long, Time> var4) throws Throwable;

    public static class WrappedMethodCallback
    implements AsyncMethodCallback {
        private final AsyncMethodCallback wrapped;
        private final ResultCapture capture;
        private boolean callbackTriggered = false;

        public WrappedMethodCallback(AsyncMethodCallback wrapped, ResultCapture capture) {
            this.wrapped = wrapped;
            this.capture = capture;
        }

        private void callbackTriggered() {
            Preconditions.checkState((!this.callbackTriggered ? 1 : 0) != 0, (Object)"Each callback may only be triggered once.");
            this.callbackTriggered = true;
        }

        public void onComplete(Object o) {
            this.capture.success();
            this.wrapped.onComplete(o);
            this.callbackTriggered();
        }

        public void onError(Throwable t) {
            if (this.capture.fail(t)) {
                this.wrapped.onError(t);
                this.callbackTriggered();
            }
        }
    }

    public static interface ResultCapture {
        public void success();

        public boolean fail(Throwable var1);
    }
}

