/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.callers;

import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.thrift.callers.Caller;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

abstract class CallerDecorator
implements Caller {
    private final Caller decoratedCaller;
    private final boolean async;

    CallerDecorator(Caller decoratedCaller, boolean async) {
        this.decoratedCaller = decoratedCaller;
        this.async = async;
    }

    protected final Object invoke(Method method, Object[] args, @Nullable AsyncMethodCallback callback, @Nullable Caller.ResultCapture capture, @Nullable Amount<Long, Time> connectTimeoutOverride) throws Throwable {
        if (callback != null) {
            callback = new Caller.WrappedMethodCallback(callback, capture);
        }
        try {
            Object result = this.decoratedCaller.call(method, args, callback, connectTimeoutOverride);
            if (callback == null && capture != null) {
                capture.success();
            }
            return result;
        }
        catch (Throwable t) {
            if (callback != null) {
                callback.onError(t);
                return null;
            }
            if (capture != null) {
                capture.fail(t);
            }
            throw t;
        }
    }

    boolean isAsync() {
        return this.async;
    }
}

