/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.callers;

import com.google.common.base.Throwables;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.thrift.TResourceExhaustedException;
import com.twitter.common.thrift.TTimeoutException;
import com.twitter.common.thrift.callers.Caller;
import com.twitter.common.thrift.callers.CallerDecorator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

public class DeadlineCaller
extends CallerDecorator {
    private final ExecutorService executorService;
    private final Amount<Long, Time> timeout;

    public DeadlineCaller(Caller decoratedCaller, boolean async, ExecutorService executorService, Amount<Long, Time> timeout) {
        super(decoratedCaller, async);
        this.executorService = executorService;
        this.timeout = timeout;
    }

    @Override
    public Object call(final Method method, final Object[] args, final @Nullable AsyncMethodCallback callback, final @Nullable Amount<Long, Time> connectTimeoutOverride) throws Throwable {
        try {
            Future<Object> result = this.executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        return DeadlineCaller.this.invoke(method, args, callback, null, (Amount<Long, Time>)connectTimeoutOverride);
                    }
                    catch (Throwable t) {
                        Throwables.propagateIfInstanceOf((Throwable)t, Exception.class);
                        throw new RuntimeException(t);
                    }
                }
            });
            try {
                return result.get((Long)this.timeout.getValue(), ((Time)this.timeout.getUnit()).getTimeUnit());
            }
            catch (TimeoutException e) {
                result.cancel(true);
                throw new TTimeoutException(e);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        catch (RejectedExecutionException e) {
            throw new TResourceExhaustedException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

