/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.callers;

import com.google.common.base.Joiner;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.thrift.callers.Caller;
import com.twitter.common.thrift.callers.CallerDecorator;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

public class DebugCaller
extends CallerDecorator {
    private static final Logger LOG = Logger.getLogger(DebugCaller.class.getName());
    private static final Joiner ARG_JOINER = Joiner.on((String)", ");

    public DebugCaller(Caller decoratedCaller, boolean async) {
        super(decoratedCaller, async);
    }

    @Override
    public Object call(final Method method, final Object[] args, @Nullable AsyncMethodCallback callback, @Nullable Amount<Long, Time> connectTimeoutOverride) throws Throwable {
        Caller.ResultCapture capture = new Caller.ResultCapture(){

            @Override
            public void success() {
            }

            @Override
            public boolean fail(Throwable t) {
                StringBuilder message = new StringBuilder("Thrift call failed: ");
                message.append(method.getName()).append("(");
                ARG_JOINER.appendTo(message, args);
                message.append(")");
                LOG.warning(message.toString());
                return true;
            }
        };
        try {
            return this.invoke(method, args, callback, capture, connectTimeoutOverride);
        }
        catch (Throwable t) {
            capture.fail(t);
            throw t;
        }
    }
}

