/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.callers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.StatsProvider;
import com.twitter.common.thrift.TResourceExhaustedException;
import com.twitter.common.thrift.callers.Caller;
import com.twitter.common.thrift.callers.CallerDecorator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

public class RetryingCaller
extends CallerDecorator {
    private static final Logger LOG = Logger.getLogger(RetryingCaller.class.getName());
    @VisibleForTesting
    public static final Amount<Long, Time> NONBLOCKING_TIMEOUT = Amount.of((long)-1L, (Unit)Time.MILLISECONDS);
    private final StatsProvider statsProvider;
    private final String serviceName;
    private final int retries;
    private final ImmutableSet<Class<? extends Exception>> retryableExceptions;
    private final boolean debug;
    private final LoadingCache<Method, AtomicLong> stats = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Method, AtomicLong>(){

        public AtomicLong load(Method method) {
            return RetryingCaller.this.statsProvider.makeCounter(RetryingCaller.this.serviceName + "_" + method.getName() + "_retries");
        }
    });
    private final LoadingCache<Class<? extends Throwable>, Boolean> isRetryable = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends Throwable>, Boolean>(){

        public Boolean load(Class<? extends Throwable> exceptionClass) {
            return RetryingCaller.this.isRetryable(exceptionClass);
        }
    });
    private static final Joiner STACK_TRACE_JOINER = Joiner.on((char)'\n');

    public RetryingCaller(Caller decoratedCall, boolean async, StatsProvider statsProvider, String serviceName, int retries, ImmutableSet<Class<? extends Exception>> retryableExceptions, boolean debug) {
        super(decoratedCall, async);
        this.statsProvider = statsProvider;
        this.serviceName = serviceName;
        this.retries = retries;
        this.retryableExceptions = retryableExceptions;
        this.debug = debug;
    }

    @Override
    public Object call(final Method method, final Object[] args, final @Nullable AsyncMethodCallback callback, @Nullable Amount<Long, Time> connectTimeoutOverride) throws Throwable {
        final AtomicLong retryCounter = (AtomicLong)this.stats.get((Object)method);
        final AtomicInteger attempts = new AtomicInteger();
        final ArrayList exceptions = Lists.newArrayList();
        Caller.ResultCapture capture = new Caller.ResultCapture(){

            @Override
            public void success() {
            }

            @Override
            public boolean fail(Throwable t) {
                if (!RetryingCaller.this.isRetryable(t)) {
                    if (RetryingCaller.this.debug) {
                        LOG.warning(String.format("Call failed with un-retryable exception of [%s]: %s, previous exceptions: %s", t.getClass().getName(), t.getMessage(), RetryingCaller.combineStackTraces(exceptions)));
                    }
                    return true;
                }
                if (attempts.get() >= RetryingCaller.this.retries) {
                    exceptions.add(t);
                    if (RetryingCaller.this.debug) {
                        LOG.warning(String.format("Retried %d times, last error: %s, exceptions: %s", attempts.get(), t, RetryingCaller.combineStackTraces(exceptions)));
                    }
                    return true;
                }
                exceptions.add(t);
                if (RetryingCaller.this.isAsync() && attempts.incrementAndGet() <= RetryingCaller.this.retries) {
                    try {
                        retryCounter.incrementAndGet();
                        RetryingCaller.this.invoke(method, args, callback, this, NONBLOCKING_TIMEOUT);
                    }
                    catch (Throwable throwable) {
                        return this.fail(throwable);
                    }
                }
                return false;
            }
        };
        while (true) {
            try {
                return this.invoke(method, args, callback, capture, connectTimeoutOverride);
            }
            catch (Throwable t) {
                boolean continueLoop;
                if (!this.isRetryable(t)) {
                    Throwable propagated = t;
                    if (!exceptions.isEmpty() && t instanceof TResourceExhaustedException) {
                        propagated = (Throwable)exceptions.remove(exceptions.size() - 1);
                    }
                    if (this.isAsync()) {
                        callback.onError(propagated);
                    } else {
                        throw propagated;
                    }
                }
                boolean bl = continueLoop = !this.isAsync() && attempts.incrementAndGet() <= this.retries;
                if (!continueLoop) continue;
                retryCounter.incrementAndGet();
                if (continueLoop) continue;
                Throwable lastRetriedException = (Throwable)Iterables.getLast((Iterable)exceptions);
                if (this.debug) {
                    if (!exceptions.isEmpty()) {
                        LOG.warning(String.format("Retried %d times, last error: %s, previous exceptions: %s", attempts.get(), lastRetriedException, RetryingCaller.combineStackTraces(exceptions)));
                    } else {
                        LOG.warning(String.format("Retried 1 time, last error: %s", lastRetriedException));
                    }
                }
                if (!this.isAsync()) {
                    throw lastRetriedException;
                }
                return null;
            }
            break;
        }
    }

    private boolean isRetryable(Throwable throwable) {
        return (Boolean)this.isRetryable.getUnchecked(throwable.getClass());
    }

    private boolean isRetryable(final Class<? extends Throwable> exceptionClass) {
        if (this.retryableExceptions.contains(exceptionClass)) {
            return true;
        }
        return Iterables.any(this.retryableExceptions, (Predicate)new Predicate<Class<? extends Exception>>(){

            public boolean apply(Class<? extends Exception> retryableExceptionClass) {
                return retryableExceptionClass.isAssignableFrom(exceptionClass);
            }
        });
    }

    private static String combineStackTraces(List<Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            return "none";
        }
        return STACK_TRACE_JOINER.join(Iterables.transform(exceptions, (Function)new Function<Throwable, String>(){
            private int index = 1;

            public String apply(Throwable exception) {
                return String.format("[%d] %s", this.index++, Throwables.getStackTraceAsString((Throwable)exception));
            }
        }));
    }
}

