/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.callers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.stats.StatsProvider;
import com.twitter.common.thrift.TResourceExhaustedException;
import com.twitter.common.thrift.TTimeoutException;
import com.twitter.common.thrift.callers.Caller;
import com.twitter.common.thrift.callers.CallerDecorator;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;

public class StatTrackingCaller
extends CallerDecorator {
    private final StatsProvider statsProvider;
    private final String serviceName;
    private final LoadingCache<Method, StatsProvider.RequestTimer> stats = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Method, StatsProvider.RequestTimer>(){

        public StatsProvider.RequestTimer load(Method method) {
            return StatTrackingCaller.this.statsProvider.makeRequestTimer(StatTrackingCaller.this.serviceName + "_" + method.getName());
        }
    });

    public StatTrackingCaller(Caller decoratedCaller, boolean async, StatsProvider statsProvider, String serviceName) {
        super(decoratedCaller, async);
        this.statsProvider = statsProvider;
        this.serviceName = serviceName;
    }

    @Override
    public Object call(Method method, Object[] args, @Nullable AsyncMethodCallback callback, @Nullable Amount<Long, Time> connectTimeoutOverride) throws Throwable {
        final StatsProvider.RequestTimer requestStats = (StatsProvider.RequestTimer)this.stats.get((Object)method);
        final long startTime = System.nanoTime();
        Caller.ResultCapture capture = new Caller.ResultCapture(){

            @Override
            public void success() {
                requestStats.requestComplete(TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime));
            }

            @Override
            public boolean fail(Throwable t) {
                if (t instanceof TTimeoutException || t instanceof TimeoutException) {
                    requestStats.incTimeouts();
                    return true;
                }
                if (!(t instanceof TResourceExhaustedException)) {
                    requestStats.incReconnects();
                }
                requestStats.incErrors();
                return true;
            }
        };
        return this.invoke(method, args, callback, capture, connectTimeoutOverride);
    }
}

