/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.callers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.twitter.common.net.loadbalancing.RequestTracker;
import com.twitter.common.net.pool.Connection;
import com.twitter.common.net.pool.ObjectPool;
import com.twitter.common.net.pool.ResourceExhaustedException;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.thrift.TResourceExhaustedException;
import com.twitter.common.thrift.TTimeoutException;
import com.twitter.common.thrift.callers.Caller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.transport.TTransport;

public class ThriftCaller<T>
implements Caller {
    private static final Logger LOG = Logger.getLogger(ThriftCaller.class.getName());
    private final ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool;
    private final RequestTracker<InetSocketAddress> requestTracker;
    private final Function<TTransport, T> clientFactory;
    private final Amount<Long, Time> timeout;
    private final boolean debug;

    public ThriftCaller(ObjectPool<Connection<TTransport, InetSocketAddress>> connectionPool, RequestTracker<InetSocketAddress> requestTracker, Function<TTransport, T> clientFactory, Amount<Long, Time> timeout, boolean debug) {
        this.connectionPool = connectionPool;
        this.requestTracker = requestTracker;
        this.clientFactory = clientFactory;
        this.timeout = timeout;
        this.debug = debug;
    }

    @Override
    public Object call(Method method, Object[] args, @Nullable AsyncMethodCallback callback, @Nullable Amount<Long, Time> connectTimeoutOverride) throws Throwable {
        final Connection<TTransport, InetSocketAddress> connection = this.getConnection(connectTimeoutOverride);
        final long startNanos = System.nanoTime();
        Caller.ResultCapture capture = new Caller.ResultCapture(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void success() {
                try {
                    ThriftCaller.this.requestTracker.requestResult(connection.getEndpoint(), RequestTracker.RequestResult.SUCCESS, System.nanoTime() - startNanos);
                }
                finally {
                    ThriftCaller.this.connectionPool.release((Object)connection);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean fail(Throwable t) {
                if (ThriftCaller.this.debug) {
                    LOG.warning(String.format("Call to endpoint: %s failed: %s", connection, t));
                }
                try {
                    ThriftCaller.this.requestTracker.requestResult(connection.getEndpoint(), RequestTracker.RequestResult.FAILED, System.nanoTime() - startNanos);
                }
                finally {
                    ThriftCaller.this.connectionPool.remove((Object)connection);
                }
                return true;
            }
        };
        return ThriftCaller.invokeMethod(this.clientFactory.apply(connection.get()), method, args, callback, capture);
    }

    private static Object invokeMethod(Object target, Method method, Object[] args, AsyncMethodCallback callback, Caller.ResultCapture capture) throws Throwable {
        if (callback != null) {
            callback = new Caller.WrappedMethodCallback(callback, capture);
            ArrayList argsList = Lists.newArrayList((Object[])args);
            argsList.add(callback);
            args = argsList.toArray();
        }
        try {
            Object result = method.invoke(target, args);
            if (callback == null) {
                capture.success();
            }
            return result;
        }
        catch (InvocationTargetException t) {
            if (callback != null) {
                callback.onError(t.getCause());
                return null;
            }
            capture.fail(t.getCause());
            throw t.getCause();
        }
    }

    private Connection<TTransport, InetSocketAddress> getConnection(Amount<Long, Time> connectTimeoutOverride) throws TResourceExhaustedException, TTimeoutException {
        try {
            Connection connection;
            if (connectTimeoutOverride != null) {
                connection = (Connection)this.connectionPool.get(connectTimeoutOverride);
            } else {
                Connection connection2 = connection = (Long)this.timeout.getValue() > 0L ? (Connection)this.connectionPool.get(this.timeout) : (Connection)this.connectionPool.get();
            }
            if (connection == null) {
                throw new TResourceExhaustedException("no connection was available");
            }
            return connection;
        }
        catch (ResourceExhaustedException e) {
            throw new TResourceExhaustedException(e);
        }
        catch (TimeoutException e) {
            throw new TTimeoutException(e);
        }
    }
}

