/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.monitoring;

import com.google.common.base.Preconditions;
import com.twitter.common.net.loadbalancing.RequestTracker;
import com.twitter.common.thrift.monitoring.TMonitoredServerSocket;
import java.net.InetSocketAddress;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;

public class TMonitoredProcessor
implements TProcessor {
    private final TProcessor wrapped;
    private final TMonitoredServerSocket monitoredServerSocket;
    private final RequestTracker<InetSocketAddress> monitor;

    public TMonitoredProcessor(TProcessor wrapped, TMonitoredServerSocket monitoredServerSocket, RequestTracker<InetSocketAddress> monitor) {
        this.wrapped = (TProcessor)Preconditions.checkNotNull((Object)wrapped);
        this.monitoredServerSocket = (TMonitoredServerSocket)((Object)Preconditions.checkNotNull((Object)((Object)monitoredServerSocket)));
        this.monitor = (RequestTracker)Preconditions.checkNotNull(monitor);
    }

    public boolean process(TProtocol in, TProtocol out) throws TException {
        InetSocketAddress address;
        boolean bl;
        long startNanos = System.nanoTime();
        boolean exceptionThrown = false;
        try {
            bl = this.wrapped.process(in, out);
            address = this.monitoredServerSocket.getAddress((TSocket)in.getTransport());
            Preconditions.checkState((address != null ? 1 : 0) != 0, (Object)("Address unknown for transport " + in.getTransport()));
        }
        catch (TException e) {
            try {
                exceptionThrown = true;
                throw e;
            }
            catch (Throwable throwable) {
                InetSocketAddress address2 = this.monitoredServerSocket.getAddress((TSocket)in.getTransport());
                Preconditions.checkState((address2 != null ? 1 : 0) != 0, (Object)("Address unknown for transport " + in.getTransport()));
                this.monitor.requestResult((Object)address2, exceptionThrown ? RequestTracker.RequestResult.FAILED : RequestTracker.RequestResult.SUCCESS, System.nanoTime() - startNanos);
                throw throwable;
            }
        }
        this.monitor.requestResult((Object)address, exceptionThrown ? RequestTracker.RequestResult.FAILED : RequestTracker.RequestResult.SUCCESS, System.nanoTime() - startNanos);
        return bl;
    }
}

