/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.thrift.monitoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.twitter.common.net.monitoring.ConnectionMonitor;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.Map;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;

public class TMonitoredServerSocket
extends TServerSocket {
    private ConnectionMonitor<InetSocketAddress> monitor;
    private final Map<TSocket, InetSocketAddress> addressMap = Collections.synchronizedMap(Maps.newHashMap());

    public TMonitoredServerSocket(ServerSocket serverSocket, ConnectionMonitor<InetSocketAddress> monitor) {
        super(serverSocket);
        this.monitor = (ConnectionMonitor)Preconditions.checkNotNull(monitor);
    }

    public TMonitoredServerSocket(ServerSocket serverSocket, int clientTimeout, ConnectionMonitor<InetSocketAddress> monitor) {
        super(serverSocket, clientTimeout);
        this.monitor = (ConnectionMonitor)Preconditions.checkNotNull(monitor);
    }

    public TMonitoredServerSocket(int port, ConnectionMonitor<InetSocketAddress> monitor) throws TTransportException {
        super(port);
        this.monitor = (ConnectionMonitor)Preconditions.checkNotNull(monitor);
    }

    public TMonitoredServerSocket(int port, int clientTimeout, ConnectionMonitor<InetSocketAddress> monitor) throws TTransportException {
        super(port, clientTimeout);
        this.monitor = (ConnectionMonitor)Preconditions.checkNotNull(monitor);
    }

    public TMonitoredServerSocket(InetSocketAddress bindAddr, ConnectionMonitor<InetSocketAddress> monitor) throws TTransportException {
        super(bindAddr);
        this.monitor = (ConnectionMonitor)Preconditions.checkNotNull(monitor);
    }

    public TMonitoredServerSocket(InetSocketAddress bindAddr, int clientTimeout, ConnectionMonitor<InetSocketAddress> monitor) throws TTransportException {
        super(bindAddr, clientTimeout);
        this.monitor = (ConnectionMonitor)Preconditions.checkNotNull(monitor);
    }

    public InetSocketAddress getAddress(TSocket socket) {
        return this.addressMap.get(socket);
    }

    protected TSocket acceptImpl() throws TTransportException {
        TSocket socket = super.acceptImpl();
        final InetSocketAddress remoteAddress = (InetSocketAddress)socket.getSocket().getRemoteSocketAddress();
        TSocket monitoredSocket = new TSocket(socket.getSocket()){
            boolean closed;
            {
                super(x0);
                this.closed = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                try {
                    super.close();
                }
                finally {
                    if (!this.closed) {
                        TMonitoredServerSocket.this.monitor.released((Object)remoteAddress);
                        TMonitoredServerSocket.this.addressMap.remove((Object)this);
                    }
                    this.closed = true;
                }
            }
        };
        this.addressMap.put(monitoredSocket, remoteAddress);
        this.monitor.connected((Object)remoteAddress);
        return monitoredSocket;
    }

    public void close() {
        super.close();
    }
}

