/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.providers;

import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.server.utils.ServerUtils;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Provider
@PreMatching
@Priority(value=3000)
public class AuthenticatedSubjectAliasFilter
implements ContainerRequestFilter {
    public void filter(@NotNull ContainerRequestContext requestContext) throws IOException {
        String requestPath = requestContext.getUriInfo().getPath();
        for (String alias : this.getAliases()) {
            if (!requestPath.startsWith(alias + "/") && !requestPath.equals(alias)) continue;
            try {
                String authSubjectPath = ServerUtils.encodeTemplateNames(this.getAuthenticatedSubjectPath(requestContext.getSecurityContext()));
                UriBuilder newRequestUri = requestContext.getUriInfo().getBaseUriBuilder();
                newRequestUri.path(authSubjectPath + requestPath.substring(alias.length()));
                MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
                for (String key : queryParams.keySet()) {
                    String escapedKey = ServerUtils.encodeTemplateNames(key);
                    ArrayList<String> escapedValues = new ArrayList<String>();
                    for (String value : (List)queryParams.get((Object)key)) {
                        escapedValues.add(ServerUtils.encodeTemplateNames(value));
                    }
                    newRequestUri.queryParam(escapedKey, escapedValues.toArray());
                }
                requestContext.setRequestUri(newRequestUri.build(new Object[0]));
            }
            catch (ScimException e) {
                requestContext.abortWith(ServerUtils.setAcceptableType(Response.status((int)e.getScimError().getStatus()).entity((Object)e.getScimError()), requestContext.getAcceptableMediaTypes()).build());
            }
            break;
        }
    }

    @NotNull
    protected String getAuthenticatedSubjectPath(@Nullable SecurityContext securityContext) throws ScimException {
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw new NotImplementedException("/Me not supported");
        }
        return "Users/" + securityContext.getUserPrincipal().toString();
    }

    @NotNull
    protected Collection<String> getAliases() {
        return Collections.singleton("Me");
    }
}

