/*
 * Copyright 2015 UnboundID Corp.
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2015 UnboundID Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.util;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.util package, which correspond to messages in the
 * unboundid-ldapsdk-util.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum UtilityMessages
{
  /**
   * The aggregate input stream does not support the use of mark and reset functionality.
   */
  ERR_AGGREGATE_INPUT_STREAM_MARK_NOT_SUPPORTED("The aggregate input stream does not support the use of mark and reset functionality."),



  /**
   * The provided string cannot be parsed as an argument list because it ends with a backslash that was not immediately preceded by another backslash.  The backslash character will be considered an escape to indicate that the next character should be included as-is with no interpretation.
   */
  ERR_ARG_STRING_DANGLING_BACKSLASH("The provided string cannot be parsed as an argument list because it ends with a backslash that was not immediately preceded by another backslash.  The backslash character will be considered an escape to indicate that the next character should be included as-is with no interpretation."),



  /**
   * The provided string cannot be parsed as an argument list because it has an unmatched quote starting at or near position {0}.
   */
  ERR_ARG_STRING_UNMATCHED_QUOTE("The provided string cannot be parsed as an argument list because it has an unmatched quote starting at or near position {0}."),



  /**
   * A base64-encoded string must have a length that is a multiple of 4 bytes.
   */
  ERR_BASE64_DECODE_INVALID_LENGTH("A base64-encoded string must have a length that is a multiple of 4 bytes."),



  /**
   * Invalid character ''{0}'' encountered.
   */
  ERR_BASE64_DECODE_UNEXPECTED_CHAR("Invalid character ''{0}'' encountered."),



  /**
   * Unexpected equal sign found at position {0,number,0}.
   */
  ERR_BASE64_DECODE_UNEXPECTED_EQUAL("Unexpected equal sign found at position {0,number,0}."),



  /**
   * The provided string did not have a valid length for base64url-encoded data.
   */
  ERR_BASE64_URLDECODE_INVALID_LENGTH("The provided string did not have a valid length for base64url-encoded data."),



  /**
   * The provided array is null.
   */
  ERR_BS_BUFFER_ARRAY_NULL("The provided array is null."),



  /**
   * The provided buffer is null.
   */
  ERR_BS_BUFFER_BUFFER_NULL("The provided buffer is null."),



  /**
   * The provided byte string is null.
   */
  ERR_BS_BUFFER_BYTE_STRING_NULL("The provided byte string is null."),



  /**
   * The provided capacity {0,number,0} is negative.
   */
  ERR_BS_BUFFER_CAPACITY_NEGATIVE("The provided capacity {0,number,0} is negative."),



  /**
   * The provided character sequence is null.
   */
  ERR_BS_BUFFER_CHAR_SEQUENCE_NULL("The provided character sequence is null."),



  /**
   * The provided length {0,number,0} is negative.
   */
  ERR_BS_BUFFER_LENGTH_NEGATIVE("The provided length {0,number,0} is negative."),



  /**
   * The provided offset {0,number,0} is negative.
   */
  ERR_BS_BUFFER_OFFSET_NEGATIVE("The provided offset {0,number,0} is negative."),



  /**
   * The provided offset {0,number,0} plus the provided length {1,number,0} is greater than the size of the provided array ({2,number,0}).
   */
  ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE("The provided offset {0,number,0} plus the provided length {1,number,0} is greater than the size of the provided array ({2,number,0})."),



  /**
   * The provided position {0,number,0} is negative.
   */
  ERR_BS_BUFFER_POS_NEGATIVE("The provided position {0,number,0} is negative."),



  /**
   * The provided position {0,number,0} is greater than the length of the buffer ({1,number,0}).
   */
  ERR_BS_BUFFER_POS_TOO_LARGE("The provided position {0,number,0} is greater than the length of the buffer ({1,number,0})."),



  /**
   * Unable to decode bytes ''{0}'' as a valid UUID because the length of the provided content was not exactly 128 bits.
   */
  ERR_DECODE_UUID_INVALID_LENGTH("Unable to decode bytes ''{0}'' as a valid UUID because the length of the provided content was not exactly 128 bits."),



  /**
   * Unable to parse the provided timestamp ''{0}'' because it had an invalid number of characters before the sub-second and/or time zone portion.
   */
  ERR_GENTIME_CANNOT_PARSE_INVALID_LENGTH("Unable to parse the provided timestamp ''{0}'' because it had an invalid number of characters before the sub-second and/or time zone portion."),



  /**
   * Unable to parse time zone information from the provided timestamp ''{0}''.
   */
  ERR_GENTIME_DECODE_CANNOT_PARSE_TZ("Unable to parse time zone information from the provided timestamp ''{0}''."),



  /**
   * No Exception
   */
  ERR_NO_EXCEPTION("No Exception"),



  /**
   * {0}.  Thread stack trace:  {1}
   */
  ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE("{0}.  Thread stack trace:  {1}"),



  /**
   * A result of true was found for a condition which the LDAP SDK requires to be false.  Thread stack trace {0}
   */
  ERR_VALIDATOR_FALSE_CHECK_FAILURE("A result of true was found for a condition which the LDAP SDK requires to be false.  Thread stack trace {0}"),



  /**
   * A null object was provided where a non-null object is required (non-null index {0,number,0}).  Thread stack trace:  {1}
   */
  ERR_VALIDATOR_NULL_CHECK_FAILURE("A null object was provided where a non-null object is required (non-null index {0,number,0}).  Thread stack trace:  {1}"),



  /**
   * A result of false was found for a condition which the LDAP SDK requires to be true.  Thread stack trace {0}
   */
  ERR_VALIDATOR_TRUE_CHECK_FAILURE("A result of false was found for a condition which the LDAP SDK requires to be true.  Thread stack trace {0}"),



  /**
   * {0,number,0} days
   */
  INFO_NUM_DAYS_PLURAL("{0,number,0} days"),



  /**
   * {0,number,0} day
   */
  INFO_NUM_DAYS_SINGULAR("{0,number,0} day"),



  /**
   * {0,number,0} hours
   */
  INFO_NUM_HOURS_PLURAL("{0,number,0} hours"),



  /**
   * {0,number,0} hour
   */
  INFO_NUM_HOURS_SINGULAR("{0,number,0} hour"),



  /**
   * {0,number,0} minutes
   */
  INFO_NUM_MINUTES_PLURAL("{0,number,0} minutes"),



  /**
   * {0,number,0} minute
   */
  INFO_NUM_MINUTES_SINGULAR("{0,number,0} minute"),



  /**
   * {0,number,0} seconds
   */
  INFO_NUM_SECONDS_PLURAL("{0,number,0} seconds"),



  /**
   * {0,number,0} second
   */
  INFO_NUM_SECONDS_SINGULAR("{0,number,0} second"),



  /**
   * {0} seconds
   */
  INFO_NUM_SECONDS_WITH_DECIMAL("{0} seconds");



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("unboundid-ldapsdk-util");
    } catch (Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<UtilityMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<UtilityMessages,String>();



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<UtilityMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<UtilityMessages,MessageFormat>();



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private UtilityMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages which do not take any arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        return defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }
    return s;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }
    synchronized (f)
    {
      return f.format(args);
    }
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    return get();
  }
}

