/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Constants;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;

public final class ASN1Boolean
extends ASN1Element {
    public static final ASN1Boolean UNIVERSAL_BOOLEAN_FALSE_ELEMENT = new ASN1Boolean(false);
    public static final ASN1Boolean UNIVERSAL_BOOLEAN_TRUE_ELEMENT = new ASN1Boolean(true);
    private static final long serialVersionUID = 7131700816847855524L;
    private final boolean booleanValue;

    public ASN1Boolean(boolean bl) {
        super((byte)1, bl ? ASN1Constants.BOOLEAN_VALUE_TRUE : ASN1Constants.BOOLEAN_VALUE_FALSE);
        this.booleanValue = bl;
    }

    public ASN1Boolean(byte by, boolean bl) {
        super(by, bl ? ASN1Constants.BOOLEAN_VALUE_TRUE : ASN1Constants.BOOLEAN_VALUE_FALSE);
        this.booleanValue = bl;
    }

    private ASN1Boolean(byte by, boolean bl, byte[] byArray) {
        super(by, byArray);
        this.booleanValue = bl;
    }

    public boolean booleanValue() {
        return this.booleanValue;
    }

    public static ASN1Boolean decodeAsBoolean(byte[] byArray) throws ASN1Exception {
        try {
            int n;
            int n2 = 2;
            int n3 = byArray[1] & 0x7F;
            if (n3 != byArray[1]) {
                int n4 = n3;
                n3 = 0;
                for (n = 0; n < n4; n += 1) {
                    n3 <<= 8;
                    n3 |= byArray[n2++] & 0xFF;
                }
            }
            if (byArray.length - n2 != n3) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(n3, byArray.length - n2));
            }
            if (!n3) {
                throw new ASN1Exception(ASN1Messages.ERR_BOOLEAN_INVALID_LENGTH.get());
            }
            byte[] byArray2 = new byte[]{byArray[n2]};
            n = byArray2[0] != 0 ? 1 : 0;
            return new ASN1Boolean(byArray[0], n != 0, byArray2);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(exception), exception);
        }
    }

    public static ASN1Boolean decodeAsBoolean(ASN1Element aSN1Element) throws ASN1Exception {
        byte[] byArray = aSN1Element.getValue();
        if (byArray.length != 1) {
            throw new ASN1Exception(ASN1Messages.ERR_BOOLEAN_INVALID_LENGTH.get());
        }
        if (byArray[0] == 0) {
            return new ASN1Boolean(aSN1Element.getType(), false, byArray);
        }
        return new ASN1Boolean(aSN1Element.getType(), true, byArray);
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.booleanValue);
    }
}

