/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1BufferSet;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ASN1Buffer
implements Serializable {
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x100000;
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_ONE = new byte[]{-127, 0};
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_TWO = new byte[]{-126, 0, 0};
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_THREE = new byte[]{-125, 0, 0, 0};
    private static final byte[] MULTIBYTE_LENGTH_HEADER_PLUS_FOUR = new byte[]{-124, 0, 0, 0, 0};
    private static final long serialVersionUID = -4898230771376551562L;
    private final AtomicBoolean zeroBufferOnClear;
    private final ByteStringBuffer buffer;
    private final int maxBufferSize;

    public ASN1Buffer() {
        this(0x100000);
    }

    public ASN1Buffer(int n) {
        this.maxBufferSize = n;
        this.buffer = new ByteStringBuffer();
        this.zeroBufferOnClear = new AtomicBoolean(false);
    }

    public boolean zeroBufferOnClear() {
        return this.zeroBufferOnClear.get();
    }

    public void setZeroBufferOnClear() {
        this.zeroBufferOnClear.set(true);
    }

    public void clear() {
        this.buffer.clear(this.zeroBufferOnClear.getAndSet(false));
        if (this.maxBufferSize > 0 && this.buffer.capacity() > this.maxBufferSize) {
            this.buffer.setCapacity(this.maxBufferSize);
        }
    }

    public int length() {
        return this.buffer.length();
    }

    public void addElement(ASN1Element aSN1Element) {
        aSN1Element.encodeTo(this.buffer);
    }

    public void addBoolean(boolean bl) {
        this.addBoolean((byte)1, bl);
    }

    public void addBoolean(byte by, boolean bl) {
        this.buffer.append(by);
        this.buffer.append((byte)1);
        if (bl) {
            this.buffer.append((byte)-1);
        } else {
            this.buffer.append((byte)0);
        }
    }

    public void addEnumerated(int n) {
        this.addInteger((byte)10, n);
    }

    public void addEnumerated(byte by, int n) {
        this.addInteger(by, n);
    }

    public void addInteger(int n) {
        this.addInteger((byte)2, n);
    }

    public void addInteger(byte by, int n) {
        this.buffer.append(by);
        if (n < 0) {
            if ((n & 0xFFFFFF80) == -128) {
                this.buffer.append((byte)1);
                this.buffer.append((byte)(n & 0xFF));
            } else if ((n & Short.MIN_VALUE) == Short.MIN_VALUE) {
                this.buffer.append((byte)2);
                this.buffer.append((byte)(n >> 8 & 0xFF));
                this.buffer.append((byte)(n & 0xFF));
            } else if ((n & 0xFF800000) == -8388608) {
                this.buffer.append((byte)3);
                this.buffer.append((byte)(n >> 16 & 0xFF));
                this.buffer.append((byte)(n >> 8 & 0xFF));
                this.buffer.append((byte)(n & 0xFF));
            } else {
                this.buffer.append((byte)4);
                this.buffer.append((byte)(n >> 24 & 0xFF));
                this.buffer.append((byte)(n >> 16 & 0xFF));
                this.buffer.append((byte)(n >> 8 & 0xFF));
                this.buffer.append((byte)(n & 0xFF));
            }
        } else if ((n & 0x7F) == n) {
            this.buffer.append((byte)1);
            this.buffer.append((byte)(n & 0x7F));
        } else if ((n & Short.MAX_VALUE) == n) {
            this.buffer.append((byte)2);
            this.buffer.append((byte)(n >> 8 & 0x7F));
            this.buffer.append((byte)(n & 0xFF));
        } else if ((n & 0x7FFFFF) == n) {
            this.buffer.append((byte)3);
            this.buffer.append((byte)(n >> 16 & 0x7F));
            this.buffer.append((byte)(n >> 8 & 0xFF));
            this.buffer.append((byte)(n & 0xFF));
        } else {
            this.buffer.append((byte)4);
            this.buffer.append((byte)(n >> 24 & 0x7F));
            this.buffer.append((byte)(n >> 16 & 0xFF));
            this.buffer.append((byte)(n >> 8 & 0xFF));
            this.buffer.append((byte)(n & 0xFF));
        }
    }

    public void addInteger(long l) {
        this.addInteger((byte)2, l);
    }

    public void addInteger(byte by, long l) {
        this.buffer.append(by);
        if (l < 0L) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == -128L) {
                this.buffer.append((byte)1);
                this.buffer.append((byte)(l & 0xFFL));
            } else if ((l & 0xFFFFFFFFFFFF8000L) == -32768L) {
                this.buffer.append((byte)2);
                this.buffer.append((byte)(l >> 8 & 0xFFL));
                this.buffer.append((byte)(l & 0xFFL));
            } else if ((l & 0xFFFFFFFFFF800000L) == -8388608L) {
                this.buffer.append((byte)3);
                this.buffer.append((byte)(l >> 16 & 0xFFL));
                this.buffer.append((byte)(l >> 8 & 0xFFL));
                this.buffer.append((byte)(l & 0xFFL));
            } else if ((l & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                this.buffer.append((byte)4);
                this.buffer.append((byte)(l >> 24 & 0xFFL));
                this.buffer.append((byte)(l >> 16 & 0xFFL));
                this.buffer.append((byte)(l >> 8 & 0xFFL));
                this.buffer.append((byte)(l & 0xFFL));
            } else if ((l & 0xFFFFFF8000000000L) == -549755813888L) {
                this.buffer.append((byte)5);
                this.buffer.append((byte)(l >> 32 & 0xFFL));
                this.buffer.append((byte)(l >> 24 & 0xFFL));
                this.buffer.append((byte)(l >> 16 & 0xFFL));
                this.buffer.append((byte)(l >> 8 & 0xFFL));
                this.buffer.append((byte)(l & 0xFFL));
            } else if ((l & 0xFFFF800000000000L) == -140737488355328L) {
                this.buffer.append((byte)6);
                this.buffer.append((byte)(l >> 40 & 0xFFL));
                this.buffer.append((byte)(l >> 32 & 0xFFL));
                this.buffer.append((byte)(l >> 24 & 0xFFL));
                this.buffer.append((byte)(l >> 16 & 0xFFL));
                this.buffer.append((byte)(l >> 8 & 0xFFL));
                this.buffer.append((byte)(l & 0xFFL));
            } else if ((l & 0xFF80000000000000L) == -36028797018963968L) {
                this.buffer.append((byte)7);
                this.buffer.append((byte)(l >> 48 & 0xFFL));
                this.buffer.append((byte)(l >> 40 & 0xFFL));
                this.buffer.append((byte)(l >> 32 & 0xFFL));
                this.buffer.append((byte)(l >> 24 & 0xFFL));
                this.buffer.append((byte)(l >> 16 & 0xFFL));
                this.buffer.append((byte)(l >> 8 & 0xFFL));
                this.buffer.append((byte)(l & 0xFFL));
            } else {
                this.buffer.append((byte)8);
                this.buffer.append((byte)(l >> 56 & 0xFFL));
                this.buffer.append((byte)(l >> 48 & 0xFFL));
                this.buffer.append((byte)(l >> 40 & 0xFFL));
                this.buffer.append((byte)(l >> 32 & 0xFFL));
                this.buffer.append((byte)(l >> 24 & 0xFFL));
                this.buffer.append((byte)(l >> 16 & 0xFFL));
                this.buffer.append((byte)(l >> 8 & 0xFFL));
                this.buffer.append((byte)(l & 0xFFL));
            }
        } else if ((l & 0x7FL) == l) {
            this.buffer.append((byte)1);
            this.buffer.append((byte)(l & 0x7FL));
        } else if ((l & 0x7FFFL) == l) {
            this.buffer.append((byte)2);
            this.buffer.append((byte)(l >> 8 & 0x7FL));
            this.buffer.append((byte)(l & 0xFFL));
        } else if ((l & 0x7FFFFFL) == l) {
            this.buffer.append((byte)3);
            this.buffer.append((byte)(l >> 16 & 0x7FL));
            this.buffer.append((byte)(l >> 8 & 0xFFL));
            this.buffer.append((byte)(l & 0xFFL));
        } else if ((l & Integer.MAX_VALUE) == l) {
            this.buffer.append((byte)4);
            this.buffer.append((byte)(l >> 24 & 0x7FL));
            this.buffer.append((byte)(l >> 16 & 0xFFL));
            this.buffer.append((byte)(l >> 8 & 0xFFL));
            this.buffer.append((byte)(l & 0xFFL));
        } else if ((l & 0x7FFFFFFFFFL) == l) {
            this.buffer.append((byte)5);
            this.buffer.append((byte)(l >> 32 & 0x7FL));
            this.buffer.append((byte)(l >> 24 & 0xFFL));
            this.buffer.append((byte)(l >> 16 & 0xFFL));
            this.buffer.append((byte)(l >> 8 & 0xFFL));
            this.buffer.append((byte)(l & 0xFFL));
        } else if ((l & 0x7FFFFFFFFFFFL) == l) {
            this.buffer.append((byte)6);
            this.buffer.append((byte)(l >> 40 & 0x7FL));
            this.buffer.append((byte)(l >> 32 & 0xFFL));
            this.buffer.append((byte)(l >> 24 & 0xFFL));
            this.buffer.append((byte)(l >> 16 & 0xFFL));
            this.buffer.append((byte)(l >> 8 & 0xFFL));
            this.buffer.append((byte)(l & 0xFFL));
        } else if ((l & 0x7FFFFFFFFFFFFFL) == l) {
            this.buffer.append((byte)7);
            this.buffer.append((byte)(l >> 48 & 0x7FL));
            this.buffer.append((byte)(l >> 40 & 0xFFL));
            this.buffer.append((byte)(l >> 32 & 0xFFL));
            this.buffer.append((byte)(l >> 24 & 0xFFL));
            this.buffer.append((byte)(l >> 16 & 0xFFL));
            this.buffer.append((byte)(l >> 8 & 0xFFL));
            this.buffer.append((byte)(l & 0xFFL));
        } else {
            this.buffer.append((byte)8);
            this.buffer.append((byte)(l >> 56 & 0x7FL));
            this.buffer.append((byte)(l >> 48 & 0xFFL));
            this.buffer.append((byte)(l >> 40 & 0xFFL));
            this.buffer.append((byte)(l >> 32 & 0xFFL));
            this.buffer.append((byte)(l >> 24 & 0xFFL));
            this.buffer.append((byte)(l >> 16 & 0xFFL));
            this.buffer.append((byte)(l >> 8 & 0xFFL));
            this.buffer.append((byte)(l & 0xFFL));
        }
    }

    public void addNull() {
        this.addNull((byte)5);
    }

    public void addNull(byte by) {
        this.buffer.append(by);
        this.buffer.append((byte)0);
    }

    public void addOctetString() {
        this.addOctetString((byte)4);
    }

    public void addOctetString(byte by) {
        this.buffer.append(by);
        this.buffer.append((byte)0);
    }

    public void addOctetString(byte[] byArray) {
        this.addOctetString((byte)4, byArray);
    }

    public void addOctetString(CharSequence charSequence) {
        if (charSequence == null) {
            this.addOctetString((byte)4);
        } else {
            this.addOctetString((byte)4, ((Object)charSequence).toString());
        }
    }

    public void addOctetString(String string) {
        this.addOctetString((byte)4, string);
    }

    public void addOctetString(byte by, byte[] byArray) {
        this.buffer.append(by);
        if (byArray == null) {
            this.buffer.append((byte)0);
        } else {
            ASN1Element.encodeLengthTo(byArray.length, this.buffer);
            this.buffer.append(byArray);
        }
    }

    public void addOctetString(byte by, CharSequence charSequence) {
        if (charSequence == null) {
            this.addOctetString(by);
        } else {
            this.addOctetString(by, ((Object)charSequence).toString());
        }
    }

    public void addOctetString(byte by, String string) {
        this.buffer.append(by);
        if (string == null) {
            this.buffer.append((byte)0);
        } else {
            int n = this.buffer.length();
            ASN1Element.encodeLengthTo(string.length(), this.buffer);
            int n2 = this.buffer.length();
            this.buffer.append(string);
            if (this.buffer.length() != n2 + string.length()) {
                byte[] byArray = new byte[this.buffer.length() - n2];
                System.arraycopy(this.buffer.getBackingArray(), n2, byArray, 0, byArray.length);
                this.buffer.setLength(n);
                ASN1Element.encodeLengthTo(byArray.length, this.buffer);
                this.buffer.append(byArray);
            }
        }
    }

    public ASN1BufferSequence beginSequence() {
        return this.beginSequence((byte)48);
    }

    public ASN1BufferSequence beginSequence(byte by) {
        this.buffer.append(by);
        return new ASN1BufferSequence(this);
    }

    public ASN1BufferSet beginSet() {
        return this.beginSet((byte)49);
    }

    public ASN1BufferSet beginSet(byte by) {
        this.buffer.append(by);
        return new ASN1BufferSet(this);
    }

    void endSequenceOrSet(int n) {
        int n2 = this.buffer.length() - n;
        if (n2 == 0) {
            this.buffer.append((byte)0);
            return;
        }
        if ((n2 & 0x7F) == n2) {
            this.buffer.insert(n, (byte)n2);
        } else if ((n2 & 0xFF) == n2) {
            this.buffer.insert(n, MULTIBYTE_LENGTH_HEADER_PLUS_ONE);
            byte[] byArray = this.buffer.getBackingArray();
            byArray[n + 1] = (byte)(n2 & 0xFF);
        } else if ((n2 & 0xFFFF) == n2) {
            this.buffer.insert(n, MULTIBYTE_LENGTH_HEADER_PLUS_TWO);
            byte[] byArray = this.buffer.getBackingArray();
            byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
            byArray[n + 2] = (byte)(n2 & 0xFF);
        } else if ((n2 & 0xFFFFFF) == n2) {
            this.buffer.insert(n, MULTIBYTE_LENGTH_HEADER_PLUS_THREE);
            byte[] byArray = this.buffer.getBackingArray();
            byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
            byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
            byArray[n + 3] = (byte)(n2 & 0xFF);
        } else {
            this.buffer.insert(n, MULTIBYTE_LENGTH_HEADER_PLUS_FOUR);
            byte[] byArray = this.buffer.getBackingArray();
            byArray[n + 1] = (byte)(n2 >> 24 & 0xFF);
            byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
            byArray[n + 3] = (byte)(n2 >> 8 & 0xFF);
            byArray[n + 4] = (byte)(n2 & 0xFF);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (Debug.debugEnabled(DebugType.ASN1)) {
            Debug.debugASN1Write(this);
        }
        this.buffer.write(outputStream);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.buffer.getBackingArray(), 0, this.buffer.length());
    }
}

