/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Constants;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class ASN1Element
implements Serializable {
    private static final long serialVersionUID = -1871166128693521335L;
    private final byte type;
    private final byte[] value;
    private int hashCode = -1;
    private final int valueLength;
    private final int valueOffset;

    public ASN1Element(byte by) {
        this.type = by;
        this.value = ASN1Constants.NO_VALUE;
        this.valueOffset = 0;
        this.valueLength = 0;
    }

    public ASN1Element(byte by, byte[] byArray) {
        this.type = by;
        this.value = byArray == null ? ASN1Constants.NO_VALUE : byArray;
        this.valueOffset = 0;
        this.valueLength = this.value.length;
    }

    public ASN1Element(byte by, byte[] byArray, int n, int n2) {
        this.type = by;
        this.value = byArray;
        this.valueOffset = n;
        this.valueLength = n2;
    }

    public final byte getType() {
        return this.type;
    }

    byte[] getValueArray() {
        return this.value;
    }

    int getValueOffset() {
        return this.valueOffset;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public byte[] getValue() {
        if (this.valueOffset == 0 && this.valueLength == this.value.length) {
            return this.value;
        }
        byte[] byArray = new byte[this.valueLength];
        System.arraycopy(this.value, this.valueOffset, byArray, 0, this.valueLength);
        return byArray;
    }

    public final byte[] encode() {
        byte[] byArray = this.getValueArray();
        int n = this.getValueLength();
        int n2 = this.getValueOffset();
        if (n == 0) {
            return new byte[]{this.type, 0};
        }
        byte[] byArray2 = ASN1Element.encodeLength(n);
        byte[] byArray3 = new byte[1 + byArray2.length + n];
        byArray3[0] = this.type;
        System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        System.arraycopy(byArray, n2, byArray3, 1 + byArray2.length, n);
        return byArray3;
    }

    static void encodeLengthTo(int n, ByteStringBuffer byteStringBuffer) {
        if ((n & 0x7F) == n) {
            byteStringBuffer.append((byte)n);
        } else if ((n & 0xFF) == n) {
            byteStringBuffer.append((byte)-127);
            byteStringBuffer.append((byte)(n & 0xFF));
        } else if ((n & 0xFFFF) == n) {
            byteStringBuffer.append((byte)-126);
            byteStringBuffer.append((byte)(n >> 8 & 0xFF));
            byteStringBuffer.append((byte)(n & 0xFF));
        } else if ((n & 0xFFFFFF) == n) {
            byteStringBuffer.append((byte)-125);
            byteStringBuffer.append((byte)(n >> 16 & 0xFF));
            byteStringBuffer.append((byte)(n >> 8 & 0xFF));
            byteStringBuffer.append((byte)(n & 0xFF));
        } else {
            byteStringBuffer.append((byte)-124);
            byteStringBuffer.append((byte)(n >> 24 & 0xFF));
            byteStringBuffer.append((byte)(n >> 16 & 0xFF));
            byteStringBuffer.append((byte)(n >> 8 & 0xFF));
            byteStringBuffer.append((byte)(n & 0xFF));
        }
    }

    public void encodeTo(ByteStringBuffer byteStringBuffer) {
        byte[] byArray = this.getValueArray();
        int n = this.getValueLength();
        int n2 = this.getValueOffset();
        byteStringBuffer.append(this.type);
        if (n == 0) {
            byteStringBuffer.append((byte)0);
        } else {
            ASN1Element.encodeLengthTo(n, byteStringBuffer);
            byteStringBuffer.append(byArray, n2, n);
        }
    }

    public static byte[] encodeLength(int n) {
        switch (n) {
            case 0: {
                return ASN1Constants.LENGTH_0;
            }
            case 1: {
                return ASN1Constants.LENGTH_1;
            }
            case 2: {
                return ASN1Constants.LENGTH_2;
            }
            case 3: {
                return ASN1Constants.LENGTH_3;
            }
            case 4: {
                return ASN1Constants.LENGTH_4;
            }
            case 5: {
                return ASN1Constants.LENGTH_5;
            }
            case 6: {
                return ASN1Constants.LENGTH_6;
            }
            case 7: {
                return ASN1Constants.LENGTH_7;
            }
            case 8: {
                return ASN1Constants.LENGTH_8;
            }
            case 9: {
                return ASN1Constants.LENGTH_9;
            }
            case 10: {
                return ASN1Constants.LENGTH_10;
            }
            case 11: {
                return ASN1Constants.LENGTH_11;
            }
            case 12: {
                return ASN1Constants.LENGTH_12;
            }
            case 13: {
                return ASN1Constants.LENGTH_13;
            }
            case 14: {
                return ASN1Constants.LENGTH_14;
            }
            case 15: {
                return ASN1Constants.LENGTH_15;
            }
            case 16: {
                return ASN1Constants.LENGTH_16;
            }
            case 17: {
                return ASN1Constants.LENGTH_17;
            }
            case 18: {
                return ASN1Constants.LENGTH_18;
            }
            case 19: {
                return ASN1Constants.LENGTH_19;
            }
            case 20: {
                return ASN1Constants.LENGTH_20;
            }
            case 21: {
                return ASN1Constants.LENGTH_21;
            }
            case 22: {
                return ASN1Constants.LENGTH_22;
            }
            case 23: {
                return ASN1Constants.LENGTH_23;
            }
            case 24: {
                return ASN1Constants.LENGTH_24;
            }
            case 25: {
                return ASN1Constants.LENGTH_25;
            }
            case 26: {
                return ASN1Constants.LENGTH_26;
            }
            case 27: {
                return ASN1Constants.LENGTH_27;
            }
            case 28: {
                return ASN1Constants.LENGTH_28;
            }
            case 29: {
                return ASN1Constants.LENGTH_29;
            }
            case 30: {
                return ASN1Constants.LENGTH_30;
            }
            case 31: {
                return ASN1Constants.LENGTH_31;
            }
            case 32: {
                return ASN1Constants.LENGTH_32;
            }
            case 33: {
                return ASN1Constants.LENGTH_33;
            }
            case 34: {
                return ASN1Constants.LENGTH_34;
            }
            case 35: {
                return ASN1Constants.LENGTH_35;
            }
            case 36: {
                return ASN1Constants.LENGTH_36;
            }
            case 37: {
                return ASN1Constants.LENGTH_37;
            }
            case 38: {
                return ASN1Constants.LENGTH_38;
            }
            case 39: {
                return ASN1Constants.LENGTH_39;
            }
            case 40: {
                return ASN1Constants.LENGTH_40;
            }
            case 41: {
                return ASN1Constants.LENGTH_41;
            }
            case 42: {
                return ASN1Constants.LENGTH_42;
            }
            case 43: {
                return ASN1Constants.LENGTH_43;
            }
            case 44: {
                return ASN1Constants.LENGTH_44;
            }
            case 45: {
                return ASN1Constants.LENGTH_45;
            }
            case 46: {
                return ASN1Constants.LENGTH_46;
            }
            case 47: {
                return ASN1Constants.LENGTH_47;
            }
            case 48: {
                return ASN1Constants.LENGTH_48;
            }
            case 49: {
                return ASN1Constants.LENGTH_49;
            }
            case 50: {
                return ASN1Constants.LENGTH_50;
            }
            case 51: {
                return ASN1Constants.LENGTH_51;
            }
            case 52: {
                return ASN1Constants.LENGTH_52;
            }
            case 53: {
                return ASN1Constants.LENGTH_53;
            }
            case 54: {
                return ASN1Constants.LENGTH_54;
            }
            case 55: {
                return ASN1Constants.LENGTH_55;
            }
            case 56: {
                return ASN1Constants.LENGTH_56;
            }
            case 57: {
                return ASN1Constants.LENGTH_57;
            }
            case 58: {
                return ASN1Constants.LENGTH_58;
            }
            case 59: {
                return ASN1Constants.LENGTH_59;
            }
            case 60: {
                return ASN1Constants.LENGTH_60;
            }
            case 61: {
                return ASN1Constants.LENGTH_61;
            }
            case 62: {
                return ASN1Constants.LENGTH_62;
            }
            case 63: {
                return ASN1Constants.LENGTH_63;
            }
            case 64: {
                return ASN1Constants.LENGTH_64;
            }
            case 65: {
                return ASN1Constants.LENGTH_65;
            }
            case 66: {
                return ASN1Constants.LENGTH_66;
            }
            case 67: {
                return ASN1Constants.LENGTH_67;
            }
            case 68: {
                return ASN1Constants.LENGTH_68;
            }
            case 69: {
                return ASN1Constants.LENGTH_69;
            }
            case 70: {
                return ASN1Constants.LENGTH_70;
            }
            case 71: {
                return ASN1Constants.LENGTH_71;
            }
            case 72: {
                return ASN1Constants.LENGTH_72;
            }
            case 73: {
                return ASN1Constants.LENGTH_73;
            }
            case 74: {
                return ASN1Constants.LENGTH_74;
            }
            case 75: {
                return ASN1Constants.LENGTH_75;
            }
            case 76: {
                return ASN1Constants.LENGTH_76;
            }
            case 77: {
                return ASN1Constants.LENGTH_77;
            }
            case 78: {
                return ASN1Constants.LENGTH_78;
            }
            case 79: {
                return ASN1Constants.LENGTH_79;
            }
            case 80: {
                return ASN1Constants.LENGTH_80;
            }
            case 81: {
                return ASN1Constants.LENGTH_81;
            }
            case 82: {
                return ASN1Constants.LENGTH_82;
            }
            case 83: {
                return ASN1Constants.LENGTH_83;
            }
            case 84: {
                return ASN1Constants.LENGTH_84;
            }
            case 85: {
                return ASN1Constants.LENGTH_85;
            }
            case 86: {
                return ASN1Constants.LENGTH_86;
            }
            case 87: {
                return ASN1Constants.LENGTH_87;
            }
            case 88: {
                return ASN1Constants.LENGTH_88;
            }
            case 89: {
                return ASN1Constants.LENGTH_89;
            }
            case 90: {
                return ASN1Constants.LENGTH_90;
            }
            case 91: {
                return ASN1Constants.LENGTH_91;
            }
            case 92: {
                return ASN1Constants.LENGTH_92;
            }
            case 93: {
                return ASN1Constants.LENGTH_93;
            }
            case 94: {
                return ASN1Constants.LENGTH_94;
            }
            case 95: {
                return ASN1Constants.LENGTH_95;
            }
            case 96: {
                return ASN1Constants.LENGTH_96;
            }
            case 97: {
                return ASN1Constants.LENGTH_97;
            }
            case 98: {
                return ASN1Constants.LENGTH_98;
            }
            case 99: {
                return ASN1Constants.LENGTH_99;
            }
            case 100: {
                return ASN1Constants.LENGTH_100;
            }
            case 101: {
                return ASN1Constants.LENGTH_101;
            }
            case 102: {
                return ASN1Constants.LENGTH_102;
            }
            case 103: {
                return ASN1Constants.LENGTH_103;
            }
            case 104: {
                return ASN1Constants.LENGTH_104;
            }
            case 105: {
                return ASN1Constants.LENGTH_105;
            }
            case 106: {
                return ASN1Constants.LENGTH_106;
            }
            case 107: {
                return ASN1Constants.LENGTH_107;
            }
            case 108: {
                return ASN1Constants.LENGTH_108;
            }
            case 109: {
                return ASN1Constants.LENGTH_109;
            }
            case 110: {
                return ASN1Constants.LENGTH_110;
            }
            case 111: {
                return ASN1Constants.LENGTH_111;
            }
            case 112: {
                return ASN1Constants.LENGTH_112;
            }
            case 113: {
                return ASN1Constants.LENGTH_113;
            }
            case 114: {
                return ASN1Constants.LENGTH_114;
            }
            case 115: {
                return ASN1Constants.LENGTH_115;
            }
            case 116: {
                return ASN1Constants.LENGTH_116;
            }
            case 117: {
                return ASN1Constants.LENGTH_117;
            }
            case 118: {
                return ASN1Constants.LENGTH_118;
            }
            case 119: {
                return ASN1Constants.LENGTH_119;
            }
            case 120: {
                return ASN1Constants.LENGTH_120;
            }
            case 121: {
                return ASN1Constants.LENGTH_121;
            }
            case 122: {
                return ASN1Constants.LENGTH_122;
            }
            case 123: {
                return ASN1Constants.LENGTH_123;
            }
            case 124: {
                return ASN1Constants.LENGTH_124;
            }
            case 125: {
                return ASN1Constants.LENGTH_125;
            }
            case 126: {
                return ASN1Constants.LENGTH_126;
            }
            case 127: {
                return ASN1Constants.LENGTH_127;
            }
        }
        if ((n & 0xFF) == n) {
            return new byte[]{-127, (byte)(n & 0xFF)};
        }
        if ((n & 0xFFFF) == n) {
            return new byte[]{-126, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        if ((n & 0xFFFFFF) == n) {
            return new byte[]{-125, (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        return new byte[]{-124, (byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    public static ASN1Element decode(byte[] byArray) throws ASN1Exception {
        try {
            int n = 2;
            int n2 = byArray[1] & 0x7F;
            if (n2 != byArray[1]) {
                int n3 = n2;
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    n2 <<= 8;
                    n2 |= byArray[n++] & 0xFF;
                }
            }
            if (byArray.length - n != n2) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(n2, byArray.length - n));
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return new ASN1Element(byArray[0], byArray2);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(exception), exception);
        }
    }

    public final ASN1Boolean decodeAsBoolean() throws ASN1Exception {
        return ASN1Boolean.decodeAsBoolean(this);
    }

    public final ASN1Enumerated decodeAsEnumerated() throws ASN1Exception {
        return ASN1Enumerated.decodeAsEnumerated(this);
    }

    public final ASN1Integer decodeAsInteger() throws ASN1Exception {
        return ASN1Integer.decodeAsInteger(this);
    }

    public final ASN1Long decodeAsLong() throws ASN1Exception {
        return ASN1Long.decodeAsLong(this);
    }

    public final ASN1Null decodeAsNull() throws ASN1Exception {
        return ASN1Null.decodeAsNull(this);
    }

    public final ASN1OctetString decodeAsOctetString() {
        return ASN1OctetString.decodeAsOctetString(this);
    }

    public final ASN1Sequence decodeAsSequence() throws ASN1Exception {
        return ASN1Sequence.decodeAsSequence(this);
    }

    public final ASN1Set decodeAsSet() throws ASN1Exception {
        return ASN1Set.decodeAsSet(this);
    }

    public static ASN1Element readFrom(InputStream inputStream) throws IOException, ASN1Exception {
        return ASN1Element.readFrom(inputStream, -1);
    }

    public static ASN1Element readFrom(InputStream inputStream, int n) throws IOException, ASN1Exception {
        int n2;
        int n3;
        int n4 = inputStream.read();
        if (n4 < 0) {
            return null;
        }
        byte by = (byte)n4;
        int n5 = inputStream.read();
        if (n5 < 0) {
            throw new ASN1Exception(ASN1Messages.ERR_READ_END_BEFORE_FIRST_LENGTH.get());
        }
        if (n5 > 127) {
            n3 = n5 & 0x7F;
            n5 = 0;
            if (n3 < 1 || n3 > 4) {
                throw new ASN1Exception(ASN1Messages.ERR_READ_LENGTH_TOO_LONG.get(n3));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n6 = inputStream.read();
                if (n6 < 0) {
                    throw new ASN1Exception(ASN1Messages.ERR_READ_END_BEFORE_LENGTH_END.get());
                }
                n5 <<= 8;
                n5 |= n6 & 0xFF;
            }
        }
        if (n5 < 0 || n > 0 && n5 > n) {
            throw new ASN1Exception(ASN1Messages.ERR_READ_LENGTH_EXCEEDS_MAX.get(n5, n));
        }
        n3 = 0;
        n2 = n5;
        byte[] byArray = new byte[n5];
        while (n3 < n5) {
            int n7 = inputStream.read(byArray, n3, n2);
            if (n7 < 0) {
                throw new ASN1Exception(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            n3 += n7;
            n2 -= n7;
        }
        ASN1Element aSN1Element = new ASN1Element(by, byArray);
        Debug.debugASN1Read(aSN1Element);
        return aSN1Element;
    }

    public final int writeTo(OutputStream outputStream) throws IOException {
        Debug.debugASN1Write(this);
        ByteStringBuffer byteStringBuffer = new ByteStringBuffer();
        this.encodeTo(byteStringBuffer);
        byteStringBuffer.write(outputStream);
        return byteStringBuffer.length();
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            int n = 0;
            for (byte by : this.getValue()) {
                n = n * 31 + by;
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            ASN1Element aSN1Element = (ASN1Element)object;
            return this.type == aSN1Element.getType() && Arrays.equals(this.getValue(), aSN1Element.getValue());
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return false;
        }
    }

    public final boolean equalsIgnoreType(ASN1Element aSN1Element) {
        if (aSN1Element == null) {
            return false;
        }
        if (aSN1Element == this) {
            return true;
        }
        return Arrays.equals(this.getValue(), aSN1Element.getValue());
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        byte[] byArray = this.getValue();
        stringBuilder.append("ASN1Element(type=");
        StaticUtils.toHex(this.type, stringBuilder);
        stringBuilder.append(", valueLength=");
        stringBuilder.append(byArray.length);
        stringBuilder.append(", valueBytes='");
        StaticUtils.toHex(byArray, stringBuilder);
        stringBuilder.append("')");
    }
}

