/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;

public final class ASN1Integer
extends ASN1Element {
    private static final long serialVersionUID = -733929804601994372L;
    private final int intValue;

    public ASN1Integer(int n) {
        super((byte)2, ASN1Integer.encodeIntValue(n));
        this.intValue = n;
    }

    public ASN1Integer(byte by, int n) {
        super(by, ASN1Integer.encodeIntValue(n));
        this.intValue = n;
    }

    private ASN1Integer(byte by, int n, byte[] byArray) {
        super(by, byArray);
        this.intValue = n;
    }

    static byte[] encodeIntValue(int n) {
        if (n < 0) {
            if ((n & 0xFFFFFF80) == -128) {
                return new byte[]{(byte)(n & 0xFF)};
            }
            if ((n & Short.MIN_VALUE) == Short.MIN_VALUE) {
                return new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            }
            if ((n & 0xFF800000) == -8388608) {
                return new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            }
            return new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        if ((n & 0x7F) == n) {
            return new byte[]{(byte)(n & 0x7F)};
        }
        if ((n & Short.MAX_VALUE) == n) {
            return new byte[]{(byte)(n >> 8 & 0x7F), (byte)(n & 0xFF)};
        }
        if ((n & 0x7FFFFF) == n) {
            return new byte[]{(byte)(n >> 16 & 0x7F), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        }
        return new byte[]{(byte)(n >> 24 & 0x7F), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    public int intValue() {
        return this.intValue;
    }

    public static ASN1Integer decodeAsInteger(byte[] byArray) throws ASN1Exception {
        try {
            int n;
            int n2 = 2;
            int n3 = byArray[1] & 0x7F;
            if (n3 != byArray[1]) {
                int n4 = n3;
                n3 = 0;
                for (n = 0; n < n4; ++n) {
                    n3 <<= 8;
                    n3 |= byArray[n2++] & 0xFF;
                }
            }
            if (byArray.length - n2 != n3) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(n3, byArray.length - n2));
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            switch (byArray2.length) {
                case 1: {
                    n = byArray2[0] & 0xFF;
                    if ((byArray2[0] & 0x80) == 0) break;
                    n |= 0xFFFFFF00;
                    break;
                }
                case 2: {
                    n = (byArray2[0] & 0xFF) << 8 | byArray2[1] & 0xFF;
                    if ((byArray2[0] & 0x80) == 0) break;
                    n |= 0xFFFF0000;
                    break;
                }
                case 3: {
                    n = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
                    if ((byArray2[0] & 0x80) == 0) break;
                    n |= 0xFF000000;
                    break;
                }
                case 4: {
                    n = (byArray2[0] & 0xFF) << 24 | (byArray2[1] & 0xFF) << 16 | (byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF;
                    break;
                }
                default: {
                    throw new ASN1Exception(ASN1Messages.ERR_ENUMERATED_INVALID_LENGTH.get(byArray2.length));
                }
            }
            return new ASN1Integer(byArray[0], n, byArray2);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(exception), exception);
        }
    }

    public static ASN1Integer decodeAsInteger(ASN1Element aSN1Element) throws ASN1Exception {
        int n;
        byte[] byArray = aSN1Element.getValue();
        switch (byArray.length) {
            case 1: {
                n = byArray[0] & 0xFF;
                if ((byArray[0] & 0x80) == 0) break;
                n |= 0xFFFFFF00;
                break;
            }
            case 2: {
                n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
                if ((byArray[0] & 0x80) == 0) break;
                n |= 0xFFFF0000;
                break;
            }
            case 3: {
                n = (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
                if ((byArray[0] & 0x80) == 0) break;
                n |= 0xFF000000;
                break;
            }
            case 4: {
                n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                break;
            }
            default: {
                throw new ASN1Exception(ASN1Messages.ERR_INTEGER_INVALID_LENGTH.get(byArray.length));
            }
        }
        return new ASN1Integer(aSN1Element.getType(), n, byArray);
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.intValue);
    }
}

