/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;

public final class ASN1Null
extends ASN1Element {
    public static final ASN1Null UNIVERSAL_NULL_ELEMENT = new ASN1Null();
    private static final long serialVersionUID = -3264450066845549348L;

    public ASN1Null() {
        super((byte)5);
    }

    public ASN1Null(byte by) {
        super(by);
    }

    public static ASN1Null decodeAsNull(byte[] byArray) throws ASN1Exception {
        try {
            int n = 2;
            int n2 = byArray[1] & 0x7F;
            if (n2 != byArray[1]) {
                int n3 = n2;
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    n2 <<= 8;
                    n2 |= byArray[n++] & 0xFF;
                }
            }
            if (byArray.length - n != n2) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(n2, byArray.length - n));
            }
            if (n2 != 0) {
                throw new ASN1Exception(ASN1Messages.ERR_NULL_HAS_VALUE.get());
            }
            return new ASN1Null(byArray[0]);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(exception), exception);
        }
    }

    public static ASN1Null decodeAsNull(ASN1Element aSN1Element) throws ASN1Exception {
        if (aSN1Element.getValue().length != 0) {
            throw new ASN1Exception(ASN1Messages.ERR_NULL_HAS_VALUE.get());
        }
        return new ASN1Null(aSN1Element.getType());
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ASN1Null(type=");
        StaticUtils.toHex(this.getType(), stringBuilder);
        stringBuilder.append(')');
    }
}

