/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.ByteString;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;

public final class ASN1OctetString
extends ASN1Element
implements ByteString {
    private static final long serialVersionUID = -7857753188341295516L;
    private byte[] valueBytes;
    private volatile byte[] valueBytesGuard;
    private int length;
    private int offset;
    private String stringValue;

    public ASN1OctetString() {
        super((byte)4);
        this.valueBytes = StaticUtils.NO_BYTES;
        this.stringValue = "";
        this.offset = 0;
        this.length = 0;
    }

    public ASN1OctetString(byte by) {
        super(by);
        this.valueBytes = StaticUtils.NO_BYTES;
        this.stringValue = "";
        this.offset = 0;
        this.length = 0;
    }

    public ASN1OctetString(byte[] byArray) {
        super((byte)4);
        if (byArray == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = byArray;
            this.stringValue = null;
            this.offset = 0;
            this.length = byArray.length;
        }
    }

    public ASN1OctetString(byte[] byArray, int n, int n2) {
        super((byte)4);
        Validator.ensureNotNull(byArray);
        Validator.ensureTrue(n >= 0 && n2 >= 0 && n + n2 <= byArray.length);
        this.valueBytes = byArray;
        this.stringValue = null;
        this.offset = n;
        this.length = n2;
    }

    public ASN1OctetString(byte by, byte[] byArray) {
        super(by);
        if (byArray == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = byArray;
            this.stringValue = null;
            this.offset = 0;
            this.length = byArray.length;
        }
    }

    public ASN1OctetString(byte by, byte[] byArray, int n, int n2) {
        super(by);
        Validator.ensureTrue(n >= 0 && n2 >= 0 && n + n2 <= byArray.length);
        this.valueBytes = byArray;
        this.stringValue = null;
        this.offset = n;
        this.length = n2;
    }

    public ASN1OctetString(String string) {
        super((byte)4);
        if (string == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = null;
            this.stringValue = string;
            this.offset = -1;
            this.length = -1;
        }
    }

    public ASN1OctetString(byte by, String string) {
        super(by);
        if (string == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = null;
            this.stringValue = string;
            this.offset = -1;
            this.length = -1;
        }
    }

    byte[] getValueArray() {
        return this.getValue();
    }

    int getValueOffset() {
        return 0;
    }

    public int getValueLength() {
        return this.getValue().length;
    }

    public byte[] getValue() {
        if (this.valueBytes == null) {
            this.valueBytesGuard = StaticUtils.getBytes(this.stringValue);
            this.offset = 0;
            this.length = this.valueBytesGuard.length;
            this.valueBytes = this.valueBytesGuard;
        } else if (this.offset != 0 || this.length != this.valueBytes.length) {
            byte[] byArray = new byte[this.length];
            System.arraycopy(this.valueBytes, this.offset, byArray, 0, this.length);
            this.offset = 0;
            this.valueBytesGuard = byArray;
            this.valueBytes = this.valueBytesGuard;
        }
        return this.valueBytes;
    }

    public void encodeTo(ByteStringBuffer byteStringBuffer) {
        byteStringBuffer.append(this.getType());
        if (this.valueBytes == null) {
            int n = this.stringValue.length();
            int n2 = byteStringBuffer.length();
            ASN1OctetString.encodeLengthTo(n, byteStringBuffer);
            int n3 = byteStringBuffer.length();
            byteStringBuffer.append(this.stringValue);
            int n4 = byteStringBuffer.length() - n3;
            if (n4 != n) {
                byte[] byArray = ASN1OctetString.encodeLength(n4);
                if (byArray.length == n3 - n2) {
                    System.arraycopy(byArray, 0, byteStringBuffer.getBackingArray(), n2, byArray.length);
                } else {
                    byteStringBuffer.setLength(n2);
                    byteStringBuffer.append(byArray);
                    byteStringBuffer.append(this.stringValue);
                }
            }
        } else {
            ASN1OctetString.encodeLengthTo(this.length, byteStringBuffer);
            byteStringBuffer.append(this.valueBytes, this.offset, this.length);
        }
    }

    public String stringValue() {
        if (this.stringValue == null) {
            this.stringValue = this.length == 0 ? "" : StaticUtils.toUTF8String(this.valueBytes, this.offset, this.length);
        }
        return this.stringValue;
    }

    public static ASN1OctetString decodeAsOctetString(byte[] byArray) throws ASN1Exception {
        try {
            int n = 2;
            int n2 = byArray[1] & 0x7F;
            if (n2 != byArray[1]) {
                int n3 = n2;
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    n2 <<= 8;
                    n2 |= byArray[n++] & 0xFF;
                }
            }
            if (byArray.length - n != n2) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(n2, byArray.length - n));
            }
            return new ASN1OctetString(byArray[0], byArray, n, n2);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(exception), exception);
        }
    }

    public static ASN1OctetString decodeAsOctetString(ASN1Element aSN1Element) {
        return new ASN1OctetString(aSN1Element.getType(), aSN1Element.getValue());
    }

    public void appendValueTo(ByteStringBuffer byteStringBuffer) {
        if (this.valueBytes == null) {
            byteStringBuffer.append(this.stringValue);
        } else {
            byteStringBuffer.append(this.valueBytes, this.offset, this.length);
        }
    }

    public ASN1OctetString toASN1OctetString() {
        return this;
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.stringValue());
    }
}

