/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Constants;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASN1Set
extends ASN1Element {
    private static final long serialVersionUID = -523497075310394409L;
    private final ASN1Element[] elements;
    private byte[] encodedValue;
    private volatile byte[] encodedValueGuard;

    public ASN1Set() {
        super((byte)49);
        this.elements = ASN1Constants.NO_ELEMENTS;
        this.encodedValue = ASN1Constants.NO_VALUE;
    }

    public ASN1Set(byte by) {
        super(by);
        this.elements = ASN1Constants.NO_ELEMENTS;
        this.encodedValue = ASN1Constants.NO_VALUE;
    }

    public ASN1Set(ASN1Element ... aSN1ElementArray) {
        super((byte)49);
        this.elements = aSN1ElementArray == null ? ASN1Constants.NO_ELEMENTS : aSN1ElementArray;
        this.encodedValue = null;
    }

    public ASN1Set(Collection<? extends ASN1Element> collection) {
        super((byte)49);
        if (collection == null || collection.isEmpty()) {
            this.elements = ASN1Constants.NO_ELEMENTS;
        } else {
            this.elements = new ASN1Element[collection.size()];
            collection.toArray(this.elements);
        }
        this.encodedValue = null;
    }

    public ASN1Set(byte by, ASN1Element ... aSN1ElementArray) {
        super(by);
        this.elements = aSN1ElementArray == null ? ASN1Constants.NO_ELEMENTS : aSN1ElementArray;
        this.encodedValue = null;
    }

    public ASN1Set(byte by, Collection<? extends ASN1Element> collection) {
        super(by);
        if (collection == null || collection.isEmpty()) {
            this.elements = ASN1Constants.NO_ELEMENTS;
        } else {
            this.elements = new ASN1Element[collection.size()];
            collection.toArray(this.elements);
        }
        this.encodedValue = null;
    }

    private ASN1Set(byte by, ASN1Element[] aSN1ElementArray, byte[] byArray) {
        super(by);
        this.elements = aSN1ElementArray;
        this.encodedValue = byArray;
    }

    @Override
    byte[] getValueArray() {
        return this.getValue();
    }

    @Override
    int getValueOffset() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return this.getValue().length;
    }

    @Override
    public byte[] getValue() {
        if (this.encodedValue == null) {
            this.encodedValueGuard = ASN1Sequence.encodeElements(this.elements);
            this.encodedValue = this.encodedValueGuard;
        }
        return this.encodedValue;
    }

    @Override
    public void encodeTo(ByteStringBuffer byteStringBuffer) {
        byteStringBuffer.append(this.getType());
        if (this.elements.length == 0) {
            byteStringBuffer.append((byte)0);
            return;
        }
        int n = byteStringBuffer.length();
        for (ASN1Element aSN1Element : this.elements) {
            aSN1Element.encodeTo(byteStringBuffer);
        }
        byteStringBuffer.insert(n, ASN1Set.encodeLength(byteStringBuffer.length() - n));
    }

    public ASN1Element[] elements() {
        return this.elements;
    }

    public static ASN1Set decodeAsSet(byte[] byArray) throws ASN1Exception {
        try {
            int n;
            int n2;
            int n3 = 2;
            int n4 = byArray[1] & 0x7F;
            if (n4 != byArray[1]) {
                int n5 = n4;
                n4 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    n4 <<= 8;
                    n4 |= byArray[n3++] & 0xFF;
                }
            }
            if (byArray.length - n3 != n4) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(n4, byArray.length - n3));
            }
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            n2 = 0;
            ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(5);
            try {
                n = 0;
                while (n < byArray2.length) {
                    int n6;
                    byte by;
                    int n7;
                    byte by2 = byArray2[n++];
                    if ((n7 = (by = byArray2[n++]) & 0x7F) != by) {
                        n6 = n7;
                        n7 = 0;
                        for (int i = 0; i < n6; ++i) {
                            n7 <<= 8;
                            n7 |= byArray2[n++] & 0xFF;
                        }
                    }
                    n6 = n + n7;
                    if (n7 < 0 || n6 < 0 || n6 > byArray2.length) {
                        throw new ASN1Exception(ASN1Messages.ERR_SET_BYTES_DECODE_LENGTH_EXCEEDS_AVAILABLE.get());
                    }
                    arrayList.add(new ASN1Element(by2, byArray2, n, n7));
                    n += n7;
                    ++n2;
                }
            }
            catch (ASN1Exception aSN1Exception) {
                throw aSN1Exception;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new ASN1Exception(ASN1Messages.ERR_SET_BYTES_DECODE_EXCEPTION.get(exception), exception);
            }
            n = 0;
            ASN1Element[] aSN1ElementArray = new ASN1Element[n2];
            for (ASN1Element aSN1Element : arrayList) {
                aSN1ElementArray[n++] = aSN1Element;
            }
            return new ASN1Set(byArray[0], aSN1ElementArray, byArray2);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(exception), exception);
        }
    }

    public static ASN1Set decodeAsSet(ASN1Element aSN1Element) throws ASN1Exception {
        int n;
        int n2 = 0;
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(5);
        byte[] byArray = aSN1Element.getValue();
        try {
            n = 0;
            while (n < byArray.length) {
                int n3;
                byte by;
                int n4;
                byte by2 = byArray[n++];
                if ((n4 = (by = byArray[n++]) & 0x7F) != by) {
                    n3 = n4;
                    n4 = 0;
                    for (int i = 0; i < n3; ++i) {
                        n4 <<= 8;
                        n4 |= byArray[n++] & 0xFF;
                    }
                }
                n3 = n + n4;
                if (n4 < 0 || n3 < 0 || n3 > byArray.length) {
                    throw new ASN1Exception(ASN1Messages.ERR_SET_DECODE_LENGTH_EXCEEDS_AVAILABLE.get(String.valueOf(aSN1Element)));
                }
                arrayList.add(new ASN1Element(by2, byArray, n, n4));
                n += n4;
                ++n2;
            }
        }
        catch (ASN1Exception aSN1Exception) {
            throw aSN1Exception;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new ASN1Exception(ASN1Messages.ERR_SET_DECODE_EXCEPTION.get(String.valueOf(aSN1Element), exception), exception);
        }
        n = 0;
        ASN1Element[] aSN1ElementArray = new ASN1Element[n2];
        for (ASN1Element aSN1Element2 : arrayList) {
            aSN1ElementArray[n++] = aSN1Element2;
        }
        return new ASN1Set(aSN1Element.getType(), aSN1ElementArray, byArray);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            this.elements[i].toString(stringBuilder);
        }
        stringBuilder.append(']');
    }
}

