/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class GeneralizedTimeMatchingRule
extends MatchingRule {
    private static final GeneralizedTimeMatchingRule INSTANCE = new GeneralizedTimeMatchingRule();
    private static final String GENERALIZED_TIME_DATE_FORMAT = "yyyyMMddHHmmss.SSS'Z'";
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final String EQUALITY_RULE_NAME = "generalizedTimeMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("generalizedTimeMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.27";
    public static final String ORDERING_RULE_NAME = "generalizedTimeOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("generalizedTimeOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.28";
    private static final long serialVersionUID = -6317451154598148593L;
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();

    public static GeneralizedTimeMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    public String getSubstringMatchingRuleName() {
        return null;
    }

    public String getSubstringMatchingRuleOID() {
        return null;
    }

    public boolean valuesMatch(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        Date date;
        Date date2;
        try {
            date2 = StaticUtils.decodeGeneralizedTime(aSN1OctetString.stringValue());
        }
        catch (ParseException parseException) {
            Debug.debugException(parseException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(parseException.getMessage()), parseException);
        }
        try {
            date = StaticUtils.decodeGeneralizedTime(aSN1OctetString2.stringValue());
        }
        catch (ParseException parseException) {
            Debug.debugException(parseException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(parseException.getMessage()), parseException);
        }
        return date2.equals(date);
    }

    public boolean matchesSubstring(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString[] aSN1OctetStringArray, ASN1OctetString aSN1OctetString3) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_GENERALIZED_TIME_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    public int compareValues(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws LDAPException {
        Date date;
        Date date2;
        try {
            date2 = StaticUtils.decodeGeneralizedTime(aSN1OctetString.stringValue());
        }
        catch (ParseException parseException) {
            Debug.debugException(parseException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(parseException.getMessage()), parseException);
        }
        try {
            date = StaticUtils.decodeGeneralizedTime(aSN1OctetString2.stringValue());
        }
        catch (ParseException parseException) {
            Debug.debugException(parseException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(parseException.getMessage()), parseException);
        }
        return date2.compareTo(date);
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) throws LDAPException {
        Date date;
        try {
            date = StaticUtils.decodeGeneralizedTime(aSN1OctetString.stringValue());
        }
        catch (ParseException parseException) {
            Debug.debugException(parseException);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_GENERALIZED_TIME_INVALID_VALUE.get(parseException.getMessage()), parseException);
        }
        SimpleDateFormat simpleDateFormat = dateFormat.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(GENERALIZED_TIME_DATE_FORMAT);
            simpleDateFormat.setTimeZone(UTC_TIME_ZONE);
            dateFormat.set(simpleDateFormat);
        }
        return new ASN1OctetString(simpleDateFormat.format(date));
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_GENERALIZED_TIME_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

