/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.matchingrules.SimpleMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.StaticUtils;

public final class NumericStringMatchingRule
extends SimpleMatchingRule {
    private static final NumericStringMatchingRule INSTANCE = new NumericStringMatchingRule();
    public static final String EQUALITY_RULE_NAME = "numericStringMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("numericStringMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.8";
    public static final String ORDERING_RULE_NAME = "numericStringOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("numericStringOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.9";
    public static final String SUBSTRING_RULE_NAME = "numericStringSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("numericStringSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.10";
    private static final long serialVersionUID = -898484312052746321L;

    public static NumericStringMatchingRule getInstance() {
        return INSTANCE;
    }

    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    public ASN1OctetString normalize(ASN1OctetString aSN1OctetString) throws LDAPException {
        int n;
        int n2 = 0;
        byte[] byArray = aSN1OctetString.getValue();
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == 32) {
                ++n2;
                continue;
            }
            if (byArray[n] >= 48 && byArray[n] <= 57) continue;
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_NUMERIC_STRING_INVALID_CHARACTER.get(n));
        }
        if (n2 == 0) {
            return aSN1OctetString;
        }
        n = 0;
        byte[] byArray2 = new byte[byArray.length - n2];
        for (byte by : byArray) {
            if (by == 32) continue;
            byArray2[n++] = by;
        }
        return new ASN1OctetString(byArray2);
    }

    public ASN1OctetString normalizeSubstring(ASN1OctetString aSN1OctetString, byte by) throws LDAPException {
        return this.normalize(aSN1OctetString);
    }
}

