/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class AddRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -1195296296055518601L;
    private final List<Attribute> attributes;
    private final String dn;

    public AddRequestProtocolOp(String string, List<Attribute> list) {
        this.dn = string;
        this.attributes = Collections.unmodifiableList(list);
    }

    public AddRequestProtocolOp(AddRequest addRequest) {
        this.dn = addRequest.getDN();
        this.attributes = addRequest.getAttributes();
    }

    AddRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            aSN1StreamReader.beginSequence();
            this.dn = aSN1StreamReader.readString();
            Validator.ensureNotNull(this.dn);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(10);
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            while (aSN1StreamReaderSequence.hasMoreElements()) {
                arrayList.add(Attribute.readFrom(aSN1StreamReader));
            }
            this.attributes = Collections.unmodifiableList(arrayList);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_ADD_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getProtocolOpType() {
        return 104;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Sequence> arrayList = new ArrayList<ASN1Sequence>(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            arrayList.add(attribute.encode());
        }
        return new ASN1Sequence(104, new ASN1OctetString(this.dn), new ASN1Sequence(arrayList));
    }

    public static AddRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
            ASN1Element[] aSN1ElementArray2 = ASN1Sequence.decodeAsSequence(aSN1ElementArray[1]).elements();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(aSN1ElementArray2.length);
            for (ASN1Element aSN1Element2 : aSN1ElementArray2) {
                arrayList.add(Attribute.decode(ASN1Sequence.decodeAsSequence(aSN1Element2)));
            }
            return new AddRequestProtocolOp(string, arrayList);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_ADD_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)104);
        aSN1Buffer.addOctetString(this.dn);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        for (Attribute attribute : this.attributes) {
            attribute.writeTo(aSN1Buffer);
        }
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    public AddRequest toAddRequest(Control ... controlArray) {
        return new AddRequest(this.dn, this.attributes, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("AddRequestProtocolOp(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', attrs={");
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(stringBuilder);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append("})");
    }
}

