/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.GenericSASLBindRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;

@InternalUseOnly
public final class BindRequestProtocolOp
implements ProtocolOp {
    public static final byte CRED_TYPE_SIMPLE = -128;
    public static final byte CRED_TYPE_SASL = -93;
    private static final long serialVersionUID = 6661208657485444954L;
    private final ASN1OctetString saslCredentials;
    private final ASN1OctetString simplePassword;
    private final byte credentialsType;
    private final int version;
    private final String bindDN;
    private final String saslMechanism;

    public BindRequestProtocolOp(String string, String string2) {
        this.bindDN = string == null ? "" : string;
        this.simplePassword = string2 == null ? new ASN1OctetString(-128) : new ASN1OctetString(-128, string2);
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(String string, byte[] byArray) {
        this.bindDN = string == null ? "" : string;
        this.simplePassword = byArray == null ? new ASN1OctetString(-128) : new ASN1OctetString(-128, byArray);
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(String string, String string2, ASN1OctetString aSN1OctetString) {
        this.saslMechanism = string2;
        this.saslCredentials = aSN1OctetString;
        this.bindDN = string == null ? "" : string;
        this.version = 3;
        this.credentialsType = (byte)-93;
        this.simplePassword = null;
    }

    public BindRequestProtocolOp(SimpleBindRequest simpleBindRequest) throws LDAPSDKUsageException {
        this.version = 3;
        this.credentialsType = (byte)-128;
        this.bindDN = simpleBindRequest.getBindDN();
        this.simplePassword = simpleBindRequest.getPassword();
        this.saslMechanism = null;
        this.saslCredentials = null;
        if (this.simplePassword == null) {
            throw new LDAPSDKUsageException(ProtocolMessages.ERR_BIND_REQUEST_CANNOT_CREATE_WITH_PASSWORD_PROVIDER.get());
        }
    }

    public BindRequestProtocolOp(GenericSASLBindRequest genericSASLBindRequest) {
        this.version = 3;
        this.credentialsType = (byte)-93;
        this.bindDN = genericSASLBindRequest.getBindDN();
        this.simplePassword = null;
        this.saslMechanism = genericSASLBindRequest.getSASLMechanismName();
        this.saslCredentials = genericSASLBindRequest.getCredentials();
    }

    BindRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            aSN1StreamReader.beginSequence();
            this.version = aSN1StreamReader.readInteger();
            this.bindDN = aSN1StreamReader.readString();
            this.credentialsType = (byte)aSN1StreamReader.peek();
            Validator.ensureNotNull(this.bindDN);
            switch (this.credentialsType) {
                case -128: {
                    this.simplePassword = new ASN1OctetString(this.credentialsType, aSN1StreamReader.readBytes());
                    this.saslMechanism = null;
                    this.saslCredentials = null;
                    Validator.ensureNotNull(this.bindDN);
                    break;
                }
                case -93: {
                    ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
                    this.saslMechanism = aSN1StreamReader.readString();
                    Validator.ensureNotNull(this.saslMechanism);
                    this.saslCredentials = aSN1StreamReaderSequence.hasMoreElements() ? new ASN1OctetString(aSN1StreamReader.readBytes()) : null;
                    this.simplePassword = null;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_INVALID_CRED_TYPE.get(StaticUtils.toHex(this.credentialsType)));
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    private BindRequestProtocolOp(int n, String string, byte by, ASN1OctetString aSN1OctetString, String string2, ASN1OctetString aSN1OctetString2) {
        this.version = n;
        this.bindDN = string;
        this.credentialsType = by;
        this.simplePassword = aSN1OctetString;
        this.saslMechanism = string2;
        this.saslCredentials = aSN1OctetString2;
    }

    public int getVersion() {
        return this.version;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public byte getCredentialsType() {
        return this.credentialsType;
    }

    public ASN1OctetString getSimplePassword() {
        return this.simplePassword;
    }

    public String getSASLMechanism() {
        return this.saslMechanism;
    }

    public ASN1OctetString getSASLCredentials() {
        return this.saslCredentials;
    }

    public byte getProtocolOpType() {
        return 96;
    }

    public ASN1Element encodeProtocolOp() {
        ASN1Element aSN1Element = this.credentialsType == -128 ? this.simplePassword : (this.saslCredentials == null ? new ASN1Sequence(-93, new ASN1OctetString(this.saslMechanism)) : new ASN1Sequence(-93, new ASN1OctetString(this.saslMechanism), this.saslCredentials));
        return new ASN1Sequence(96, new ASN1Integer(this.version), new ASN1OctetString(this.bindDN), aSN1Element);
    }

    public static BindRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1OctetString aSN1OctetString;
            String string;
            ASN1OctetString aSN1OctetString2;
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            int n = ASN1Integer.decodeAsInteger(aSN1ElementArray[0]).intValue();
            String string2 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[1]).stringValue();
            switch (aSN1ElementArray[2].getType()) {
                case -128: {
                    aSN1OctetString2 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[2]);
                    string = null;
                    aSN1OctetString = null;
                    break;
                }
                case -93: {
                    ASN1Element[] aSN1ElementArray2 = ASN1Sequence.decodeAsSequence(aSN1ElementArray[2]).elements();
                    string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray2[0]).stringValue();
                    aSN1OctetString = aSN1ElementArray2.length == 1 ? null : ASN1OctetString.decodeAsOctetString(aSN1ElementArray2[1]);
                    aSN1OctetString2 = null;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_INVALID_CRED_TYPE.get(StaticUtils.toHex(aSN1ElementArray[2].getType())));
                }
            }
            return new BindRequestProtocolOp(n, string2, aSN1ElementArray[2].getType(), aSN1OctetString2, string, aSN1OctetString);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)96);
        aSN1Buffer.addInteger(this.version);
        aSN1Buffer.addOctetString(this.bindDN);
        if (this.credentialsType == -128) {
            aSN1Buffer.addElement(this.simplePassword);
        } else {
            ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence((byte)-93);
            aSN1Buffer.addOctetString(this.saslMechanism);
            if (this.saslCredentials != null) {
                aSN1Buffer.addElement(this.saslCredentials);
            }
            aSN1BufferSequence2.end();
        }
        aSN1BufferSequence.end();
        aSN1Buffer.setZeroBufferOnClear();
    }

    public BindRequest toBindRequest(Control ... controlArray) {
        if (this.credentialsType == -128) {
            return new SimpleBindRequest(this.bindDN, this.simplePassword.getValue(), controlArray);
        }
        return new GenericSASLBindRequest(this.bindDN, this.saslMechanism, this.saslCredentials, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("BindRequestProtocolOp(version=");
        stringBuilder.append(this.version);
        stringBuilder.append(", bindDN='");
        stringBuilder.append(this.bindDN);
        stringBuilder.append("', type=");
        if (this.credentialsType == -128) {
            stringBuilder.append("simple");
        } else {
            stringBuilder.append("SASL, mechanism=");
            stringBuilder.append(this.saslMechanism);
        }
        stringBuilder.append(')');
    }
}

