/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class BindResponseProtocolOp
implements ProtocolOp {
    public static final byte TYPE_SERVER_SASL_CREDENTIALS = -121;
    private static final long serialVersionUID = -7757619031268544913L;
    private final ASN1OctetString serverSASLCredentials;
    private final int resultCode;
    private final List<String> referralURLs;
    private final String diagnosticMessage;
    private final String matchedDN;

    public BindResponseProtocolOp(int n, String string, String string2, List<String> list, ASN1OctetString aSN1OctetString) {
        this.resultCode = n;
        this.matchedDN = string;
        this.diagnosticMessage = string2;
        this.referralURLs = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.serverSASLCredentials = aSN1OctetString == null ? null : new ASN1OctetString(-121, aSN1OctetString.getValue());
    }

    public BindResponseProtocolOp(LDAPResult lDAPResult) {
        this.resultCode = lDAPResult.getResultCode().intValue();
        this.matchedDN = lDAPResult.getMatchedDN();
        this.diagnosticMessage = lDAPResult.getDiagnosticMessage();
        this.referralURLs = StaticUtils.toList(lDAPResult.getReferralURLs());
        if (lDAPResult instanceof BindResult) {
            BindResult bindResult = (BindResult)lDAPResult;
            this.serverSASLCredentials = bindResult.getServerSASLCredentials();
        } else {
            this.serverSASLCredentials = null;
        }
    }

    BindResponseProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            this.resultCode = aSN1StreamReader.readEnumerated();
            String string = aSN1StreamReader.readString();
            Validator.ensureNotNull(string);
            this.matchedDN = string.length() == 0 ? null : string;
            string = aSN1StreamReader.readString();
            Validator.ensureNotNull(string);
            this.diagnosticMessage = string.length() == 0 ? null : string;
            ASN1OctetString aSN1OctetString = null;
            ArrayList<String> arrayList = new ArrayList<String>(1);
            while (aSN1StreamReaderSequence.hasMoreElements()) {
                byte by = (byte)aSN1StreamReader.peek();
                if (by == -93) {
                    ASN1StreamReaderSequence aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
                    while (aSN1StreamReaderSequence2.hasMoreElements()) {
                        arrayList.add(aSN1StreamReader.readString());
                    }
                    continue;
                }
                if (by == -121) {
                    aSN1OctetString = new ASN1OctetString(by, aSN1StreamReader.readBytes());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(by)));
            }
            this.referralURLs = Collections.unmodifiableList(arrayList);
            this.serverSASLCredentials = aSN1OctetString;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getMatchedDN() {
        return this.matchedDN;
    }

    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    public ASN1OctetString getServerSASLCredentials() {
        return this.serverSASLCredentials;
    }

    @Override
    public byte getProtocolOpType() {
        return 97;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(5);
        arrayList.add(new ASN1Enumerated(this.getResultCode()));
        String string = this.getMatchedDN();
        if (string == null) {
            arrayList.add(new ASN1OctetString());
        } else {
            arrayList.add(new ASN1OctetString(string));
        }
        String string2 = this.getDiagnosticMessage();
        if (string2 == null) {
            arrayList.add(new ASN1OctetString());
        } else {
            arrayList.add(new ASN1OctetString(string2));
        }
        List<String> list = this.getReferralURLs();
        if (!list.isEmpty()) {
            ArrayList<ASN1OctetString> arrayList2 = new ArrayList<ASN1OctetString>(list.size());
            for (String string3 : list) {
                arrayList2.add(new ASN1OctetString(string3));
            }
            arrayList.add(new ASN1Sequence(-93, arrayList2));
        }
        if (this.serverSASLCredentials != null) {
            arrayList.add(this.serverSASLCredentials);
        }
        return new ASN1Sequence(97, arrayList);
    }

    public static BindResponseProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            int n = ASN1Enumerated.decodeAsEnumerated(aSN1ElementArray[0]).intValue();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[1]).stringValue();
            String string2 = string.length() > 0 ? string : null;
            String string3 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[2]).stringValue();
            String string4 = string3.length() > 0 ? string3 : null;
            ASN1OctetString aSN1OctetString = null;
            ArrayList<String> arrayList = null;
            if (aSN1ElementArray.length > 3) {
                block7: for (int i = 3; i < aSN1ElementArray.length; ++i) {
                    switch (aSN1ElementArray[i].getType()) {
                        case -93: {
                            ASN1Element[] aSN1ElementArray2 = ASN1Sequence.decodeAsSequence(aSN1ElementArray[3]).elements();
                            arrayList = new ArrayList<String>(aSN1ElementArray2.length);
                            for (ASN1Element aSN1Element2 : aSN1ElementArray2) {
                                arrayList.add(ASN1OctetString.decodeAsOctetString(aSN1Element2).stringValue());
                            }
                            continue block7;
                        }
                        case -121: {
                            aSN1OctetString = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[i]);
                            continue block7;
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(aSN1ElementArray[i].getType())));
                        }
                    }
                }
            }
            return new BindResponseProtocolOp(n, string2, string4, arrayList, aSN1OctetString);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_BIND_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)97);
        aSN1Buffer.addEnumerated(this.resultCode);
        aSN1Buffer.addOctetString(this.matchedDN);
        aSN1Buffer.addOctetString(this.diagnosticMessage);
        if (!this.referralURLs.isEmpty()) {
            ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence((byte)-93);
            for (String string : this.referralURLs) {
                aSN1Buffer.addOctetString(string);
            }
            aSN1BufferSequence2.end();
        }
        if (this.serverSASLCredentials != null) {
            aSN1Buffer.addElement(this.serverSASLCredentials);
        }
        aSN1BufferSequence.end();
    }

    public BindResult toBindResult(Control ... controlArray) {
        String[] stringArray;
        if (this.referralURLs.isEmpty()) {
            stringArray = StaticUtils.NO_STRINGS;
        } else {
            stringArray = new String[this.referralURLs.size()];
            this.referralURLs.toArray(stringArray);
        }
        return new BindResult(-1, ResultCode.valueOf(this.resultCode), this.diagnosticMessage, this.matchedDN, stringArray, controlArray, this.serverSASLCredentials);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("BindResponseProtocolOp(resultCode=");
        stringBuilder.append(this.resultCode);
        if (this.matchedDN != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(this.matchedDN);
            stringBuilder.append('\'');
        }
        if (this.diagnosticMessage != null) {
            stringBuilder.append(", diagnosticMessage='");
            stringBuilder.append(this.diagnosticMessage);
            stringBuilder.append('\'');
        }
        if (!this.referralURLs.isEmpty()) {
            stringBuilder.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append('\'');
                stringBuilder.append(iterator.next());
                stringBuilder.append('\'');
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

