/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;

@InternalUseOnly
public final class CompareRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -562642367801440060L;
    private final ASN1OctetString assertionValue;
    private final String attributeName;
    private final String dn;

    public CompareRequestProtocolOp(String string, String string2, ASN1OctetString aSN1OctetString) {
        this.dn = string;
        this.attributeName = string2;
        this.assertionValue = aSN1OctetString;
    }

    public CompareRequestProtocolOp(CompareRequest compareRequest) {
        this.dn = compareRequest.getDN();
        this.attributeName = compareRequest.getAttributeName();
        this.assertionValue = compareRequest.getRawAssertionValue();
    }

    CompareRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            aSN1StreamReader.beginSequence();
            this.dn = aSN1StreamReader.readString();
            aSN1StreamReader.beginSequence();
            this.attributeName = aSN1StreamReader.readString();
            this.assertionValue = new ASN1OctetString(aSN1StreamReader.readBytes());
            Validator.ensureNotNull(this.dn, this.attributeName, this.assertionValue);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_COMPARE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public ASN1OctetString getAssertionValue() {
        return this.assertionValue;
    }

    public byte getProtocolOpType() {
        return 110;
    }

    public ASN1Element encodeProtocolOp() {
        return new ASN1Sequence(110, new ASN1OctetString(this.dn), new ASN1Sequence(new ASN1OctetString(this.attributeName), this.assertionValue));
    }

    public static CompareRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
            ASN1Element[] aSN1ElementArray2 = ASN1Sequence.decodeAsSequence(aSN1ElementArray[1]).elements();
            String string2 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray2[0]).stringValue();
            ASN1OctetString aSN1OctetString = ASN1OctetString.decodeAsOctetString(aSN1ElementArray2[1]);
            return new CompareRequestProtocolOp(string, string2, aSN1OctetString);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_COMPARE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)110);
        aSN1Buffer.addOctetString(this.dn);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        aSN1Buffer.addOctetString(this.attributeName);
        aSN1Buffer.addElement(this.assertionValue);
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    public CompareRequest toCompareRequest(Control ... controlArray) {
        return new CompareRequest(this.dn, this.attributeName, this.assertionValue.getValue(), controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("CompareRequestProtocolOp(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', attributeName='");
        stringBuilder.append(this.attributeName);
        stringBuilder.append("', assertionValue='");
        stringBuilder.append(this.assertionValue.stringValue());
        stringBuilder.append("')");
    }
}

