/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public abstract class GenericResponseProtocolOp
implements ProtocolOp {
    public static final byte TYPE_REFERRALS = -93;
    private static final long serialVersionUID = 3837308973105414874L;
    private final byte type;
    private final int resultCode;
    private final List<String> referralURLs;
    private final String diagnosticMessage;
    private final String matchedDN;

    protected GenericResponseProtocolOp(byte by, int n, String string, String string2, List<String> list) {
        this.type = by;
        this.resultCode = n;
        this.matchedDN = string;
        this.diagnosticMessage = string2;
        this.referralURLs = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    protected GenericResponseProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            this.type = (byte)aSN1StreamReader.peek();
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            this.resultCode = aSN1StreamReader.readEnumerated();
            String string = aSN1StreamReader.readString();
            Validator.ensureNotNull(string);
            this.matchedDN = string.length() == 0 ? null : string;
            string = aSN1StreamReader.readString();
            Validator.ensureNotNull(string);
            this.diagnosticMessage = string.length() == 0 ? null : string;
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                ASN1StreamReaderSequence aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence2.hasMoreElements()) {
                    arrayList.add(aSN1StreamReader.readString());
                }
                this.referralURLs = Collections.unmodifiableList(arrayList);
            } else {
                this.referralURLs = Collections.emptyList();
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public final String getMatchedDN() {
        return this.matchedDN;
    }

    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public final List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public byte getProtocolOpType() {
        return this.type;
    }

    @Override
    public final void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence(this.type);
        aSN1Buffer.addEnumerated(this.resultCode);
        aSN1Buffer.addOctetString(this.matchedDN);
        aSN1Buffer.addOctetString(this.diagnosticMessage);
        if (!this.referralURLs.isEmpty()) {
            ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence((byte)-93);
            for (String string : this.referralURLs) {
                aSN1Buffer.addOctetString(string);
            }
            aSN1BufferSequence2.end();
        }
        aSN1BufferSequence.end();
    }

    public LDAPResult toLDAPResult(Control ... controlArray) {
        String[] stringArray;
        if (this.referralURLs.isEmpty()) {
            stringArray = StaticUtils.NO_STRINGS;
        } else {
            stringArray = new String[this.referralURLs.size()];
            this.referralURLs.toArray(stringArray);
        }
        return new LDAPResult(-1, ResultCode.valueOf(this.resultCode), this.diagnosticMessage, this.matchedDN, stringArray, controlArray);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public final void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ResponseProtocolOp(type=");
        StaticUtils.toHex(this.type, stringBuilder);
        stringBuilder.append(", resultCode=");
        stringBuilder.append(this.resultCode);
        if (this.matchedDN != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(this.matchedDN);
            stringBuilder.append('\'');
        }
        if (this.diagnosticMessage != null) {
            stringBuilder.append(", diagnosticMessage='");
            stringBuilder.append(this.diagnosticMessage);
            stringBuilder.append('\'');
        }
        if (!this.referralURLs.isEmpty()) {
            stringBuilder.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append('\'');
                stringBuilder.append(iterator.next());
                stringBuilder.append('\'');
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

