/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;

@InternalUseOnly
public final class IntermediateResponseProtocolOp
implements ProtocolOp {
    public static final byte TYPE_OID = -128;
    public static final byte TYPE_VALUE = -127;
    private static final long serialVersionUID = 118549806265654465L;
    private final ASN1OctetString value;
    private final String oid;

    public IntermediateResponseProtocolOp(String string, ASN1OctetString aSN1OctetString) {
        this.oid = string;
        this.value = aSN1OctetString == null ? null : new ASN1OctetString(-127, aSN1OctetString.getValue());
    }

    public IntermediateResponseProtocolOp(IntermediateResponse intermediateResponse) {
        this.oid = intermediateResponse.getOID();
        ASN1OctetString aSN1OctetString = intermediateResponse.getValue();
        this.value = aSN1OctetString == null ? null : new ASN1OctetString(-127, aSN1OctetString.getValue());
    }

    IntermediateResponseProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
            String string = null;
            ASN1OctetString aSN1OctetString = null;
            while (aSN1StreamReaderSequence.hasMoreElements()) {
                byte by = (byte)aSN1StreamReader.peek();
                if (by == -128) {
                    string = aSN1StreamReader.readString();
                    continue;
                }
                if (by == -127) {
                    aSN1OctetString = new ASN1OctetString(by, aSN1StreamReader.readBytes());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(by)));
            }
            this.oid = string;
            this.value = aSN1OctetString;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_INTERMEDIATE_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String getOID() {
        return this.oid;
    }

    public ASN1OctetString getValue() {
        return this.value;
    }

    public byte getProtocolOpType() {
        return 121;
    }

    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(2);
        if (this.oid != null) {
            arrayList.add(new ASN1OctetString(-128, this.oid));
        }
        if (this.value != null) {
            arrayList.add(this.value);
        }
        return new ASN1Sequence(121, arrayList);
    }

    public static IntermediateResponseProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            String string = null;
            ASN1OctetString aSN1OctetString = null;
            block7: for (ASN1Element aSN1Element2 : ASN1Sequence.decodeAsSequence(aSN1Element).elements()) {
                switch (aSN1Element2.getType()) {
                    case -128: {
                        string = ASN1OctetString.decodeAsOctetString(aSN1Element2).stringValue();
                        continue block7;
                    }
                    case -127: {
                        aSN1OctetString = ASN1OctetString.decodeAsOctetString(aSN1Element2);
                        continue block7;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(aSN1Element2.getType())));
                    }
                }
            }
            return new IntermediateResponseProtocolOp(string, aSN1OctetString);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_COMPARE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)121);
        if (this.oid != null) {
            aSN1Buffer.addOctetString((byte)-128, this.oid);
        }
        if (this.value != null) {
            aSN1Buffer.addElement(this.value);
        }
        aSN1BufferSequence.end();
    }

    public IntermediateResponse toIntermediateResponse(Control ... controlArray) {
        return new IntermediateResponse(-1, this.oid, this.value, controlArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("IntermediateResponseProtocolOp(");
        if (this.oid != null) {
            stringBuilder.append("oid='");
            stringBuilder.append(this.oid);
            stringBuilder.append('\'');
        }
        stringBuilder.append(')');
    }
}

