/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.GenericResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class ModifyResponseProtocolOp
extends GenericResponseProtocolOp {
    private static final long serialVersionUID = -6850364658234891786L;

    public ModifyResponseProtocolOp(int n, String string, String string2, List<String> list) {
        super((byte)103, n, string, string2, list);
    }

    public ModifyResponseProtocolOp(LDAPResult lDAPResult) {
        super((byte)103, lDAPResult.getResultCode().intValue(), lDAPResult.getMatchedDN(), lDAPResult.getDiagnosticMessage(), StaticUtils.toList(lDAPResult.getReferralURLs()));
    }

    ModifyResponseProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        super(aSN1StreamReader);
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(4);
        arrayList.add(new ASN1Enumerated(this.getResultCode()));
        String string = this.getMatchedDN();
        if (string == null) {
            arrayList.add(new ASN1OctetString());
        } else {
            arrayList.add(new ASN1OctetString(string));
        }
        String string2 = this.getDiagnosticMessage();
        if (string2 == null) {
            arrayList.add(new ASN1OctetString());
        } else {
            arrayList.add(new ASN1OctetString(string2));
        }
        List<String> list = this.getReferralURLs();
        if (!list.isEmpty()) {
            ArrayList<ASN1OctetString> arrayList2 = new ArrayList<ASN1OctetString>(list.size());
            for (String string3 : list) {
                arrayList2.add(new ASN1OctetString(string3));
            }
            arrayList.add(new ASN1Sequence(-93, arrayList2));
        }
        return new ASN1Sequence(103, arrayList);
    }

    public static ModifyResponseProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ArrayList<String> arrayList;
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            int n = ASN1Enumerated.decodeAsEnumerated(aSN1ElementArray[0]).intValue();
            String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[1]).stringValue();
            String string2 = string.length() > 0 ? string : null;
            String string3 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[2]).stringValue();
            String string4 = string3.length() > 0 ? string3 : null;
            if (aSN1ElementArray.length == 4) {
                ASN1Element[] aSN1ElementArray2 = ASN1Sequence.decodeAsSequence(aSN1ElementArray[3]).elements();
                arrayList = new ArrayList<String>(aSN1ElementArray2.length);
                for (ASN1Element aSN1Element2 : aSN1ElementArray2) {
                    arrayList.add(ASN1OctetString.decodeAsOctetString(aSN1Element2).stringValue());
                }
            } else {
                arrayList = null;
            }
            return new ModifyResponseProtocolOp(n, string2, string4, arrayList);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }
}

