/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ProtocolMessages {
    ERR_ABANDON_REQUEST_CANNOT_DECODE("Unable to read or decode an abandon request protocol op:  {0}"),
    ERR_ADD_REQUEST_CANNOT_DECODE("Unable to read or decode an add request protocol op:  {0}"),
    ERR_ADD_RESPONSE_CANNOT_DECODE("Unable to read or decode an add response protocol op:  {0}"),
    ERR_BIND_REQUEST_CANNOT_CREATE_WITH_PASSWORD_PROVIDER("Unable to create a bind request protocol op from a simple bind request object that uses a password provider rather than a statically-defined password."),
    ERR_BIND_REQUEST_CANNOT_DECODE("Unable to read or decode a bind request protocol op:  {0}"),
    ERR_BIND_REQUEST_INVALID_CRED_TYPE("Invalid credentials type {0} in a bind request protocol op."),
    ERR_BIND_RESPONSE_CANNOT_DECODE("Unable to read or decode a bind response protocol op:  {0}"),
    ERR_BIND_RESPONSE_INVALID_ELEMENT("Invalid element type {0} in a bind response protocol op."),
    ERR_COMPARE_REQUEST_CANNOT_DECODE("Unable to read or decode a compare request protocol op:  {0}"),
    ERR_COMPARE_RESPONSE_CANNOT_DECODE("Unable to read or decode a compare response protocol op:  {0}"),
    ERR_DELETE_REQUEST_CANNOT_DECODE("Unable to read or decode a delete request protocol op:  {0}"),
    ERR_DELETE_RESPONSE_CANNOT_DECODE("Unable to read or decode a delete response protocol op:  {0}"),
    ERR_EXTENDED_REQUEST_CANNOT_DECODE("Unable to read or decode an extended request protocol op:  {0}"),
    ERR_EXTENDED_RESPONSE_CANNOT_DECODE("Unable to read or decode an extended response:  {0}"),
    ERR_EXTENDED_RESPONSE_INVALID_ELEMENT("Invalid element type {0} in an extended response protocol op."),
    ERR_INTERMEDIATE_RESPONSE_CANNOT_DECODE("Unable to read or decode an intermediate response:  {0}"),
    ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT("Invalid element type {0} in an extended response protocol op."),
    ERR_MESSAGE_CANNOT_DECODE("Unable to read or decode an LDAP message:  {0}"),
    ERR_MESSAGE_DECODE_ERROR("An error occurred while attempting to decode the provided ASN.1 element as an LDAP message:  {0}"),
    ERR_MESSAGE_DECODE_INVALID_PROTOCOL_OP_TYPE("Unable to decode the provided ASN.1 element as an LDAP message because it has an invalid protocol op type of {0}."),
    ERR_MESSAGE_DECODE_VALUE_SEQUENCE_INVALID_ELEMENT_COUNT("Unable to decode the provided ASN.1 element as an LDAP message because the sequence had an invalid element count of {0,number,0}."),
    ERR_MESSAGE_INVALID_PROTOCOL_OP_TYPE("Invalid protocol op type {0} encountered in an LDAP message."),
    ERR_MESSAGE_IO_ERROR("An I/O error occurred while trying to read the response from the server:  {0}"),
    ERR_MESSAGE_PROTOCOL_OP_TYPE_NOT_RESPONSE("Request protocol op type {0} encountered in an LDAP message when a response type was expected."),
    ERR_MODIFY_DN_REQUEST_CANNOT_DECODE("Unable to read or decode a modify DN request protocol op:  {0}"),
    ERR_MODIFY_DN_RESPONSE_CANNOT_DECODE("Unable to read or decode a modify DN response protocol op:  {0}"),
    ERR_MODIFY_REQUEST_CANNOT_DECODE("Unable to read or decode a modify request protocol op:  {0}"),
    ERR_MODIFY_RESPONSE_CANNOT_DECODE("Unable to read or decode a modify response protocol op:  {0}"),
    ERR_RESPONSE_CANNOT_DECODE("Unable to read or decode an LDAP response:  {0}"),
    ERR_SEARCH_DONE_CANNOT_DECODE("Unable to read or decode a search result done protocol op:  {0}"),
    ERR_SEARCH_ENTRY_CANNOT_DECODE("Unable to read or decode a search result entry protocol op:  {0}"),
    ERR_SEARCH_REFERENCE_CANNOT_DECODE("Unable to read or decode a search result reference protocol op:  {0}"),
    ERR_SEARCH_REQUEST_CANNOT_DECODE("Unable to read or decode a search request protocol op:  {0}"),
    ERR_UNBIND_REQUEST_CANNOT_DECODE("Unable to read or decode an unbind request protocol op:  {0}");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<ProtocolMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<ProtocolMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private ProtocolMessages(String string2) {
        this.defaultText = string2;
    }

    public String get() {
        String string = MESSAGE_STRINGS.get((Object)this);
        if (string == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            try {
                string = RESOURCE_BUNDLE.getString(this.name());
            }
            catch (Exception exception) {
                string = this.defaultText;
            }
            MESSAGE_STRINGS.putIfAbsent(this, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... objectArray) {
        MessageFormat messageFormat = MESSAGES.get((Object)this);
        if (messageFormat == null) {
            if (RESOURCE_BUNDLE == null) {
                messageFormat = new MessageFormat(this.defaultText);
            } else {
                try {
                    messageFormat = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception exception) {
                    messageFormat = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, messageFormat);
        }
        MessageFormat messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return messageFormat.format(objectArray);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("unboundid-ldapsdk-protocol");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = resourceBundle;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

