/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;

@InternalUseOnly
public final class UnbindRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = 1703200292192488474L;

    public UnbindRequestProtocolOp() {
    }

    UnbindRequestProtocolOp(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            aSN1StreamReader.readNull();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_UNBIND_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public byte getProtocolOpType() {
        return 66;
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        aSN1Buffer.addNull((byte)66);
    }

    public ASN1Element encodeProtocolOp() {
        return new ASN1Null(66);
    }

    public static UnbindRequestProtocolOp decodeProtocolOp(ASN1Element aSN1Element) throws LDAPException {
        try {
            ASN1Null.decodeAsNull(aSN1Element);
            return new UnbindRequestProtocolOp();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_UNBIND_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("UnbindRequestProtocolOp()");
    }
}

