/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionPool
implements LDAPInterface {
    public abstract void close();

    public abstract void close(boolean var1, int var2);

    public abstract boolean isClosed();

    public abstract LDAPConnection getConnection() throws LDAPException;

    public abstract void releaseConnection(LDAPConnection var1);

    public abstract void releaseDefunctConnection(LDAPConnection var1);

    public final void releaseConnectionAfterException(LDAPConnection lDAPConnection, LDAPException lDAPException) {
        LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck = this.getHealthCheck();
        try {
            lDAPConnectionPoolHealthCheck.ensureConnectionValidAfterException(lDAPConnection, lDAPException);
            this.releaseConnection(lDAPConnection);
        }
        catch (LDAPException lDAPException2) {
            Debug.debugException(lDAPException2);
            this.releaseDefunctConnection(lDAPConnection);
        }
    }

    public abstract LDAPConnection replaceDefunctConnection(LDAPConnection var1) throws LDAPException;

    private LDAPConnection replaceDefunctConnection(Throwable throwable, LDAPConnection lDAPConnection) throws LDAPException {
        try {
            return this.replaceDefunctConnection(lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            if (throwable instanceof LDAPException) {
                throw (LDAPException)throwable;
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(throwable)), throwable);
        }
    }

    public final boolean retryFailedOperationsDueToInvalidConnections() {
        return !this.getOperationTypesToRetryDueToInvalidConnections().isEmpty();
    }

    public abstract Set<OperationType> getOperationTypesToRetryDueToInvalidConnections();

    public final void setRetryFailedOperationsDueToInvalidConnections(boolean bl) {
        if (bl) {
            this.setRetryFailedOperationsDueToInvalidConnections(EnumSet.allOf(OperationType.class));
        } else {
            this.setRetryFailedOperationsDueToInvalidConnections(EnumSet.noneOf(OperationType.class));
        }
    }

    public abstract void setRetryFailedOperationsDueToInvalidConnections(Set<OperationType> var1);

    public abstract int getCurrentAvailableConnections();

    public abstract int getMaximumAvailableConnections();

    public abstract LDAPConnectionPoolStatistics getConnectionPoolStatistics();

    public abstract String getConnectionPoolName();

    public abstract void setConnectionPoolName(String var1);

    public abstract LDAPConnectionPoolHealthCheck getHealthCheck();

    public abstract long getHealthCheckIntervalMillis();

    public abstract void setHealthCheckIntervalMillis(long var1);

    protected abstract void doHealthCheck();

    @Override
    public final RootDSE getRootDSE() throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            RootDSE rootDSE = lDAPConnection.getRootDSE();
            this.releaseConnection(lDAPConnection);
            return rootDSE;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.SEARCH, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                RootDSE rootDSE = lDAPConnection2.getRootDSE();
                this.releaseConnection(lDAPConnection2);
                return rootDSE;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final Schema getSchema() throws LDAPException {
        return this.getSchema("");
    }

    @Override
    public final Schema getSchema(String string) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            Schema schema = lDAPConnection.getSchema(string);
            this.releaseConnection(lDAPConnection);
            return schema;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.SEARCH, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                Schema schema = lDAPConnection2.getSchema(string);
                this.releaseConnection(lDAPConnection2);
                return schema;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final SearchResultEntry getEntry(String string) throws LDAPException {
        return this.getEntry(string, StaticUtils.NO_STRINGS);
    }

    @Override
    public final SearchResultEntry getEntry(String string, String ... stringArray) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            SearchResultEntry searchResultEntry = lDAPConnection.getEntry(string, stringArray);
            this.releaseConnection(lDAPConnection);
            return searchResultEntry;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.SEARCH, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                SearchResultEntry searchResultEntry = lDAPConnection2.getEntry(string, stringArray);
                this.releaseConnection(lDAPConnection2);
                return searchResultEntry;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final LDAPResult add(String string, Attribute ... attributeArray) throws LDAPException {
        return this.add(new AddRequest(string, attributeArray));
    }

    @Override
    public final LDAPResult add(String string, Collection<Attribute> collection) throws LDAPException {
        return this.add(new AddRequest(string, collection));
    }

    @Override
    public final LDAPResult add(Entry entry) throws LDAPException {
        return this.add(new AddRequest(entry));
    }

    @Override
    public final LDAPResult add(String ... stringArray) throws LDIFException, LDAPException {
        return this.add(new AddRequest(stringArray));
    }

    @Override
    public final LDAPResult add(AddRequest addRequest) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            LDAPResult lDAPResult = lDAPConnection.add(addRequest);
            this.releaseConnection(lDAPConnection);
            return lDAPResult;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.ADD, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                LDAPResult lDAPResult = lDAPConnection2.add(addRequest);
                this.releaseConnection(lDAPConnection2);
                return lDAPResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final LDAPResult add(ReadOnlyAddRequest readOnlyAddRequest) throws LDAPException {
        return this.add((AddRequest)readOnlyAddRequest);
    }

    public final BindResult bind(String string, String string2) throws LDAPException {
        return this.bind(new SimpleBindRequest(string, string2));
    }

    public final BindResult bind(BindRequest bindRequest) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            BindResult bindResult = lDAPConnection.bind(bindRequest);
            this.releaseConnection(lDAPConnection);
            return bindResult;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.BIND, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                BindResult bindResult = lDAPConnection2.bind(bindRequest);
                this.releaseConnection(lDAPConnection2);
                return bindResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final CompareResult compare(String string, String string2, String string3) throws LDAPException {
        return this.compare(new CompareRequest(string, string2, string3));
    }

    @Override
    public final CompareResult compare(CompareRequest compareRequest) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            CompareResult compareResult = lDAPConnection.compare(compareRequest);
            this.releaseConnection(lDAPConnection);
            return compareResult;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.COMPARE, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                CompareResult compareResult = lDAPConnection2.compare(compareRequest);
                this.releaseConnection(lDAPConnection2);
                return compareResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final CompareResult compare(ReadOnlyCompareRequest readOnlyCompareRequest) throws LDAPException {
        return this.compare((CompareRequest)readOnlyCompareRequest);
    }

    @Override
    public final LDAPResult delete(String string) throws LDAPException {
        return this.delete(new DeleteRequest(string));
    }

    @Override
    public final LDAPResult delete(DeleteRequest deleteRequest) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            LDAPResult lDAPResult = lDAPConnection.delete(deleteRequest);
            this.releaseConnection(lDAPConnection);
            return lDAPResult;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.DELETE, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                LDAPResult lDAPResult = lDAPConnection2.delete(deleteRequest);
                this.releaseConnection(lDAPConnection2);
                return lDAPResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final LDAPResult delete(ReadOnlyDeleteRequest readOnlyDeleteRequest) throws LDAPException {
        return this.delete((DeleteRequest)readOnlyDeleteRequest);
    }

    public final ExtendedResult processExtendedOperation(String string) throws LDAPException {
        return this.processExtendedOperation(new ExtendedRequest(string));
    }

    public final ExtendedResult processExtendedOperation(String string, ASN1OctetString aSN1OctetString) throws LDAPException {
        return this.processExtendedOperation(new ExtendedRequest(string, aSN1OctetString));
    }

    public final ExtendedResult processExtendedOperation(ExtendedRequest extendedRequest) throws LDAPException {
        if (extendedRequest.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_POOL_STARTTLS_NOT_ALLOWED.get());
        }
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            ExtendedResult extendedResult = lDAPConnection.processExtendedOperation(extendedRequest);
            this.releaseConnection(lDAPConnection);
            return extendedResult;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.EXTENDED, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                ExtendedResult extendedResult = lDAPConnection2.processExtendedOperation(extendedRequest);
                this.releaseConnection(lDAPConnection2);
                return extendedResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final LDAPResult modify(String string, Modification modification) throws LDAPException {
        return this.modify(new ModifyRequest(string, modification));
    }

    @Override
    public final LDAPResult modify(String string, Modification ... modificationArray) throws LDAPException {
        return this.modify(new ModifyRequest(string, modificationArray));
    }

    @Override
    public final LDAPResult modify(String string, List<Modification> list) throws LDAPException {
        return this.modify(new ModifyRequest(string, list));
    }

    @Override
    public final LDAPResult modify(String ... stringArray) throws LDIFException, LDAPException {
        return this.modify(new ModifyRequest(stringArray));
    }

    @Override
    public final LDAPResult modify(ModifyRequest modifyRequest) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            LDAPResult lDAPResult = lDAPConnection.modify(modifyRequest);
            this.releaseConnection(lDAPConnection);
            return lDAPResult;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.MODIFY, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                LDAPResult lDAPResult = lDAPConnection2.modify(modifyRequest);
                this.releaseConnection(lDAPConnection2);
                return lDAPResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final LDAPResult modify(ReadOnlyModifyRequest readOnlyModifyRequest) throws LDAPException {
        return this.modify((ModifyRequest)readOnlyModifyRequest);
    }

    @Override
    public final LDAPResult modifyDN(String string, String string2, boolean bl) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(string, string2, bl));
    }

    @Override
    public final LDAPResult modifyDN(String string, String string2, boolean bl, String string3) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(string, string2, bl, string3));
    }

    @Override
    public final LDAPResult modifyDN(ModifyDNRequest modifyDNRequest) throws LDAPException {
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            LDAPResult lDAPResult = lDAPConnection.modifyDN(modifyDNRequest);
            this.releaseConnection(lDAPConnection);
            return lDAPResult;
        }
        catch (Throwable throwable) {
            this.throwLDAPExceptionIfShouldNotRetry(throwable, OperationType.MODIFY_DN, lDAPConnection);
            LDAPConnection lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            try {
                LDAPResult lDAPResult = lDAPConnection2.modifyDN(modifyDNRequest);
                this.releaseConnection(lDAPConnection2);
                return lDAPResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final LDAPResult modifyDN(ReadOnlyModifyDNRequest readOnlyModifyDNRequest) throws LDAPException {
        return this.modifyDN((ModifyDNRequest)readOnlyModifyDNRequest);
    }

    @Override
    public final SearchResult search(String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(string, searchScope, AbstractConnectionPool.parseFilter(string2), stringArray));
    }

    @Override
    public final SearchResult search(String string, SearchScope searchScope, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(string, searchScope, filter, stringArray));
    }

    @Override
    public final SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, string, searchScope, AbstractConnectionPool.parseFilter(string2), stringArray));
    }

    @Override
    public final SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, string, searchScope, filter, stringArray));
    }

    @Override
    public final SearchResult search(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, String string2, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(string, searchScope, dereferencePolicy, n, n2, bl, AbstractConnectionPool.parseFilter(string2), stringArray));
    }

    @Override
    public final SearchResult search(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(string, searchScope, dereferencePolicy, n, n2, bl, filter, stringArray));
    }

    @Override
    public final SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, String string2, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, string, searchScope, dereferencePolicy, n, n2, bl, AbstractConnectionPool.parseFilter(string2), stringArray));
    }

    @Override
    public final SearchResult search(SearchResultListener searchResultListener, String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, string, searchScope, dereferencePolicy, n, n2, bl, filter, stringArray));
    }

    @Override
    public final SearchResult search(SearchRequest searchRequest) throws LDAPSearchException {
        LDAPConnection lDAPConnection;
        try {
            lDAPConnection = this.getConnection();
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
        try {
            SearchResult searchResult = lDAPConnection.search(searchRequest);
            this.releaseConnection(lDAPConnection);
            return searchResult;
        }
        catch (Throwable throwable) {
            LDAPConnection lDAPConnection2;
            this.throwLDAPSearchExceptionIfShouldNotRetry(throwable, lDAPConnection);
            try {
                lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                throw new LDAPSearchException(lDAPException);
            }
            try {
                SearchResult searchResult = lDAPConnection2.search(searchRequest);
                this.releaseConnection(lDAPConnection2);
                return searchResult;
            }
            catch (Throwable throwable2) {
                this.throwLDAPSearchException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final SearchResult search(ReadOnlySearchRequest readOnlySearchRequest) throws LDAPSearchException {
        return this.search((SearchRequest)readOnlySearchRequest);
    }

    @Override
    public final SearchResultEntry searchForEntry(String string, SearchScope searchScope, String string2, String ... stringArray) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(string, searchScope, DereferencePolicy.NEVER, 1, 0, false, AbstractConnectionPool.parseFilter(string2), stringArray));
    }

    @Override
    public final SearchResultEntry searchForEntry(String string, SearchScope searchScope, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(string, searchScope, DereferencePolicy.NEVER, 1, 0, false, filter, stringArray));
    }

    @Override
    public final SearchResultEntry searchForEntry(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, boolean bl, String string2, String ... stringArray) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(string, searchScope, dereferencePolicy, 1, n, bl, AbstractConnectionPool.parseFilter(string2), stringArray));
    }

    @Override
    public final SearchResultEntry searchForEntry(String string, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, boolean bl, Filter filter, String ... stringArray) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(string, searchScope, dereferencePolicy, 1, n, bl, filter, stringArray));
    }

    @Override
    public final SearchResultEntry searchForEntry(SearchRequest searchRequest) throws LDAPSearchException {
        LDAPConnection lDAPConnection;
        try {
            lDAPConnection = this.getConnection();
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
        try {
            SearchResultEntry searchResultEntry = lDAPConnection.searchForEntry(searchRequest);
            this.releaseConnection(lDAPConnection);
            return searchResultEntry;
        }
        catch (Throwable throwable) {
            LDAPConnection lDAPConnection2;
            this.throwLDAPSearchExceptionIfShouldNotRetry(throwable, lDAPConnection);
            try {
                lDAPConnection2 = this.replaceDefunctConnection(throwable, lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                throw new LDAPSearchException(lDAPException);
            }
            try {
                SearchResultEntry searchResultEntry = lDAPConnection2.searchForEntry(searchRequest);
                this.releaseConnection(lDAPConnection2);
                return searchResultEntry;
            }
            catch (Throwable throwable2) {
                this.throwLDAPSearchException(throwable2, lDAPConnection2);
                return null;
            }
        }
    }

    @Override
    public final SearchResultEntry searchForEntry(ReadOnlySearchRequest readOnlySearchRequest) throws LDAPSearchException {
        return this.searchForEntry((SearchRequest)readOnlySearchRequest);
    }

    private static Filter parseFilter(String string) throws LDAPSearchException {
        try {
            return Filter.create(string);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<LDAPResult> processRequests(List<LDAPRequest> list, boolean bl) throws LDAPException {
        ArrayList<LDAPResult> arrayList;
        block15: {
            LDAPConnection lDAPConnection;
            Validator.ensureNotNull(list);
            Validator.ensureFalse(list.isEmpty(), "LDAPConnectionPool.processRequests.requests must not be empty.");
            try {
                lDAPConnection = this.getConnection();
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                throw new LDAPSearchException(lDAPException);
            }
            arrayList = new ArrayList<LDAPResult>(list.size());
            boolean bl2 = false;
            try {
                block10: for (LDAPRequest lDAPRequest : list) {
                    try {
                        LDAPResult lDAPResult = lDAPRequest.process(lDAPConnection, 1);
                        arrayList.add(lDAPResult);
                        switch (lDAPResult.getResultCode().intValue()) {
                            case 0: 
                            case 5: 
                            case 6: 
                            case 16654: {
                                break;
                            }
                            default: {
                                if (!ResultCode.isConnectionUsable(lDAPResult.getResultCode())) {
                                    bl2 = true;
                                }
                                if (bl) continue block10;
                                break block15;
                            }
                        }
                    }
                    catch (LDAPException lDAPException) {
                        Debug.debugException(lDAPException);
                        arrayList.add(new LDAPResult(lDAPRequest.getLastMessageID(), lDAPException.getResultCode(), lDAPException.getMessage(), lDAPException.getMatchedDN(), lDAPException.getReferralURLs(), lDAPException.getResponseControls()));
                        if (!ResultCode.isConnectionUsable(lDAPException.getResultCode())) {
                            bl2 = true;
                        }
                        if (bl) continue;
                        break;
                    }
                }
            }
            finally {
                if (bl2) {
                    this.releaseDefunctConnection(lDAPConnection);
                } else {
                    this.releaseConnection(lDAPConnection);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<AsyncRequestID> processRequestsAsync(List<LDAPRequest> list, long l) throws LDAPException {
        LDAPConnection lDAPConnection;
        Validator.ensureNotNull(list);
        Validator.ensureFalse(list.isEmpty(), "LDAPConnectionPool.processRequests.requests must not be empty.");
        block21: for (LDAPRequest serializable2 : list) {
            switch (serializable2.getOperationType()) {
                case ADD: 
                case COMPARE: 
                case DELETE: 
                case MODIFY: 
                case MODIFY_DN: {
                    continue block21;
                }
                case SEARCH: {
                    SearchRequest bl = (SearchRequest)serializable2;
                    if (bl.getSearchResultListener() != null && bl.getSearchResultListener() instanceof AsyncSearchResultListener) continue block21;
                    throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_SEARCH_NOT_ASYNC.get(String.valueOf(serializable2)));
                }
            }
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_OP_NOT_ASYNC.get(String.valueOf(serializable2)));
        }
        try {
            lDAPConnection = this.getConnection();
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw new LDAPSearchException(lDAPException);
        }
        ArrayList<AsyncRequestID> arrayList = new ArrayList<AsyncRequestID>();
        boolean bl = false;
        try {
            if (lDAPConnection.synchronousMode()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_SYNCHRONOUS_MODE.get());
            }
            for (LDAPRequest lDAPRequest : list) {
                AsyncRequestID l3 = null;
                try {
                    switch (lDAPRequest.getOperationType()) {
                        case ADD: {
                            l3 = lDAPConnection.asyncAdd((AddRequest)lDAPRequest, null);
                            break;
                        }
                        case COMPARE: {
                            l3 = lDAPConnection.asyncCompare((CompareRequest)lDAPRequest, null);
                            break;
                        }
                        case DELETE: {
                            l3 = lDAPConnection.asyncDelete((DeleteRequest)lDAPRequest, null);
                            break;
                        }
                        case MODIFY: {
                            l3 = lDAPConnection.asyncModify((ModifyRequest)lDAPRequest, null);
                            break;
                        }
                        case MODIFY_DN: {
                            l3 = lDAPConnection.asyncModifyDN((ModifyDNRequest)lDAPRequest, null);
                            break;
                        }
                        case SEARCH: {
                            l3 = lDAPConnection.asyncSearch((SearchRequest)lDAPRequest);
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    l3 = new AsyncRequestID(lDAPRequest.getLastMessageID(), lDAPConnection);
                    l3.setResult(lDAPException.toLDAPResult());
                }
                arrayList.add(l3);
            }
            long l2 = System.currentTimeMillis();
            long l3 = l > 0L ? l2 + l : Long.MAX_VALUE;
            for (AsyncRequestID asyncRequestID : arrayList) {
                LDAPResult lDAPResult;
                long l4 = l3 - System.currentTimeMillis();
                if (l4 > 0L) {
                    try {
                        lDAPResult = asyncRequestID.get(l4, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception exception) {
                        Debug.debugException(exception);
                        asyncRequestID.cancel(true);
                        lDAPResult = exception instanceof TimeoutException ? new LDAPResult(asyncRequestID.getMessageID(), ResultCode.TIMEOUT, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_TIMEOUT.get(System.currentTimeMillis() - l2), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS) : new LDAPResult(asyncRequestID.getMessageID(), ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_EXCEPTION.get(StaticUtils.getExceptionMessage(exception)), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                        asyncRequestID.setResult(lDAPResult);
                    }
                } else {
                    asyncRequestID.cancel(true);
                    lDAPResult = new LDAPResult(asyncRequestID.getMessageID(), ResultCode.TIMEOUT, LDAPMessages.ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_TIMEOUT.get(System.currentTimeMillis() - l2), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                    asyncRequestID.setResult(lDAPResult);
                }
                if (ResultCode.isConnectionUsable(lDAPResult.getResultCode())) continue;
                bl = true;
            }
            ArrayList<AsyncRequestID> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (bl) {
                this.releaseDefunctConnection(lDAPConnection);
            } else {
                this.releaseConnection(lDAPConnection);
            }
        }
    }

    private void throwLDAPExceptionIfShouldNotRetry(Throwable throwable, OperationType operationType, LDAPConnection lDAPConnection) throws LDAPException {
        if (throwable instanceof LDAPException && this.getOperationTypesToRetryDueToInvalidConnections().contains((Object)operationType)) {
            LDAPException lDAPException = (LDAPException)throwable;
            LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck = this.getHealthCheck();
            try {
                lDAPConnectionPoolHealthCheck.ensureConnectionValidAfterException(lDAPConnection, lDAPException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                return;
            }
        }
        this.throwLDAPException(throwable, lDAPConnection);
    }

    private void throwLDAPSearchExceptionIfShouldNotRetry(Throwable throwable, LDAPConnection lDAPConnection) throws LDAPSearchException {
        if (throwable instanceof LDAPException && this.getOperationTypesToRetryDueToInvalidConnections().contains((Object)OperationType.SEARCH)) {
            LDAPException lDAPException = (LDAPException)throwable;
            LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck = this.getHealthCheck();
            try {
                lDAPConnectionPoolHealthCheck.ensureConnectionValidAfterException(lDAPConnection, lDAPException);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                return;
            }
        }
        this.throwLDAPSearchException(throwable, lDAPConnection);
    }

    void throwLDAPException(Throwable throwable, LDAPConnection lDAPConnection) throws LDAPException {
        Debug.debugException(throwable);
        if (throwable instanceof LDAPException) {
            LDAPException lDAPException = (LDAPException)throwable;
            this.releaseConnectionAfterException(lDAPConnection, lDAPException);
            throw lDAPException;
        }
        this.releaseDefunctConnection(lDAPConnection);
        throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(throwable)), throwable);
    }

    void throwLDAPSearchException(Throwable throwable, LDAPConnection lDAPConnection) throws LDAPSearchException {
        Debug.debugException(throwable);
        if (throwable instanceof LDAPException) {
            LDAPSearchException lDAPSearchException = throwable instanceof LDAPSearchException ? (LDAPSearchException)throwable : new LDAPSearchException((LDAPException)throwable);
            this.releaseConnectionAfterException(lDAPConnection, lDAPSearchException);
            throw lDAPSearchException;
        }
        this.releaseDefunctConnection(lDAPConnection);
        throw new LDAPSearchException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_POOL_OP_EXCEPTION.get(StaticUtils.getExceptionMessage(throwable)), throwable);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public abstract void toString(StringBuilder var1);
}

