/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncHelper;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldif.LDIFAddChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddRequest
extends UpdatableLDAPRequest
implements ReadOnlyAddRequest,
ResponseAcceptor,
ProtocolOp {
    private static final long serialVersionUID = 1320730292848237219L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private ArrayList<Attribute> attributes;
    private int messageID = -1;
    private String dn;

    public AddRequest(String string, Attribute ... attributeArray) {
        super(null);
        Validator.ensureNotNull(string, attributeArray);
        this.dn = string;
        this.attributes = new ArrayList(attributeArray.length);
        this.attributes.addAll(Arrays.asList(attributeArray));
    }

    public AddRequest(String string, Attribute[] attributeArray, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, attributeArray);
        this.dn = string;
        this.attributes = new ArrayList(attributeArray.length);
        this.attributes.addAll(Arrays.asList(attributeArray));
    }

    public AddRequest(String string, Collection<Attribute> collection) {
        super(null);
        Validator.ensureNotNull(string, collection);
        this.dn = string;
        this.attributes = new ArrayList<Attribute>(collection);
    }

    public AddRequest(String string, Collection<Attribute> collection, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, collection);
        this.dn = string;
        this.attributes = new ArrayList<Attribute>(collection);
    }

    public AddRequest(DN dN, Attribute ... attributeArray) {
        super(null);
        Validator.ensureNotNull(dN, attributeArray);
        this.dn = dN.toString();
        this.attributes = new ArrayList(attributeArray.length);
        this.attributes.addAll(Arrays.asList(attributeArray));
    }

    public AddRequest(DN dN, Attribute[] attributeArray, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, attributeArray);
        this.dn = dN.toString();
        this.attributes = new ArrayList(attributeArray.length);
        this.attributes.addAll(Arrays.asList(attributeArray));
    }

    public AddRequest(DN dN, Collection<Attribute> collection) {
        super(null);
        Validator.ensureNotNull(dN, collection);
        this.dn = dN.toString();
        this.attributes = new ArrayList<Attribute>(collection);
    }

    public AddRequest(DN dN, Collection<Attribute> collection, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, collection);
        this.dn = dN.toString();
        this.attributes = new ArrayList<Attribute>(collection);
    }

    public AddRequest(Entry entry) {
        super(null);
        Validator.ensureNotNull(entry);
        this.dn = entry.getDN();
        this.attributes = new ArrayList<Attribute>(entry.getAttributes());
    }

    public AddRequest(Entry entry, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(entry);
        this.dn = entry.getDN();
        this.attributes = new ArrayList<Attribute>(entry.getAttributes());
    }

    public AddRequest(String ... stringArray) throws LDIFException {
        this(LDIFReader.decodeEntry(stringArray));
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public void setDN(String string) {
        Validator.ensureNotNull(string);
        this.dn = string;
    }

    public void setDN(DN dN) {
        Validator.ensureNotNull(dN);
        this.dn = dN.toString();
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public Attribute getAttribute(String string) {
        Validator.ensureNotNull(string);
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().equalsIgnoreCase(string)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    @Override
    public boolean hasAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        Attribute attribute2 = this.getAttribute(attribute.getName());
        return attribute2 != null && attribute.equals(attribute2);
    }

    @Override
    public boolean hasAttributeValue(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        Attribute attribute = this.getAttribute(string);
        return attribute != null && attribute.hasValue(string2);
    }

    @Override
    public boolean hasAttributeValue(String string, String string2, MatchingRule matchingRule) {
        Validator.ensureNotNull(string, string2);
        Attribute attribute = this.getAttribute(string);
        return attribute != null && attribute.hasValue(string2, matchingRule);
    }

    @Override
    public boolean hasAttributeValue(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        Attribute attribute = this.getAttribute(string);
        return attribute != null && attribute.hasValue(byArray);
    }

    @Override
    public boolean hasAttributeValue(String string, byte[] byArray, MatchingRule matchingRule) {
        Validator.ensureNotNull(string, byArray);
        Attribute attribute = this.getAttribute(string);
        return attribute != null && attribute.hasValue(byArray, matchingRule);
    }

    @Override
    public boolean hasObjectClass(String string) {
        return this.hasAttributeValue("objectClass", string);
    }

    @Override
    public Entry toEntry() {
        return new Entry(this.dn, this.attributes);
    }

    public void setAttributes(Attribute[] attributeArray) {
        Validator.ensureNotNull(attributeArray);
        this.attributes.clear();
        this.attributes.addAll(Arrays.asList(attributeArray));
    }

    public void setAttributes(Collection<Attribute> collection) {
        Validator.ensureNotNull(collection);
        this.attributes.clear();
        this.attributes.addAll(collection);
    }

    public void addAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute2 = this.attributes.get(i);
            if (!attribute2.getName().equalsIgnoreCase(attribute.getName())) continue;
            this.attributes.set(i, Attribute.mergeAttributes(attribute2, attribute));
            return;
        }
        this.attributes.add(attribute);
    }

    public void addAttribute(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        this.addAttribute(new Attribute(string, string2));
    }

    public void addAttribute(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        this.addAttribute(new Attribute(string, byArray));
    }

    public void addAttribute(String string, String ... stringArray) {
        Validator.ensureNotNull(string, stringArray);
        this.addAttribute(new Attribute(string, stringArray));
    }

    public void addAttribute(String string, byte[] ... byArray) {
        Validator.ensureNotNull(string, byArray);
        this.addAttribute(new Attribute(string, byArray));
    }

    public boolean removeAttribute(String string) {
        Validator.ensureNotNull(string);
        Iterator<Attribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.getName().equalsIgnoreCase(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeAttributeValue(String string, String string2) {
        Attribute attribute;
        Validator.ensureNotNull(string, string2);
        int n = -1;
        for (int i = 0; i < this.attributes.size(); ++i) {
            attribute = this.attributes.get(i);
            if (!attribute.getName().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return false;
        }
        Attribute attribute2 = this.attributes.get(n);
        attribute = Attribute.removeValues(attribute2, new Attribute(string, string2));
        if (attribute2.getRawValues().length == attribute.getRawValues().length) {
            return false;
        }
        if (attribute.getRawValues().length == 0) {
            this.attributes.remove(n);
        } else {
            this.attributes.set(n, attribute);
        }
        return true;
    }

    public boolean removeAttribute(String string, byte[] byArray) {
        Attribute attribute;
        Validator.ensureNotNull(string, byArray);
        int n = -1;
        for (int i = 0; i < this.attributes.size(); ++i) {
            attribute = this.attributes.get(i);
            if (!attribute.getName().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return false;
        }
        Attribute attribute2 = this.attributes.get(n);
        attribute = Attribute.removeValues(attribute2, new Attribute(string, byArray));
        if (attribute2.getRawValues().length == attribute.getRawValues().length) {
            return false;
        }
        if (attribute.getRawValues().length == 0) {
            this.attributes.remove(n);
        } else {
            this.attributes.set(n, attribute);
        }
        return true;
    }

    public void replaceAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(attribute.getName())) continue;
            this.attributes.set(i, attribute);
            return;
        }
        this.attributes.add(attribute);
    }

    public void replaceAttribute(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(string)) continue;
            this.attributes.set(i, new Attribute(string, string2));
            return;
        }
        this.attributes.add(new Attribute(string, string2));
    }

    public void replaceAttribute(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(string)) continue;
            this.attributes.set(i, new Attribute(string, byArray));
            return;
        }
        this.attributes.add(new Attribute(string, byArray));
    }

    public void replaceAttribute(String string, String ... stringArray) {
        Validator.ensureNotNull(string, stringArray);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(string)) continue;
            this.attributes.set(i, new Attribute(string, stringArray));
            return;
        }
        this.attributes.add(new Attribute(string, stringArray));
    }

    public void replaceAttribute(String string, byte[] ... byArray) {
        Validator.ensureNotNull(string, byArray);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equalsIgnoreCase(string)) continue;
            this.attributes.set(i, new Attribute(string, byArray));
            return;
        }
        this.attributes.add(new Attribute(string, byArray));
    }

    @Override
    public byte getProtocolOpType() {
        return 104;
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)104);
        aSN1Buffer.addOctetString(this.dn);
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        for (Attribute attribute : this.attributes) {
            attribute.writeTo(aSN1Buffer);
        }
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] aSN1ElementArray = new ASN1Element[this.attributes.size()];
        for (int i = 0; i < aSN1ElementArray.length; ++i) {
            aSN1ElementArray[i] = this.attributes.get(i).encode();
        }
        ASN1Element[] aSN1ElementArray2 = new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1Sequence(aSN1ElementArray)};
        return new ASN1Sequence(104, aSN1ElementArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LDAPResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            boolean bl = lDAPConnection.getConnectionOptions().autoReconnect();
            return this.processSync(lDAPConnection, n, bl);
        }
        long l = System.nanoTime();
        this.processAsync(lDAPConnection, null);
        try {
            LDAPResponse lDAPResponse;
            try {
                long l2 = this.getResponseTimeoutMillis(lDAPConnection);
                lDAPResponse = l2 > 0L ? this.responseQueue.poll(l2, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_ADD_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
            }
            LDAPResult lDAPResult = this.handleResponse(lDAPConnection, lDAPResponse, l, n, false);
            Object var9_9 = null;
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
            return lDAPResult;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
            throw throwable;
        }
    }

    AsyncRequestID processAsync(LDAPConnection lDAPConnection, AsyncResultListener asyncResultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (asyncResultListener == null) {
            asyncRequestID = null;
            lDAPConnection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncHelper asyncHelper = new AsyncHelper(lDAPConnection, OperationType.ADD, this.messageID, asyncResultListener, this.getIntermediateResponseListener());
            lDAPConnection.registerResponseAcceptor(this.messageID, asyncHelper);
            asyncRequestID = asyncHelper.getAsyncRequestID();
            long l = this.getResponseTimeoutMillis(lDAPConnection);
            if (l > 0L) {
                Timer timer = lDAPConnection.getTimer();
                AsyncTimeoutTimerTask asyncTimeoutTimerTask = new AsyncTimeoutTimerTask(asyncHelper);
                timer.schedule((TimerTask)asyncTimeoutTimerTask, l);
                asyncRequestID.setTimerTask(asyncTimeoutTimerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(this);
            lDAPConnection.getConnectionStatistics().incrementNumAddRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            return asyncRequestID;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
            throw lDAPException;
        }
    }

    private LDAPResult processSync(LDAPConnection lDAPConnection, int n, boolean bl) throws LDAPException {
        LDAPResponse lDAPResponse;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(lDAPConnection));
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        long l = System.nanoTime();
        Debug.debugLDAPRequest(this);
        lDAPConnection.getConnectionStatistics().incrementNumAddRequests();
        try {
            lDAPConnection.sendMessage(lDAPMessage);
        }
        catch (LDAPException lDAPException) {
            LDAPResult lDAPResult;
            Debug.debugException(lDAPException);
            if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                return lDAPResult;
            }
            throw lDAPException;
        }
        while (true) {
            try {
                lDAPResponse = lDAPConnection.readResponse(this.messageID);
            }
            catch (LDAPException lDAPException) {
                LDAPResult lDAPResult;
                Debug.debugException(lDAPException);
                if (lDAPException.getResultCode() == ResultCode.TIMEOUT && lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                    lDAPConnection.abandon(this.messageID, new Control[0]);
                }
                if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                    return lDAPResult;
                }
                throw lDAPException;
            }
            if (!(lDAPResponse instanceof IntermediateResponse)) break;
            IntermediateResponseListener intermediateResponseListener = this.getIntermediateResponseListener();
            if (intermediateResponseListener == null) continue;
            intermediateResponseListener.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l, n, bl);
    }

    private LDAPResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l, int n, boolean bl) throws LDAPException {
        LDAPResult lDAPResult;
        if (lDAPResponse == null) {
            long l2 = StaticUtils.nanosToMillis(System.nanoTime() - l);
            if (lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                lDAPConnection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_ADD_CLIENT_TIMEOUT.get(l2, this.messageID, this.dn, lDAPConnection.getHostPort()));
        }
        lDAPConnection.getConnectionStatistics().incrementNumAddResponses(System.nanoTime() - l);
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            Serializable serializable;
            if (bl && (serializable = this.reconnectAndRetry(lDAPConnection, n, ResultCode.SERVER_DOWN)) != null) {
                return serializable;
            }
            serializable = (ConnectionClosedResponse)lDAPResponse;
            String string = ((ConnectionClosedResponse)serializable).getMessage();
            if (string == null) {
                throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ADD_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()));
            }
            throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ADD_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), string));
        }
        LDAPResult lDAPResult2 = (LDAPResult)lDAPResponse;
        if (lDAPResult2.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(lDAPConnection)) {
            if (n >= lDAPConnection.getConnectionOptions().getReferralHopLimit()) {
                return new LDAPResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), lDAPResult2.getMatchedDN(), lDAPResult2.getReferralURLs(), lDAPResult2.getResponseControls());
            }
            return this.followReferral(lDAPResult2, lDAPConnection, n);
        }
        if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPResult2.getResultCode())) != null) {
            return lDAPResult;
        }
        return lDAPResult2;
    }

    private LDAPResult reconnectAndRetry(LDAPConnection lDAPConnection, int n, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    lDAPConnection.reconnect();
                    return this.processSync(lDAPConnection, n, false);
                }
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followReferral(LDAPResult lDAPResult, LDAPConnection lDAPConnection, int n) throws LDAPException {
        for (String string : lDAPResult.getReferralURLs()) {
            LDAPURL lDAPURL = new LDAPURL(string);
            String string2 = lDAPURL.getHost();
            if (string2 == null) continue;
            AddRequest addRequest = lDAPURL.baseDNProvided() ? new AddRequest(lDAPURL.getBaseDN(), this.attributes, this.getControls()) : this;
            LDAPConnection lDAPConnection2 = lDAPConnection.getReferralConnector().getReferralConnection(lDAPURL, lDAPConnection);
            try {
                LDAPResult lDAPResult2 = addRequest.process(lDAPConnection2, n + 1);
                {
                    Object var14_14 = null;
                    lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    lDAPConnection2.close();
                }
                return lDAPResult2;
            }
            catch (Throwable throwable) {
                try {
                    Object var14_15 = null;
                    lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    lDAPConnection2.close();
                    throw throwable;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
        }
        return lDAPResult;
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.ADD;
    }

    @Override
    public AddRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public AddRequest duplicate(Control[] controlArray) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.attributes);
        AddRequest addRequest = new AddRequest(this.dn, arrayList, controlArray);
        if (this.followReferralsInternal() != null) {
            addRequest.setFollowReferrals(this.followReferralsInternal());
        }
        addRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return addRequest;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public LDIFAddChangeRecord toLDIFChangeRecord() {
        return new LDIFAddChangeRecord(this);
    }

    @Override
    public String[] toLDIF() {
        return this.toLDIFChangeRecord().toLDIF();
    }

    @Override
    public String toLDIFString() {
        return this.toLDIFChangeRecord().toLDIFString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("AddRequest(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', attrs={");
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.attributes.get(i));
        }
        stringBuilder.append('}');
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(this.attributes.size() + 1);
        arrayList.add(ToCodeArgHelper.createString(this.dn, "Entry DN"));
        boolean bl2 = true;
        for (Attribute attribute : this.attributes) {
            String string2;
            if (bl2) {
                bl2 = false;
                string2 = "Entry Attributes";
            } else {
                string2 = null;
            }
            arrayList.add(ToCodeArgHelper.createAttribute(attribute, string2));
        }
        ToCodeHelper.generateMethodCall(list, n, "AddRequest", string + "Request", "new AddRequest", arrayList);
        for (Control control : this.getControls()) {
            ToCodeHelper.generateMethodCall(list, n, null, null, string + "Request.addControl", ToCodeArgHelper.createControl(control, null));
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string3 = stringBuilder.toString();
            list.add("");
            list.add(string3 + "try");
            list.add(string3 + '{');
            list.add(string3 + "  LDAPResult " + string + "Result = connection.add(" + string + "Request);");
            list.add(string3 + "  // The add was processed successfully.");
            list.add(string3 + '}');
            list.add(string3 + "catch (LDAPException e)");
            list.add(string3 + '{');
            list.add(string3 + "  // The add failed.  Maybe the following will " + "help explain why.");
            list.add(string3 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string3 + "  String message = e.getMessage();");
            list.add(string3 + "  String matchedDN = e.getMatchedDN();");
            list.add(string3 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string3 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string3 + '}');
        }
    }
}

