/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncCompareHelper
implements CommonAsyncHelper,
IntermediateResponseListener {
    private static final long serialVersionUID = 8888333889563000881L;
    private final AsyncCompareResultListener resultListener;
    private final AsyncRequestID asyncRequestID;
    private final AtomicBoolean responseReturned;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncCompareHelper(LDAPConnection lDAPConnection, int n, AsyncCompareResultListener asyncCompareResultListener, IntermediateResponseListener intermediateResponseListener) {
        this.connection = lDAPConnection;
        this.resultListener = asyncCompareResultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.asyncRequestID = new AsyncRequestID(n, lDAPConnection);
        this.responseReturned = new AtomicBoolean(false);
        this.createTime = System.nanoTime();
    }

    public AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    public LDAPConnection getConnection() {
        return this.connection;
    }

    public long getCreateTimeNanos() {
        return this.createTime;
    }

    public OperationType getOperationType() {
        return OperationType.COMPARE;
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        ConnectionClosedResponse connectionClosedResponse;
        String string;
        if (!this.responseReturned.compareAndSet(false, true)) {
            return;
        }
        long l = System.nanoTime() - this.createTime;
        CompareResult compareResult = lDAPResponse instanceof ConnectionClosedResponse ? ((string = (connectionClosedResponse = (ConnectionClosedResponse)lDAPResponse).getMessage()) == null ? new CompareResult(this.asyncRequestID.getMessageID(), connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS) : new CompareResult(this.asyncRequestID.getMessageID(), connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(string), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS)) : (CompareResult)lDAPResponse;
        this.connection.getConnectionStatistics().incrementNumCompareResponses(l);
        this.resultListener.compareResultReceived(this.asyncRequestID, compareResult);
        this.asyncRequestID.setResult(compareResult);
    }

    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

