/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncRequestID
implements Serializable,
Future<LDAPResult> {
    private static final long serialVersionUID = 8244005138437962030L;
    private final ArrayBlockingQueue<LDAPResult> resultQueue;
    private final AtomicBoolean cancelRequested;
    private final AtomicReference<LDAPResult> result;
    private final int messageID;
    private final LDAPConnection connection;
    private volatile AsyncTimeoutTimerTask timerTask;

    AsyncRequestID(int n, LDAPConnection lDAPConnection) {
        this.messageID = n;
        this.connection = lDAPConnection;
        this.resultQueue = new ArrayBlockingQueue(1);
        this.cancelRequested = new AtomicBoolean(false);
        this.result = new AtomicReference();
        this.timerTask = null;
    }

    public int getMessageID() {
        return this.messageID;
    }

    @Override
    public boolean cancel(boolean bl) {
        if (this.isDone()) {
            return false;
        }
        try {
            this.cancelRequested.set(true);
            this.result.compareAndSet(null, new LDAPResult(this.messageID, ResultCode.USER_CANCELED, LDAPMessages.INFO_ASYNC_REQUEST_USER_CANCELED.get(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS));
            this.connection.abandon(this);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelRequested.get();
    }

    @Override
    public boolean isDone() {
        if (this.cancelRequested.get()) {
            return true;
        }
        if (this.result.get() != null) {
            return true;
        }
        LDAPResult lDAPResult = this.resultQueue.poll();
        if (lDAPResult != null) {
            this.result.set(lDAPResult);
            return true;
        }
        return false;
    }

    @Override
    public LDAPResult get() throws InterruptedException {
        long l = this.connection.getConnectionOptions().getResponseTimeoutMillis();
        try {
            return this.get(l, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            Debug.debugException(timeoutException);
            return new LDAPResult(this.messageID, ResultCode.TIMEOUT, timeoutException.getMessage(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
        }
    }

    @Override
    public LDAPResult get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        LDAPResult lDAPResult = this.resultQueue.poll();
        if (lDAPResult != null) {
            this.result.set(lDAPResult);
            return lDAPResult;
        }
        LDAPResult lDAPResult2 = this.result.get();
        if (lDAPResult2 != null) {
            return lDAPResult2;
        }
        LDAPResult lDAPResult3 = this.resultQueue.poll(l, timeUnit);
        if (lDAPResult3 == null) {
            long l2 = timeUnit.toMillis(l);
            throw new TimeoutException(LDAPMessages.WARN_ASYNC_REQUEST_GET_TIMEOUT.get(l2));
        }
        this.result.set(lDAPResult3);
        return lDAPResult3;
    }

    void setTimerTask(AsyncTimeoutTimerTask asyncTimeoutTimerTask) {
        this.timerTask = asyncTimeoutTimerTask;
    }

    void setResult(LDAPResult lDAPResult) {
        this.resultQueue.offer(lDAPResult);
        AsyncTimeoutTimerTask asyncTimeoutTimerTask = this.timerTask;
        if (asyncTimeoutTimerTask != null) {
            asyncTimeoutTimerTask.cancel();
            this.connection.getTimer().purge();
            this.timerTask = null;
        }
    }

    public int hashCode() {
        return this.messageID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AsyncRequestID) {
            return ((AsyncRequestID)object).messageID == this.messageID;
        }
        return false;
    }

    public String toString() {
        return "AsyncRequestID(messageID=" + this.messageID + ')';
    }
}

