/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;

public class BindResult
extends LDAPResult {
    private static final byte TYPE_SERVER_SASL_CREDENTIALS = -121;
    private static final long serialVersionUID = 2211625049303605730L;
    private final ASN1OctetString serverSASLCredentials;

    public BindResult(int n, ResultCode resultCode, String string, String string2, String[] stringArray, Control[] controlArray) {
        this(n, resultCode, string, string2, stringArray, controlArray, null);
    }

    public BindResult(int n, ResultCode resultCode, String string, String string2, String[] stringArray, Control[] controlArray, ASN1OctetString aSN1OctetString) {
        super(n, resultCode, string, string2, stringArray, controlArray);
        this.serverSASLCredentials = aSN1OctetString;
    }

    public BindResult(LDAPResult lDAPResult) {
        super(lDAPResult);
        this.serverSASLCredentials = null;
    }

    public BindResult(LDAPException lDAPException) {
        super(lDAPException.toLDAPResult());
        this.serverSASLCredentials = null;
    }

    protected BindResult(BindResult bindResult) {
        super(bindResult);
        this.serverSASLCredentials = bindResult.serverSASLCredentials;
    }

    static BindResult readBindResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ASN1StreamReaderSequence aSN1StreamReaderSequence2;
            ArrayList<Object> arrayList;
            String string;
            ASN1StreamReaderSequence aSN1StreamReaderSequence3 = aSN1StreamReader.beginSequence();
            ResultCode resultCode = ResultCode.valueOf(aSN1StreamReader.readEnumerated());
            String string2 = aSN1StreamReader.readString();
            if (string2.length() == 0) {
                string2 = null;
            }
            if ((string = aSN1StreamReader.readString()).length() == 0) {
                string = null;
            }
            String[] stringArray = null;
            ASN1OctetString aSN1OctetString = null;
            block7: while (aSN1StreamReaderSequence3.hasMoreElements()) {
                byte by = (byte)aSN1StreamReader.peek();
                switch (by) {
                    case -93: {
                        arrayList = new ArrayList(1);
                        aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
                        while (aSN1StreamReaderSequence2.hasMoreElements()) {
                            arrayList.add(aSN1StreamReader.readString());
                        }
                        stringArray = new String[arrayList.size()];
                        arrayList.toArray(stringArray);
                        continue block7;
                    }
                    case -121: {
                        aSN1OctetString = new ASN1OctetString(by, aSN1StreamReader.readBytes());
                        continue block7;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_BIND_RESULT_INVALID_ELEMENT.get(StaticUtils.toHex(by)));
            }
            Control[] controlArray = NO_CONTROLS;
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                arrayList = new ArrayList<Object>(1);
                aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence2.hasMoreElements()) {
                    arrayList.add(Control.readFrom(aSN1StreamReader));
                }
                controlArray = new Control[arrayList.size()];
                arrayList.toArray(controlArray);
            }
            return new BindResult(n, resultCode, string, string2, stringArray, controlArray, aSN1OctetString);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_BIND_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public ASN1OctetString getServerSASLCredentials() {
        return this.serverSASLCredentials;
    }

    public void toString(StringBuilder stringBuilder) {
        String[] stringArray;
        String string;
        String string2;
        stringBuilder.append("BindResult(resultCode=");
        stringBuilder.append(this.getResultCode());
        int n = this.getMessageID();
        if (n >= 0) {
            stringBuilder.append(", messageID=");
            stringBuilder.append(n);
        }
        if ((string2 = this.getDiagnosticMessage()) != null) {
            stringBuilder.append(", diagnosticMessage='");
            stringBuilder.append(string2);
            stringBuilder.append('\'');
        }
        if ((string = this.getMatchedDN()) != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(string);
            stringBuilder.append('\'');
        }
        if ((stringArray = this.getReferralURLs()).length > 0) {
            stringBuilder.append(", referralURLs={");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(stringArray[i]);
                stringBuilder.append('\'');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(", hasServerSASLCredentials=");
        stringBuilder.append(this.serverSASLCredentials != null);
        Control[] controlArray = this.getResponseControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", responseControls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

