/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.CompactAttribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompactEntry
implements Serializable {
    private static final long serialVersionUID = 8067151651120794058L;
    private final CompactAttribute[] attributes;
    private int hashCode;
    private final String dn;

    public CompactEntry(Entry entry) {
        Validator.ensureNotNull(entry);
        this.dn = entry.getDN();
        this.hashCode = -1;
        Collection<Attribute> collection = entry.getAttributes();
        this.attributes = new CompactAttribute[collection.size()];
        Iterator<Attribute> iterator = collection.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new CompactAttribute(iterator.next());
        }
    }

    public String getDN() {
        return this.dn;
    }

    public DN getParsedDN() throws LDAPException {
        return new DN(this.dn);
    }

    public RDN getRDN() throws LDAPException {
        return this.getParsedDN().getRDN();
    }

    public DN getParentDN() throws LDAPException {
        return this.getParsedDN().getParent();
    }

    public String getParentDNString() throws LDAPException {
        return this.getParsedDN().getParentString();
    }

    public boolean hasAttribute(String string) {
        Validator.ensureNotNull(string);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.toAttribute().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string) || !compactAttribute.toAttribute().hasValue(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string) || !compactAttribute.toAttribute().hasValue(byArray)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObjectClass(String string) {
        return this.hasAttributeValue("objectClass", string);
    }

    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.attributes.length);
        for (CompactAttribute compactAttribute : this.attributes) {
            arrayList.add(compactAttribute.toAttribute());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Attribute getAttribute(String string) {
        Validator.ensureNotNull(string);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string)) continue;
            return compactAttribute.toAttribute();
        }
        return null;
    }

    public List<Attribute> getAttributesWithOptions(String string, Set<String> set) {
        return this.toEntry().getAttributesWithOptions(string, set);
    }

    public String getAttributeValue(String string) {
        Validator.ensureNotNull(string);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string)) continue;
            String[] stringArray = compactAttribute.getStringValues();
            if (stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }
        return null;
    }

    public byte[] getAttributeValueBytes(String string) {
        Validator.ensureNotNull(string);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string)) continue;
            byte[][] byArray = compactAttribute.getByteValues();
            if (byArray.length > 0) {
                return byArray[0];
            }
            return null;
        }
        return null;
    }

    public Boolean getAttributeValueAsBoolean(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.getAttribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsBoolean();
    }

    public Date getAttributeValueAsDate(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.getAttribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsDate();
    }

    public DN getAttributeValueAsDN(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.getAttribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsDN();
    }

    public Integer getAttributeValueAsInteger(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.getAttribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsInteger();
    }

    public Long getAttributeValueAsLong(String string) {
        Validator.ensureNotNull(string);
        Attribute attribute = this.getAttribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsLong();
    }

    public String[] getAttributeValues(String string) {
        Validator.ensureNotNull(string);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string)) continue;
            return compactAttribute.getStringValues();
        }
        return null;
    }

    public byte[][] getAttributeValueByteArrays(String string) {
        Validator.ensureNotNull(string);
        for (CompactAttribute compactAttribute : this.attributes) {
            if (!compactAttribute.getName().equalsIgnoreCase(string)) continue;
            return compactAttribute.getByteValues();
        }
        return null;
    }

    public Attribute getObjectClassAttribute() {
        return this.getAttribute("objectClass");
    }

    public String[] getObjectClassValues() {
        return this.getAttributeValues("objectClass");
    }

    public Entry toEntry() {
        Attribute[] attributeArray = new Attribute[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            attributeArray[i] = this.attributes[i].toAttribute();
        }
        return new Entry(this.dn, attributeArray);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toEntry().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CompactEntry)) {
            return false;
        }
        return this.toEntry().equals(((CompactEntry)object).toEntry());
    }

    public String[] toLDIF() {
        return this.toLDIF(0);
    }

    public String[] toLDIF(int n) {
        return this.toEntry().toLDIF(n);
    }

    public void toLDIF(ByteStringBuffer byteStringBuffer) {
        this.toLDIF(byteStringBuffer, 0);
    }

    public void toLDIF(ByteStringBuffer byteStringBuffer, int n) {
        this.toEntry().toLDIF(byteStringBuffer, n);
    }

    public String toLDIFString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIFString(stringBuilder, 0);
        return stringBuilder.toString();
    }

    public String toLDIFString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIFString(stringBuilder, n);
        return stringBuilder.toString();
    }

    public void toLDIFString(StringBuilder stringBuilder) {
        this.toLDIFString(stringBuilder, 0);
    }

    public void toLDIFString(StringBuilder stringBuilder, int n) {
        this.toEntry().toLDIFString(stringBuilder, n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("Entry(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', attributes={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.attributes[i].toAttribute().toString(stringBuilder);
        }
        stringBuilder.append("})");
    }
}

