/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DN
implements Comparable<DN>,
Comparator<DN>,
Serializable {
    private static final RDN[] NO_RDNS = new RDN[0];
    public static final DN NULL_DN = new DN(new RDN[0]);
    private static final long serialVersionUID = -5272968942085729346L;
    private final RDN[] rdns;
    private final Schema schema;
    private final String dnString;
    private volatile String normalizedString;

    public DN(RDN ... rDNArray) {
        Validator.ensureNotNull(rDNArray);
        this.rdns = rDNArray;
        if (rDNArray.length == 0) {
            this.dnString = "";
            this.normalizedString = "";
            this.schema = null;
        } else {
            Schema schema = null;
            StringBuilder stringBuilder = new StringBuilder();
            for (RDN rDN : rDNArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                rDN.toString(stringBuilder, false);
                if (schema != null) continue;
                schema = rDN.getSchema();
            }
            this.dnString = stringBuilder.toString();
            this.schema = schema;
        }
    }

    public DN(List<RDN> list) {
        Validator.ensureNotNull(list);
        if (list.isEmpty()) {
            this.rdns = NO_RDNS;
            this.dnString = "";
            this.normalizedString = "";
            this.schema = null;
        } else {
            this.rdns = list.toArray(new RDN[list.size()]);
            Schema schema = null;
            StringBuilder stringBuilder = new StringBuilder();
            for (RDN rDN : this.rdns) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                rDN.toString(stringBuilder, false);
                if (schema != null) continue;
                schema = rDN.getSchema();
            }
            this.dnString = stringBuilder.toString();
            this.schema = schema;
        }
    }

    public DN(RDN rDN, DN dN) {
        Validator.ensureNotNull(rDN, dN);
        this.rdns = new RDN[dN.rdns.length + 1];
        this.rdns[0] = rDN;
        System.arraycopy(dN.rdns, 0, this.rdns, 1, dN.rdns.length);
        Schema schema = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (RDN rDN2 : this.rdns) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            rDN2.toString(stringBuilder, false);
            if (schema != null) continue;
            schema = rDN2.getSchema();
        }
        this.dnString = stringBuilder.toString();
        this.schema = schema;
    }

    public DN(String string) throws LDAPException {
        this(string, null);
    }

    public DN(String string, Schema schema) throws LDAPException {
        Validator.ensureNotNull(string);
        this.dnString = string;
        this.schema = schema;
        ArrayList<RDN> arrayList = new ArrayList<RDN>(5);
        int n = string.length();
        if (n == 0) {
            this.rdns = NO_RDNS;
            this.normalizedString = "";
            return;
        }
        int n2 = 0;
        boolean bl = false;
        block8: while (n2 < n) {
            ArrayList<String> arrayList2;
            int n3;
            ASN1OctetString aSN1OctetString;
            char c;
            while (n2 < n && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n) {
                if (arrayList.isEmpty()) break;
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_COMMA.get());
            }
            int n4 = n2;
            int n5 = n2;
            while (n2 < n && (c = string.charAt(n2)) != ' ' && c != '=') {
                if (c == ',' || c == ';') {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_COMMA.get(n2));
                }
                ++n2;
            }
            String string2 = string.substring(n5, n2);
            if (string2.length() == 0) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_ATTR_IN_RDN.get());
            }
            while (n2 < n && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n || string.charAt(n2) != '=') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_EQUAL_SIGN.get(string2));
            }
            ++n2;
            while (n2 < n && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n) {
                aSN1OctetString = new ASN1OctetString();
                n3 = n2;
            } else if (string.charAt(n2) == '#') {
                arrayList2 = (ArrayList<String>)RDN.readHexString(string, ++n2);
                aSN1OctetString = new ASN1OctetString((byte[])arrayList2);
                n3 = n2 += ((Object)arrayList2).length * 2;
            } else {
                arrayList2 = new StringBuilder();
                n2 = RDN.readValueString(string, n2, (StringBuilder)((Object)arrayList2));
                aSN1OctetString = new ASN1OctetString(((StringBuilder)((Object)arrayList2)).toString());
                n3 = n2;
            }
            while (n2 < n && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n) {
                arrayList.add(new RDN(string2, aSN1OctetString, schema, DN.getTrimmedRDN(string, n4, n3)));
                bl = false;
                break;
            }
            switch (string.charAt(n2)) {
                case '+': {
                    break;
                }
                case ',': 
                case ';': {
                    arrayList.add(new RDN(string2, aSN1OctetString, schema, DN.getTrimmedRDN(string, n4, n3)));
                    ++n2;
                    bl = true;
                    continue block8;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_CHAR.get(Character.valueOf(string.charAt(n2)), n2));
                }
            }
            if (++n2 >= n) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_PLUS.get());
            }
            arrayList2 = new ArrayList<String>(5);
            ArrayList<ASN1OctetString> arrayList3 = new ArrayList<ASN1OctetString>(5);
            arrayList2.add(string2);
            arrayList3.add(aSN1OctetString);
            block14: while (n2 < n) {
                ASN1OctetString[] aSN1OctetStringArray;
                char c2;
                while (n2 < n && string.charAt(n2) == ' ') {
                    ++n2;
                }
                if (n2 >= n) {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_PLUS.get());
                }
                n5 = n2;
                while (n2 < n && (c2 = string.charAt(n2)) != ' ' && c2 != '=') {
                    if (c2 == ',' || c2 == ';') {
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_COMMA.get(n2));
                    }
                    ++n2;
                }
                string2 = string.substring(n5, n2);
                if (string2.length() == 0) {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_ATTR_IN_RDN.get());
                }
                while (n2 < n && string.charAt(n2) == ' ') {
                    ++n2;
                }
                if (n2 >= n || string.charAt(n2) != '=') {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_NO_EQUAL_SIGN.get(string2));
                }
                ++n2;
                while (n2 < n && string.charAt(n2) == ' ') {
                    ++n2;
                }
                if (n2 >= n) {
                    aSN1OctetString = new ASN1OctetString();
                    n3 = n2;
                } else if (string.charAt(n2) == '#') {
                    byte[] byArray = RDN.readHexString(string, ++n2);
                    aSN1OctetString = new ASN1OctetString(byArray);
                    n3 = n2 += byArray.length * 2;
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    n2 = RDN.readValueString(string, n2, stringBuilder);
                    aSN1OctetString = new ASN1OctetString(stringBuilder.toString());
                    n3 = n2;
                }
                while (n2 < n && string.charAt(n2) == ' ') {
                    ++n2;
                }
                arrayList2.add(string2);
                arrayList3.add(aSN1OctetString);
                if (n2 >= n) {
                    String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
                    aSN1OctetStringArray = arrayList3.toArray(new ASN1OctetString[arrayList3.size()]);
                    arrayList.add(new RDN(stringArray, aSN1OctetStringArray, schema, DN.getTrimmedRDN(string, n4, n3)));
                    bl = false;
                    break block8;
                }
                switch (string.charAt(n2)) {
                    case '+': {
                        if (++n2 < n) continue block14;
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_PLUS.get());
                    }
                    case ',': 
                    case ';': {
                        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
                        aSN1OctetStringArray = arrayList3.toArray(new ASN1OctetString[arrayList3.size()]);
                        arrayList.add(new RDN(stringArray, aSN1OctetStringArray, schema, DN.getTrimmedRDN(string, n4, n3)));
                        ++n2;
                        bl = true;
                        continue block8;
                    }
                }
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_UNEXPECTED_CHAR.get(Character.valueOf(string.charAt(n2)), n2));
            }
        }
        if (bl) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_DN_ENDS_WITH_COMMA.get());
        }
        this.rdns = new RDN[arrayList.size()];
        arrayList.toArray(this.rdns);
    }

    private static String getTrimmedRDN(String string, int n, int n2) {
        String string2 = string.substring(n, n2);
        if (!string2.endsWith(" ")) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        while (stringBuilder.charAt(stringBuilder.length() - 1) == ' ' && stringBuilder.charAt(stringBuilder.length() - 2) != '\\') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidDN(String string) {
        try {
            new DN(string);
            return true;
        }
        catch (LDAPException lDAPException) {
            return false;
        }
    }

    public RDN getRDN() {
        if (this.rdns.length == 0) {
            return null;
        }
        return this.rdns[0];
    }

    public String getRDNString() {
        if (this.rdns.length == 0) {
            return null;
        }
        return this.rdns[0].toString();
    }

    public static String getRDNString(String string) throws LDAPException {
        return new DN(string).getRDNString();
    }

    public RDN[] getRDNs() {
        return this.rdns;
    }

    public static RDN[] getRDNs(String string) throws LDAPException {
        return new DN(string).getRDNs();
    }

    public String[] getRDNStrings() {
        String[] stringArray = new String[this.rdns.length];
        for (int i = 0; i < this.rdns.length; ++i) {
            stringArray[i] = this.rdns[i].toString();
        }
        return stringArray;
    }

    public static String[] getRDNStrings(String string) throws LDAPException {
        return new DN(string).getRDNStrings();
    }

    public boolean isNullDN() {
        return this.rdns.length == 0;
    }

    public DN getParent() {
        switch (this.rdns.length) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return new DN(this.rdns[1]);
            }
            case 3: {
                return new DN(this.rdns[1], this.rdns[2]);
            }
            case 4: {
                return new DN(this.rdns[1], this.rdns[2], this.rdns[3]);
            }
            case 5: {
                return new DN(this.rdns[1], this.rdns[2], this.rdns[3], this.rdns[4]);
            }
        }
        RDN[] rDNArray = new RDN[this.rdns.length - 1];
        System.arraycopy(this.rdns, 1, rDNArray, 0, rDNArray.length);
        return new DN(rDNArray);
    }

    public static DN getParent(String string) throws LDAPException {
        return new DN(string).getParent();
    }

    public String getParentString() {
        DN dN = this.getParent();
        if (dN == null) {
            return null;
        }
        return dN.toString();
    }

    public static String getParentString(String string) throws LDAPException {
        return new DN(string).getParentString();
    }

    public boolean isAncestorOf(DN dN, boolean bl) {
        int n = this.rdns.length - 1;
        int n2 = dN.rdns.length - 1;
        if (n < 0) {
            return bl || n2 >= 0;
        }
        if (n > n2 || n == n2 && !bl) {
            return false;
        }
        while (n >= 0) {
            if (this.rdns[n--].equals(dN.rdns[n2--])) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(String string, boolean bl) throws LDAPException {
        return this.isAncestorOf(new DN(string), bl);
    }

    public static boolean isAncestorOf(String string, String string2, boolean bl) throws LDAPException {
        return new DN(string).isAncestorOf(new DN(string2), bl);
    }

    public boolean isDescendantOf(DN dN, boolean bl) {
        int n = this.rdns.length - 1;
        int n2 = dN.rdns.length - 1;
        if (n2 < 0) {
            return bl || n >= 0;
        }
        if (n < n2 || n == n2 && !bl) {
            return false;
        }
        while (n2 >= 0) {
            if (this.rdns[n--].equals(dN.rdns[n2--])) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendantOf(String string, boolean bl) throws LDAPException {
        return this.isDescendantOf(new DN(string), bl);
    }

    public static boolean isDescendantOf(String string, String string2, boolean bl) throws LDAPException {
        return new DN(string).isDescendantOf(new DN(string2), bl);
    }

    public boolean matchesBaseAndScope(String string, SearchScope searchScope) throws LDAPException {
        return this.matchesBaseAndScope(new DN(string), searchScope);
    }

    public boolean matchesBaseAndScope(DN dN, SearchScope searchScope) throws LDAPException {
        Validator.ensureNotNull(dN, searchScope);
        switch (searchScope.intValue()) {
            case 0: {
                return this.equals(dN);
            }
            case 1: {
                return dN.equals(this.getParent());
            }
            case 2: {
                return this.isDescendantOf(dN, true);
            }
            case 3: {
                return this.isDescendantOf(dN, false);
            }
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_DN_MATCHES_UNSUPPORTED_SCOPE.get(this.dnString, String.valueOf(searchScope)));
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof DN)) {
            return false;
        }
        DN dN = (DN)object;
        return this.toNormalizedString().equals(dN.toNormalizedString());
    }

    public boolean equals(String string) throws LDAPException {
        if (string == null) {
            return false;
        }
        return this.equals(new DN(string));
    }

    public static boolean equals(String string, String string2) throws LDAPException {
        return new DN(string).equals(new DN(string2));
    }

    public String toString() {
        return this.dnString;
    }

    public String toMinimallyEncodedString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        this.toString(stringBuilder, false);
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        for (int i = 0; i < this.rdns.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            this.rdns[i].toString(stringBuilder, bl);
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toNormalizedString(stringBuilder);
            this.normalizedString = stringBuilder.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        for (int i = 0; i < this.rdns.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.rdns[i].toNormalizedString());
        }
    }

    public static String normalize(String string) throws LDAPException {
        return DN.normalize(string, null);
    }

    public static String normalize(String string, Schema schema) throws LDAPException {
        return new DN(string, schema).toNormalizedString();
    }

    @Override
    public int compareTo(DN dN) {
        return this.compare(this, dN);
    }

    @Override
    public int compare(DN dN, DN dN2) {
        int n;
        Validator.ensureNotNull(dN, dN2);
        int n2 = dN.rdns.length - 1;
        if (n2 < 0) {
            if (n < 0) {
                return 0;
            }
            return -1;
        }
        if (n < 0) {
            return 1;
        }
        for (n = dN2.rdns.length - 1; n2 >= 0 && n >= 0; --n2, --n) {
            int n3 = dN.rdns[n2].compareTo(dN2.rdns[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 < 0) {
            if (n < 0) {
                return 0;
            }
            return -1;
        }
        return 1;
    }

    public static int compare(String string, String string2) throws LDAPException {
        return DN.compare(string, string2, null);
    }

    public static int compare(String string, String string2, Schema schema) throws LDAPException {
        return new DN(string, schema).compareTo(new DN(string2, schema));
    }
}

