/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import java.io.Serializable;
import java.util.HashMap;

public final class DereferencePolicy
implements Serializable {
    public static final DereferencePolicy NEVER = new DereferencePolicy("NEVER", 0);
    public static final DereferencePolicy SEARCHING = new DereferencePolicy("SEARCHING", 1);
    public static final DereferencePolicy FINDING = new DereferencePolicy("FINDING", 2);
    public static final DereferencePolicy ALWAYS = new DereferencePolicy("ALWAYS", 3);
    private static final HashMap<Integer, DereferencePolicy> UNDEFINED_POLICIES = new HashMap();
    private static final long serialVersionUID = 3722883359911755096L;
    private final int intValue;
    private final String name;

    private DereferencePolicy(int n) {
        this.intValue = n;
        this.name = String.valueOf(n);
    }

    private DereferencePolicy(String string, int n) {
        this.name = string;
        this.intValue = n;
    }

    public String getName() {
        return this.name;
    }

    public int intValue() {
        return this.intValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DereferencePolicy valueOf(int n) {
        switch (n) {
            case 0: {
                return NEVER;
            }
            case 1: {
                return SEARCHING;
            }
            case 2: {
                return FINDING;
            }
            case 3: {
                return ALWAYS;
            }
        }
        HashMap<Integer, DereferencePolicy> hashMap = UNDEFINED_POLICIES;
        synchronized (hashMap) {
            DereferencePolicy dereferencePolicy = UNDEFINED_POLICIES.get(n);
            if (dereferencePolicy == null) {
                dereferencePolicy = new DereferencePolicy(n);
                UNDEFINED_POLICIES.put(n, dereferencePolicy);
            }
            return dereferencePolicy;
        }
    }

    public static DereferencePolicy definedValueOf(int n) {
        switch (n) {
            case 0: {
                return NEVER;
            }
            case 1: {
                return SEARCHING;
            }
            case 2: {
                return FINDING;
            }
            case 3: {
                return ALWAYS;
            }
        }
        return null;
    }

    public static DereferencePolicy[] values() {
        return new DereferencePolicy[]{NEVER, SEARCHING, FINDING, ALWAYS};
    }

    public int hashCode() {
        return this.intValue;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DereferencePolicy) {
            return this.intValue == ((DereferencePolicy)object).intValue;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

