/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedRequest
extends LDAPRequest
implements ResponseAcceptor,
ProtocolOp {
    protected static final byte TYPE_EXTENDED_REQUEST_OID = -128;
    protected static final byte TYPE_EXTENDED_REQUEST_VALUE = -127;
    private static final long serialVersionUID = 5572410770060685796L;
    private final ASN1OctetString value;
    private int messageID = -1;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private final String oid;

    public ExtendedRequest(String string) {
        super(null);
        Validator.ensureNotNull(string);
        this.oid = string;
        this.value = null;
    }

    public ExtendedRequest(String string, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string);
        this.oid = string;
        this.value = null;
    }

    public ExtendedRequest(String string, ASN1OctetString aSN1OctetString) {
        super(null);
        Validator.ensureNotNull(string);
        this.oid = string;
        this.value = aSN1OctetString;
    }

    public ExtendedRequest(String string, ASN1OctetString aSN1OctetString, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string);
        this.oid = string;
        this.value = aSN1OctetString;
    }

    protected ExtendedRequest(ExtendedRequest extendedRequest) {
        super(extendedRequest.getControls());
        this.oid = extendedRequest.oid;
        this.value = extendedRequest.value;
    }

    public final String getOID() {
        return this.oid;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    @Override
    public final byte getProtocolOpType() {
        return 119;
    }

    @Override
    public final void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)119);
        aSN1Buffer.addOctetString((byte)-128, this.oid);
        if (this.value != null) {
            aSN1Buffer.addOctetString((byte)-127, this.value.getValue());
        }
        aSN1BufferSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] aSN1ElementArray = this.value == null ? new ASN1Element[]{new ASN1OctetString(-128, this.oid)} : new ASN1Element[]{new ASN1OctetString(-128, this.oid), new ASN1OctetString(-127, this.value.getValue())};
        return new ASN1Sequence(119, aSN1ElementArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExtendedResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            return this.processSync(lDAPConnection);
        }
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        lDAPConnection.registerResponseAcceptor(this.messageID, this);
        try {
            LDAPResponse lDAPResponse;
            Debug.debugLDAPRequest(this);
            long l = System.nanoTime();
            lDAPConnection.getConnectionStatistics().incrementNumExtendedRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            try {
                long l2 = this.getResponseTimeoutMillis(lDAPConnection);
                lDAPResponse = l2 > 0L ? this.responseQueue.poll(l2, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXTOP_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
            }
            ExtendedResult extendedResult = this.handleResponse(lDAPConnection, lDAPResponse, l);
            return extendedResult;
        }
        finally {
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
        }
    }

    private ExtendedResult processSync(LDAPConnection lDAPConnection) throws LDAPException {
        LDAPResponse lDAPResponse;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(lDAPConnection));
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        long l = System.nanoTime();
        Debug.debugLDAPRequest(this);
        lDAPConnection.getConnectionStatistics().incrementNumExtendedRequests();
        lDAPConnection.sendMessage(lDAPMessage);
        while (true) {
            try {
                lDAPResponse = lDAPConnection.readResponse(this.messageID);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                if (lDAPException.getResultCode() == ResultCode.TIMEOUT && lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                    lDAPConnection.abandon(this.messageID, new Control[0]);
                }
                throw lDAPException;
            }
            if (!(lDAPResponse instanceof IntermediateResponse)) break;
            IntermediateResponseListener intermediateResponseListener = this.getIntermediateResponseListener();
            if (intermediateResponseListener == null) continue;
            intermediateResponseListener.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l);
    }

    private ExtendedResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l) throws LDAPException {
        if (lDAPResponse == null) {
            long l2 = StaticUtils.nanosToMillis(System.nanoTime() - l);
            if (lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                lDAPConnection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_EXTENDED_CLIENT_TIMEOUT.get(l2, this.messageID, this.oid, lDAPConnection.getHostPort()));
        }
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse connectionClosedResponse = (ConnectionClosedResponse)lDAPResponse;
            String string = connectionClosedResponse.getMessage();
            if (string == null) {
                throw new LDAPException(connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()));
            }
            throw new LDAPException(connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), string));
        }
        lDAPConnection.getConnectionStatistics().incrementNumExtendedResponses(System.nanoTime() - l);
        return (ExtendedResult)lDAPResponse;
    }

    @Override
    @InternalUseOnly
    public final void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public final int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.EXTENDED;
    }

    @Override
    public ExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public ExtendedRequest duplicate(Control[] controlArray) {
        ExtendedRequest extendedRequest = new ExtendedRequest(this.oid, this.value, controlArray);
        extendedRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return extendedRequest;
    }

    public String getExtendedRequestName() {
        return this.oid;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("ExtendedRequest(oid='");
        stringBuilder.append(this.oid);
        stringBuilder.append('\'');
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(3);
        arrayList.add(ToCodeArgHelper.createString(this.oid, "Request OID"));
        arrayList.add(ToCodeArgHelper.createASN1OctetString(this.value, "Request Value"));
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            arrayList.add(ToCodeArgHelper.createControlArray(controlArray, "Request Controls"));
        }
        ToCodeHelper.generateMethodCall(list, n, "ExtendedRequest", string + "Request", "new ExtendedRequest", arrayList);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string2 = stringBuilder.toString();
            list.add("");
            list.add(string2 + "try");
            list.add(string2 + '{');
            list.add(string2 + "  ExtendedResult " + string + "Result = connection.processExtendedOperation(" + string + "Request);");
            list.add(string2 + "  // The extended operation was processed and " + "we have a result.");
            list.add(string2 + "  // This does not necessarily mean that the " + "operation was successful.");
            list.add(string2 + "  // Examine the result details for more " + "information.");
            list.add(string2 + "  ResultCode resultCode = " + string + "Result.getResultCode();");
            list.add(string2 + "  String message = " + string + "Result.getMessage();");
            list.add(string2 + "  String matchedDN = " + string + "Result.getMatchedDN();");
            list.add(string2 + "  String[] referralURLs = " + string + "Result.getReferralURLs();");
            list.add(string2 + "  String responseOID = " + string + "Result.getOID();");
            list.add(string2 + "  ASN1OctetString responseValue = " + string + "Result.getValue();");
            list.add(string2 + "  Control[] responseControls = " + string + "Result.getResponseControls();");
            list.add(string2 + '}');
            list.add(string2 + "catch (LDAPException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // A problem was encountered while attempting " + "to process the extended operation.");
            list.add(string2 + "  // Maybe the following will help explain why.");
            list.add(string2 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string2 + "  String message = e.getMessage();");
            list.add(string2 + "  String matchedDN = e.getMatchedDN();");
            list.add(string2 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string2 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string2 + '}');
        }
    }
}

