/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;

public class ExtendedResult
extends LDAPResult {
    private static final byte TYPE_EXTENDED_RESPONSE_OID = -118;
    private static final byte TYPE_EXTENDED_RESPONSE_VALUE = -117;
    private static final long serialVersionUID = -6885923482396647963L;
    private final ASN1OctetString value;
    private final String oid;

    public ExtendedResult(int n, ResultCode resultCode, String string, String string2, String[] stringArray, String string3, ASN1OctetString aSN1OctetString, Control[] controlArray) {
        super(n, resultCode, string, string2, stringArray, controlArray);
        this.oid = string3;
        this.value = aSN1OctetString;
    }

    public ExtendedResult(LDAPResult lDAPResult) {
        super(lDAPResult);
        this.oid = null;
        this.value = null;
    }

    public ExtendedResult(LDAPException lDAPException) {
        this(lDAPException.toLDAPResult());
    }

    protected ExtendedResult(ExtendedResult extendedResult) {
        this(extendedResult.getMessageID(), extendedResult.getResultCode(), extendedResult.getDiagnosticMessage(), extendedResult.getMatchedDN(), extendedResult.getReferralURLs(), extendedResult.getOID(), extendedResult.getValue(), extendedResult.getResponseControls());
    }

    static ExtendedResult readExtendedResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ASN1StreamReaderSequence aSN1StreamReaderSequence2;
            ArrayList<Object> arrayList;
            String string;
            ASN1StreamReaderSequence aSN1StreamReaderSequence3 = aSN1StreamReader.beginSequence();
            ResultCode resultCode = ResultCode.valueOf(aSN1StreamReader.readEnumerated());
            String string2 = aSN1StreamReader.readString();
            if (string2.length() == 0) {
                string2 = null;
            }
            if ((string = aSN1StreamReader.readString()).length() == 0) {
                string = null;
            }
            String[] stringArray = null;
            String string3 = null;
            ASN1OctetString aSN1OctetString = null;
            block8: while (aSN1StreamReaderSequence3.hasMoreElements()) {
                byte by = (byte)aSN1StreamReader.peek();
                switch (by) {
                    case -93: {
                        arrayList = new ArrayList(1);
                        aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
                        while (aSN1StreamReaderSequence2.hasMoreElements()) {
                            arrayList.add(aSN1StreamReader.readString());
                        }
                        stringArray = new String[arrayList.size()];
                        arrayList.toArray(stringArray);
                        continue block8;
                    }
                    case -118: {
                        string3 = aSN1StreamReader.readString();
                        continue block8;
                    }
                    case -117: {
                        aSN1OctetString = new ASN1OctetString(by, aSN1StreamReader.readBytes());
                        continue block8;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_EXTENDED_RESULT_INVALID_ELEMENT.get(StaticUtils.toHex(by)));
            }
            Control[] controlArray = NO_CONTROLS;
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                arrayList = new ArrayList<Object>(1);
                aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence2.hasMoreElements()) {
                    arrayList.add(Control.readFrom(aSN1StreamReader));
                }
                controlArray = new Control[arrayList.size()];
                arrayList.toArray(controlArray);
            }
            return new ExtendedResult(n, resultCode, string, string2, stringArray, string3, aSN1OctetString, controlArray);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_EXTENDED_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public final String getOID() {
        return this.oid;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public String getExtendedResultName() {
        return this.oid;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        Control[] controlArray;
        String[] stringArray;
        String string;
        String string2;
        stringBuilder.append("ExtendedResult(resultCode=");
        stringBuilder.append(this.getResultCode());
        int n = this.getMessageID();
        if (n >= 0) {
            stringBuilder.append(", messageID=");
            stringBuilder.append(n);
        }
        if ((string2 = this.getDiagnosticMessage()) != null) {
            stringBuilder.append(", diagnosticMessage='");
            stringBuilder.append(string2);
            stringBuilder.append('\'');
        }
        if ((string = this.getMatchedDN()) != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(string);
            stringBuilder.append('\'');
        }
        if ((stringArray = this.getReferralURLs()).length > 0) {
            stringBuilder.append(", referralURLs={");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i]);
            }
            stringBuilder.append('}');
        }
        if (this.oid != null) {
            stringBuilder.append(", oid=");
            stringBuilder.append(this.oid);
        }
        if ((controlArray = this.getResponseControls()).length > 0) {
            stringBuilder.append(", responseControls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

