/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.Validator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FailoverServerSet
extends ServerSet {
    private final AtomicBoolean reOrderOnFailover;
    private volatile Long maxFailoverConnectionAge;
    private final ServerSet[] serverSets;

    public FailoverServerSet(String[] stringArray, int[] nArray) {
        this(stringArray, nArray, null, null);
    }

    public FailoverServerSet(String[] stringArray, int[] nArray, LDAPConnectionOptions lDAPConnectionOptions) {
        this(stringArray, nArray, null, lDAPConnectionOptions);
    }

    public FailoverServerSet(String[] stringArray, int[] nArray, SocketFactory socketFactory) {
        this(stringArray, nArray, socketFactory, null);
    }

    public FailoverServerSet(String[] stringArray, int[] nArray, SocketFactory socketFactory, LDAPConnectionOptions lDAPConnectionOptions) {
        Validator.ensureNotNull(stringArray, nArray);
        Validator.ensureTrue(stringArray.length > 0, "FailoverServerSet.addresses must not be empty.");
        Validator.ensureTrue(stringArray.length == nArray.length, "FailoverServerSet addresses and ports arrays must be the same size.");
        this.reOrderOnFailover = new AtomicBoolean(false);
        this.maxFailoverConnectionAge = null;
        SocketFactory socketFactory2 = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        LDAPConnectionOptions lDAPConnectionOptions2 = lDAPConnectionOptions == null ? new LDAPConnectionOptions() : lDAPConnectionOptions;
        this.serverSets = new ServerSet[stringArray.length];
        for (int i = 0; i < this.serverSets.length; ++i) {
            this.serverSets[i] = new SingleServerSet(stringArray[i], nArray[i], socketFactory2, lDAPConnectionOptions2);
        }
    }

    public FailoverServerSet(ServerSet ... serverSetArray) {
        Validator.ensureNotNull(serverSetArray);
        Validator.ensureFalse(serverSetArray.length == 0, "FailoverServerSet.serverSets must not be empty.");
        this.serverSets = serverSetArray;
        this.reOrderOnFailover = new AtomicBoolean(false);
        this.maxFailoverConnectionAge = null;
    }

    public FailoverServerSet(List<ServerSet> list) {
        Validator.ensureNotNull(list);
        Validator.ensureFalse(list.isEmpty(), "FailoverServerSet.serverSets must not be empty.");
        this.serverSets = new ServerSet[list.size()];
        list.toArray(this.serverSets);
        this.reOrderOnFailover = new AtomicBoolean(false);
        this.maxFailoverConnectionAge = null;
    }

    public ServerSet[] getServerSets() {
        return this.serverSets;
    }

    public boolean reOrderOnFailover() {
        return this.reOrderOnFailover.get();
    }

    public void setReOrderOnFailover(boolean bl) {
        this.reOrderOnFailover.set(bl);
    }

    public Long getMaxFailoverConnectionAgeMillis() {
        return this.maxFailoverConnectionAge;
    }

    public void setMaxFailoverConnectionAgeMillis(Long l) {
        this.maxFailoverConnectionAge = l == null ? null : (l > 0L ? l : Long.valueOf(0L));
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck lDAPConnectionPoolHealthCheck) throws LDAPException {
        if (this.reOrderOnFailover.get() && this.serverSets.length > 1) {
            FailoverServerSet failoverServerSet = this;
            synchronized (failoverServerSet) {
                try {
                    return this.serverSets[0].getConnection(lDAPConnectionPoolHealthCheck);
                }
                catch (LDAPException lDAPException) {
                    int n;
                    Debug.debugException(lDAPException);
                    int n2 = -1;
                    LDAPConnection lDAPConnection = null;
                    LDAPException lDAPException2 = null;
                    for (n = 1; n < this.serverSets.length; ++n) {
                        try {
                            lDAPConnection = this.serverSets[n].getConnection(lDAPConnectionPoolHealthCheck);
                            n2 = n;
                            break;
                        }
                        catch (LDAPException lDAPException3) {
                            Debug.debugException(lDAPException3);
                            lDAPException2 = lDAPException3;
                            continue;
                        }
                    }
                    if (n2 > 0) {
                        int n3;
                        n = 0;
                        ServerSet[] serverSetArray = new ServerSet[this.serverSets.length];
                        for (n3 = n2; n3 < this.serverSets.length; ++n3) {
                            serverSetArray[n++] = this.serverSets[n3];
                        }
                        for (n3 = 0; n3 < n2; ++n3) {
                            serverSetArray[n++] = this.serverSets[n3];
                        }
                        System.arraycopy(serverSetArray, 0, this.serverSets, 0, serverSetArray.length);
                        if (this.maxFailoverConnectionAge != null) {
                            lDAPConnection.setAttachment(LDAPConnectionPool.ATTACHMENT_NAME_MAX_CONNECTION_AGE, this.maxFailoverConnectionAge);
                        }
                        return lDAPConnection;
                    }
                    throw lDAPException2;
                }
            }
        }
        LDAPException lDAPException = null;
        boolean bl = true;
        for (ServerSet serverSet : this.serverSets) {
            try {
                LDAPConnection lDAPConnection = serverSet.getConnection(lDAPConnectionPoolHealthCheck);
                if (!bl && this.maxFailoverConnectionAge != null) {
                    lDAPConnection.setAttachment(LDAPConnectionPool.ATTACHMENT_NAME_MAX_CONNECTION_AGE, this.maxFailoverConnectionAge);
                }
                return lDAPConnection;
            }
            catch (LDAPException lDAPException4) {
                bl = false;
                Debug.debugException(lDAPException4);
                lDAPException = lDAPException4;
            }
        }
        throw lDAPException;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("FailoverServerSet(serverSets={");
        for (int i = 0; i < this.serverSets.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.serverSets[i].toString(stringBuilder);
        }
        stringBuilder.append("})");
    }
}

