/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1BufferSet;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.asn1.ASN1StreamReaderSet;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Filter
implements Serializable {
    public static final byte FILTER_TYPE_AND = -96;
    public static final byte FILTER_TYPE_OR = -95;
    public static final byte FILTER_TYPE_NOT = -94;
    public static final byte FILTER_TYPE_EQUALITY = -93;
    public static final byte FILTER_TYPE_SUBSTRING = -92;
    public static final byte FILTER_TYPE_GREATER_OR_EQUAL = -91;
    public static final byte FILTER_TYPE_LESS_OR_EQUAL = -90;
    public static final byte FILTER_TYPE_PRESENCE = -121;
    public static final byte FILTER_TYPE_APPROXIMATE_MATCH = -88;
    public static final byte FILTER_TYPE_EXTENSIBLE_MATCH = -87;
    private static final byte SUBSTRING_TYPE_SUBINITIAL = -128;
    private static final byte SUBSTRING_TYPE_SUBANY = -127;
    private static final byte SUBSTRING_TYPE_SUBFINAL = -126;
    private static final byte EXTENSIBLE_TYPE_MATCHING_RULE_ID = -127;
    private static final byte EXTENSIBLE_TYPE_ATTRIBUTE_NAME = -126;
    private static final byte EXTENSIBLE_TYPE_MATCH_VALUE = -125;
    private static final byte EXTENSIBLE_TYPE_DN_ATTRIBUTES = -124;
    private static final Filter[] NO_FILTERS = new Filter[0];
    private static final ASN1OctetString[] NO_SUB_ANY = new ASN1OctetString[0];
    private static final long serialVersionUID = -2734184402804691970L;
    private final ASN1OctetString assertionValue;
    private final ASN1OctetString subFinal;
    private final ASN1OctetString subInitial;
    private final ASN1OctetString[] subAny;
    private final boolean dnAttributes;
    private final Filter notComp;
    private final Filter[] filterComps;
    private final byte filterType;
    private final String attrName;
    private volatile String filterString;
    private final String matchingRuleID;
    private volatile String normalizedString;

    private Filter(String string, byte by, Filter[] filterArray, Filter filter, String string2, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString[] aSN1OctetStringArray, ASN1OctetString aSN1OctetString3, String string3, boolean bl) {
        this.filterString = string;
        this.filterType = by;
        this.filterComps = filterArray;
        this.notComp = filter;
        this.attrName = string2;
        this.assertionValue = aSN1OctetString;
        this.subInitial = aSN1OctetString2;
        this.subAny = aSN1OctetStringArray;
        this.subFinal = aSN1OctetString3;
        this.matchingRuleID = string3;
        this.dnAttributes = bl;
    }

    public static Filter createANDFilter(Filter ... filterArray) {
        Validator.ensureNotNull(filterArray);
        return new Filter(null, -96, filterArray, null, null, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createANDFilter(List<Filter> list) {
        Validator.ensureNotNull(list);
        return new Filter(null, -96, list.toArray(new Filter[list.size()]), null, null, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createANDFilter(Collection<Filter> collection) {
        Validator.ensureNotNull(collection);
        return new Filter(null, -96, collection.toArray(new Filter[collection.size()]), null, null, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createORFilter(Filter ... filterArray) {
        Validator.ensureNotNull(filterArray);
        return new Filter(null, -95, filterArray, null, null, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createORFilter(List<Filter> list) {
        Validator.ensureNotNull(list);
        return new Filter(null, -95, list.toArray(new Filter[list.size()]), null, null, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createORFilter(Collection<Filter> collection) {
        Validator.ensureNotNull(collection);
        return new Filter(null, -95, collection.toArray(new Filter[collection.size()]), null, null, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createNOTFilter(Filter filter) {
        Validator.ensureNotNull(filter);
        return new Filter(null, -94, NO_FILTERS, filter, null, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createEqualityFilter(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        return new Filter(null, -93, NO_FILTERS, null, string, new ASN1OctetString(string2), null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createEqualityFilter(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        return new Filter(null, -93, NO_FILTERS, null, string, new ASN1OctetString(byArray), null, NO_SUB_ANY, null, null, false);
    }

    static Filter createEqualityFilter(String string, ASN1OctetString aSN1OctetString) {
        Validator.ensureNotNull(string, aSN1OctetString);
        return new Filter(null, -93, NO_FILTERS, null, string, aSN1OctetString, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createSubstringFilter(String string, String string2, String[] stringArray, String string3) {
        ASN1OctetString[] aSN1OctetStringArray;
        Validator.ensureNotNull(string);
        Validator.ensureTrue(string2 != null || stringArray != null && stringArray.length > 0 || string3 != null);
        ASN1OctetString aSN1OctetString = string2 == null ? null : new ASN1OctetString(string2);
        if (stringArray == null) {
            aSN1OctetStringArray = NO_SUB_ANY;
        } else {
            aSN1OctetStringArray = new ASN1OctetString[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                aSN1OctetStringArray[i] = new ASN1OctetString(stringArray[i]);
            }
        }
        ASN1OctetString aSN1OctetString2 = string3 == null ? null : new ASN1OctetString(string3);
        return new Filter(null, -92, NO_FILTERS, null, string, null, aSN1OctetString, aSN1OctetStringArray, aSN1OctetString2, null, false);
    }

    public static Filter createSubstringFilter(String string, byte[] byArray, byte[][] byArray2, byte[] byArray3) {
        ASN1OctetString[] aSN1OctetStringArray;
        Validator.ensureNotNull(string);
        Validator.ensureTrue(byArray != null || byArray2 != null && byArray2.length > 0 || byArray3 != null);
        ASN1OctetString aSN1OctetString = byArray == null ? null : new ASN1OctetString(byArray);
        if (byArray2 == null) {
            aSN1OctetStringArray = NO_SUB_ANY;
        } else {
            aSN1OctetStringArray = new ASN1OctetString[byArray2.length];
            for (int i = 0; i < byArray2.length; ++i) {
                aSN1OctetStringArray[i] = new ASN1OctetString(byArray2[i]);
            }
        }
        ASN1OctetString aSN1OctetString2 = byArray3 == null ? null : new ASN1OctetString(byArray3);
        return new Filter(null, -92, NO_FILTERS, null, string, null, aSN1OctetString, aSN1OctetStringArray, aSN1OctetString2, null, false);
    }

    static Filter createSubstringFilter(String string, ASN1OctetString aSN1OctetString, ASN1OctetString[] aSN1OctetStringArray, ASN1OctetString aSN1OctetString2) {
        Validator.ensureNotNull(string);
        Validator.ensureTrue(aSN1OctetString != null || aSN1OctetStringArray != null && aSN1OctetStringArray.length > 0 || aSN1OctetString2 != null);
        if (aSN1OctetStringArray == null) {
            return new Filter(null, -92, NO_FILTERS, null, string, null, aSN1OctetString, NO_SUB_ANY, aSN1OctetString2, null, false);
        }
        return new Filter(null, -92, NO_FILTERS, null, string, null, aSN1OctetString, aSN1OctetStringArray, aSN1OctetString2, null, false);
    }

    public static Filter createGreaterOrEqualFilter(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        return new Filter(null, -91, NO_FILTERS, null, string, new ASN1OctetString(string2), null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createGreaterOrEqualFilter(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        return new Filter(null, -91, NO_FILTERS, null, string, new ASN1OctetString(byArray), null, NO_SUB_ANY, null, null, false);
    }

    static Filter createGreaterOrEqualFilter(String string, ASN1OctetString aSN1OctetString) {
        Validator.ensureNotNull(string, aSN1OctetString);
        return new Filter(null, -91, NO_FILTERS, null, string, aSN1OctetString, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createLessOrEqualFilter(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        return new Filter(null, -90, NO_FILTERS, null, string, new ASN1OctetString(string2), null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createLessOrEqualFilter(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        return new Filter(null, -90, NO_FILTERS, null, string, new ASN1OctetString(byArray), null, NO_SUB_ANY, null, null, false);
    }

    static Filter createLessOrEqualFilter(String string, ASN1OctetString aSN1OctetString) {
        Validator.ensureNotNull(string, aSN1OctetString);
        return new Filter(null, -90, NO_FILTERS, null, string, aSN1OctetString, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createPresenceFilter(String string) {
        Validator.ensureNotNull(string);
        return new Filter(null, -121, NO_FILTERS, null, string, null, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createApproximateMatchFilter(String string, String string2) {
        Validator.ensureNotNull(string, string2);
        return new Filter(null, -88, NO_FILTERS, null, string, new ASN1OctetString(string2), null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createApproximateMatchFilter(String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        return new Filter(null, -88, NO_FILTERS, null, string, new ASN1OctetString(byArray), null, NO_SUB_ANY, null, null, false);
    }

    static Filter createApproximateMatchFilter(String string, ASN1OctetString aSN1OctetString) {
        Validator.ensureNotNull(string, aSN1OctetString);
        return new Filter(null, -88, NO_FILTERS, null, string, aSN1OctetString, null, NO_SUB_ANY, null, null, false);
    }

    public static Filter createExtensibleMatchFilter(String string, String string2, boolean bl, String string3) {
        Validator.ensureNotNull(string3);
        Validator.ensureFalse(string == null && string2 == null);
        return new Filter(null, -87, NO_FILTERS, null, string, new ASN1OctetString(string3), null, NO_SUB_ANY, null, string2, bl);
    }

    public static Filter createExtensibleMatchFilter(String string, String string2, boolean bl, byte[] byArray) {
        Validator.ensureNotNull(byArray);
        Validator.ensureFalse(string == null && string2 == null);
        return new Filter(null, -87, NO_FILTERS, null, string, new ASN1OctetString(byArray), null, NO_SUB_ANY, null, string2, bl);
    }

    static Filter createExtensibleMatchFilter(String string, String string2, boolean bl, ASN1OctetString aSN1OctetString) {
        Validator.ensureNotNull(aSN1OctetString);
        Validator.ensureFalse(string == null && string2 == null);
        return new Filter(null, -87, NO_FILTERS, null, string, aSN1OctetString, null, NO_SUB_ANY, null, string2, bl);
    }

    public static Filter create(String string) throws LDAPException {
        Validator.ensureNotNull(string);
        return Filter.create(string, 0, string.length() - 1, 0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Filter create(String string, int n, int n2, int n3) throws LDAPException {
        void var8_22;
        boolean bl;
        String string2;
        Object object;
        ASN1OctetString[] aSN1OctetStringArray;
        ASN1OctetString aSN1OctetString;
        String string3;
        Filter filter;
        Filter[] filterArray;
        int n4;
        if (n3 > 50) {
            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_TOO_DEEP.get());
        }
        if (n >= n2) {
            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_TOO_SHORT.get());
        }
        int n5 = n;
        int n6 = n2;
        if (string.charAt(n5) == '(') {
            if (string.charAt(n6) != ')') throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_OPEN_WITHOUT_CLOSE.get(n5, n6));
            ++n5;
            --n6;
        } else if (n5 != 0) {
            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_MISSING_PARENTHESES.get(string.substring(n5, n6 + 1)));
        }
        switch (string.charAt(n5)) {
            case '&': {
                n4 = -96;
                filterArray = Filter.parseFilterComps(string, n5 + 1, n6, n3 + 1);
                filter = null;
                string3 = null;
                Object var8_10 = null;
                aSN1OctetString = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                object = null;
                string2 = null;
                bl = false;
                break;
            }
            case '|': {
                n4 = -95;
                filterArray = Filter.parseFilterComps(string, n5 + 1, n6, n3 + 1);
                filter = null;
                string3 = null;
                Object var8_11 = null;
                aSN1OctetString = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                object = null;
                string2 = null;
                bl = false;
                break;
            }
            case '!': {
                n4 = -94;
                filterArray = NO_FILTERS;
                filter = Filter.create(string, n5 + 1, n6, n3 + 1);
                string3 = null;
                Object var8_12 = null;
                aSN1OctetString = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                object = null;
                string2 = null;
                bl = false;
                break;
            }
            case '(': {
                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_OPEN_PAREN.get(n5));
            }
            case ':': {
                String string4;
                n4 = -87;
                filterArray = NO_FILTERS;
                filter = null;
                string3 = null;
                aSN1OctetString = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                object = null;
                int n7 = ++n5;
                while (n5 <= n6 && string.charAt(n5) != ':') {
                    ++n5;
                }
                if (n5 > n6) {
                    throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_NO_COLON_AFTER_MRID.get(n));
                }
                if (n5 == n7) {
                    throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_EMPTY_MRID.get(n));
                }
                if ((string4 = string.substring(n7, n5++)).equalsIgnoreCase("dn")) {
                    bl = true;
                    int n8 = n5;
                    while (n5 < n6 && string.charAt(n5) != ':') {
                        ++n5;
                    }
                    if (n5 >= n6) {
                        throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_NO_COLON_AFTER_MRID.get(n));
                    }
                    string2 = string.substring(n8, n5);
                    if (string2.length() == 0) {
                        throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_EMPTY_MRID.get(n));
                    }
                    if (++n5 > n6 || string.charAt(n5) != '=') {
                        throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CHAR_AFTER_MRID.get(Character.valueOf(string.charAt(n5)), n));
                    }
                } else {
                    string2 = string4;
                    bl = false;
                    if (n5 > n6 || string.charAt(n5) != '=') {
                        throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_NO_EQUAL_AFTER_MRID.get(n));
                    }
                }
                ByteStringBuffer byteStringBuffer = new ByteStringBuffer(n6 - ++n5 + 1);
                while (n5 <= n6) {
                    char c = string.charAt(n5);
                    if (c == '\\') {
                        ++n5;
                        n5 = Filter.readEscapedHexString(string, n5, byteStringBuffer);
                        continue;
                    }
                    if (c == '(') {
                        throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_OPEN_PAREN.get(n5));
                    }
                    if (c == ')') {
                        throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CLOSE_PAREN.get(n5));
                    }
                    byteStringBuffer.append(c);
                    ++n5;
                }
                ASN1OctetString aSN1OctetString2 = new ASN1OctetString(byteStringBuffer.toByteArray());
                break;
            }
            default: {
                Object object2;
                Object object3;
                int n9;
                filterArray = NO_FILTERS;
                filter = null;
                int n10 = n5;
                int n11 = -1;
                int n12 = 0;
                boolean bl2 = false;
                boolean bl3 = false;
                block30: while (n5 <= n6) {
                    n9 = string.charAt(n5++);
                    switch (n9) {
                        case 58: {
                            n12 = -87;
                            bl2 = true;
                            n11 = n5 - 1;
                            break block30;
                        }
                        case 62: {
                            n12 = -91;
                            bl2 = true;
                            n11 = n5 - 1;
                            if (n5 > n6) throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_END_AFTER_GT.get(n));
                            if (string.charAt(n5++) == '=') break block30;
                            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CHAR_AFTER_GT.get(n, Character.valueOf(string.charAt(n5 - 1))));
                        }
                        case 60: {
                            n12 = -90;
                            bl2 = true;
                            n11 = n5 - 1;
                            if (n5 > n6) throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_END_AFTER_LT.get(n));
                            if (string.charAt(n5++) == '=') break block30;
                            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CHAR_AFTER_LT.get(n, Character.valueOf(string.charAt(n5 - 1))));
                        }
                        case 126: {
                            n12 = -88;
                            bl2 = true;
                            n11 = n5 - 1;
                            if (n5 > n6) throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_END_AFTER_TILDE.get(n));
                            if (string.charAt(n5++) == '=') break block30;
                            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CHAR_AFTER_TILDE.get(n, Character.valueOf(string.charAt(n5 - 1))));
                        }
                        case 61: {
                            n11 = n5 - 1;
                            bl3 = true;
                            break block30;
                        }
                        default: {
                            continue block30;
                        }
                    }
                }
                if (n11 <= n10) {
                    if (!bl3) throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_NO_EQUAL_SIGN.get(n));
                    throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_EMPTY_ATTR_NAME.get(n));
                }
                string3 = string.substring(n10, n11);
                if (bl2 && n12 == -87) {
                    if (n5 > n6) {
                        throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_NO_EQUALS.get(n));
                    }
                    if ((n9 = string.charAt(n5++)) == 61) {
                        string2 = null;
                        bl = false;
                    } else {
                        bl3 = false;
                        int n13 = n5 - 1;
                        while (n5 <= n6) {
                            if (string.charAt(n5++) != '=') continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) {
                            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_NO_EQUALS.get(n));
                        }
                        object3 = string.substring(n13, n5 - 1);
                        object2 = StaticUtils.toLowerCase((String)object3);
                        if (!((String)object3).endsWith(":")) {
                            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_CANNOT_PARSE_MRID.get(n));
                        }
                        if (((String)object2).equals("dn:")) {
                            string2 = null;
                            bl = true;
                        } else if (((String)object2).startsWith("dn:")) {
                            string2 = ((String)object3).substring(3, ((String)object3).length() - 1);
                            if (string2.length() == 0) {
                                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_EMPTY_MRID.get(n));
                            }
                            bl = true;
                        } else {
                            string2 = ((String)object3).substring(0, ((String)object3).length() - 1);
                            bl = false;
                            if (string2.length() == 0) {
                                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_EMPTY_MRID.get(n));
                            }
                        }
                    }
                } else {
                    string2 = null;
                    bl = false;
                }
                if (n5 > n6) {
                    ASN1OctetString aSN1OctetString3 = new ASN1OctetString();
                    if (!bl2) {
                        n12 = -93;
                    }
                    aSN1OctetString = null;
                    aSN1OctetStringArray = NO_SUB_ANY;
                    object = null;
                } else if (n5 == n6) {
                    if (bl2) {
                        switch (string.charAt(n5)) {
                            case '(': 
                            case ')': 
                            case '*': 
                            case '\\': {
                                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CHAR_IN_AV.get(Character.valueOf(string.charAt(n5)), n));
                            }
                        }
                        ASN1OctetString aSN1OctetString4 = new ASN1OctetString(string.substring(n5, n5 + 1));
                    } else {
                        n9 = string.charAt(n5);
                        switch (n9) {
                            case 42: {
                                n12 = -121;
                                Object var8_16 = null;
                                break;
                            }
                            case 40: 
                            case 41: 
                            case 92: {
                                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CHAR_IN_AV.get(Character.valueOf(string.charAt(n5)), n));
                            }
                            default: {
                                n12 = -93;
                                ASN1OctetString aSN1OctetString5 = new ASN1OctetString(string.substring(n5, n5 + 1));
                            }
                        }
                    }
                    aSN1OctetString = null;
                    aSN1OctetStringArray = NO_SUB_ANY;
                    object = null;
                } else {
                    if (!bl2) {
                        n12 = -93;
                    }
                    n9 = n5;
                    ASN1OctetString aSN1OctetString6 = null;
                    object3 = null;
                    object2 = new ArrayList(1);
                    ByteStringBuffer byteStringBuffer = new ByteStringBuffer(n6 - n5 + 1);
                    block32: while (n5 <= n6) {
                        char c = string.charAt(n5++);
                        switch (c) {
                            case '*': {
                                if (bl2) {
                                    throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_ASTERISK.get(n));
                                }
                                if (n5 - 1 != n9) {
                                    if (n12 == -92) {
                                        if (byteStringBuffer.length() == 0) {
                                            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_DOUBLE_ASTERISK.get(n));
                                        }
                                        ((ArrayList)object2).add(new ASN1OctetString(byteStringBuffer.toByteArray()));
                                        byteStringBuffer = new ByteStringBuffer(n6 - n5 + 1);
                                    } else {
                                        aSN1OctetString6 = new ASN1OctetString(byteStringBuffer.toByteArray());
                                        byteStringBuffer = new ByteStringBuffer(n6 - n5 + 1);
                                    }
                                }
                                n12 = -92;
                                continue block32;
                            }
                            case '\\': {
                                n5 = Filter.readEscapedHexString(string, n5, byteStringBuffer);
                                continue block32;
                            }
                            case '(': {
                                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_OPEN_PAREN.get(n5));
                            }
                            case ')': {
                                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_UNEXPECTED_CLOSE_PAREN.get(n5));
                            }
                        }
                        byteStringBuffer.append(c);
                    }
                    if (n12 == -92 && byteStringBuffer.length() > 0) {
                        object3 = new ASN1OctetString(byteStringBuffer.toByteArray());
                    }
                    aSN1OctetString = aSN1OctetString6;
                    aSN1OctetStringArray = ((ArrayList)object2).toArray(new ASN1OctetString[((ArrayList)object2).size()]);
                    object = object3;
                    if (n12 == -92) {
                        Object var8_19 = null;
                    } else {
                        ASN1OctetString aSN1OctetString7 = new ASN1OctetString(byteStringBuffer.toByteArray());
                    }
                }
                n4 = n12;
            }
        }
        if (n != 0) return new Filter(string.substring(n, n2 + 1), (byte)n4, filterArray, filter, string3, (ASN1OctetString)var8_22, aSN1OctetString, aSN1OctetStringArray, (ASN1OctetString)object, string2, bl);
        return new Filter(string, (byte)n4, filterArray, filter, string3, (ASN1OctetString)var8_22, aSN1OctetString, aSN1OctetStringArray, (ASN1OctetString)object, string2, bl);
    }

    private static Filter[] parseFilterComps(String string, int n, int n2, int n3) throws LDAPException {
        if (n > n2) {
            return NO_FILTERS;
        }
        if (string.charAt(n) != '(') {
            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_EXPECTED_OPEN_PAREN.get(n));
        }
        if (string.charAt(n2) != ')') {
            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_EXPECTED_CLOSE_PAREN.get(n));
        }
        ArrayList<Filter> arrayList = new ArrayList<Filter>(5);
        int n4 = n;
        int n5 = n;
        int n6 = 0;
        while (n5 <= n2) {
            char c;
            if ((c = string.charAt(n5++)) == '(') {
                ++n6;
                continue;
            }
            if (c != ')' || --n6 != 0) continue;
            arrayList.add(Filter.create(string, n4, n5 - 1, n3));
            n4 = n5;
        }
        if (n6 != 0) {
            throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_MISMATCHED_PARENS.get(n, n2));
        }
        return arrayList.toArray(new Filter[arrayList.size()]);
    }

    private static int readEscapedHexString(String string, int n, ByteStringBuffer byteStringBuffer) throws LDAPException {
        byte by;
        switch (string.charAt(n)) {
            case '0': {
                by = 0;
                break;
            }
            case '1': {
                by = 16;
                break;
            }
            case '2': {
                by = 32;
                break;
            }
            case '3': {
                by = 48;
                break;
            }
            case '4': {
                by = 64;
                break;
            }
            case '5': {
                by = 80;
                break;
            }
            case '6': {
                by = 96;
                break;
            }
            case '7': {
                by = 112;
                break;
            }
            case '8': {
                by = -128;
                break;
            }
            case '9': {
                by = -112;
                break;
            }
            case 'A': 
            case 'a': {
                by = -96;
                break;
            }
            case 'B': 
            case 'b': {
                by = -80;
                break;
            }
            case 'C': 
            case 'c': {
                by = -64;
                break;
            }
            case 'D': 
            case 'd': {
                by = -48;
                break;
            }
            case 'E': 
            case 'e': {
                by = -32;
                break;
            }
            case 'F': 
            case 'f': {
                by = -16;
                break;
            }
            default: {
                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n)), n));
            }
        }
        switch (string.charAt(n + 1)) {
            case '0': {
                break;
            }
            case '1': {
                by = (byte)(by | 1);
                break;
            }
            case '2': {
                by = (byte)(by | 2);
                break;
            }
            case '3': {
                by = (byte)(by | 3);
                break;
            }
            case '4': {
                by = (byte)(by | 4);
                break;
            }
            case '5': {
                by = (byte)(by | 5);
                break;
            }
            case '6': {
                by = (byte)(by | 6);
                break;
            }
            case '7': {
                by = (byte)(by | 7);
                break;
            }
            case '8': {
                by = (byte)(by | 8);
                break;
            }
            case '9': {
                by = (byte)(by | 9);
                break;
            }
            case 'A': 
            case 'a': {
                by = (byte)(by | 0xA);
                break;
            }
            case 'B': 
            case 'b': {
                by = (byte)(by | 0xB);
                break;
            }
            case 'C': 
            case 'c': {
                by = (byte)(by | 0xC);
                break;
            }
            case 'D': 
            case 'd': {
                by = (byte)(by | 0xD);
                break;
            }
            case 'E': 
            case 'e': {
                by = (byte)(by | 0xE);
                break;
            }
            case 'F': 
            case 'f': {
                by = (byte)(by | 0xF);
                break;
            }
            default: {
                throw new LDAPException(ResultCode.FILTER_ERROR, LDAPMessages.ERR_FILTER_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n + 1)), n + 1));
            }
        }
        byteStringBuffer.append(by);
        return n + 2;
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        switch (this.filterType) {
            case -96: 
            case -95: {
                ASN1BufferSet aSN1BufferSet = aSN1Buffer.beginSet(this.filterType);
                for (Filter filter : this.filterComps) {
                    filter.writeTo(aSN1Buffer);
                }
                aSN1BufferSet.end();
                break;
            }
            case -94: {
                aSN1Buffer.addElement(new ASN1Element(this.filterType, this.notComp.encode().encode()));
                break;
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence(this.filterType);
                aSN1Buffer.addOctetString(this.attrName);
                aSN1Buffer.addElement(this.assertionValue);
                aSN1BufferSequence.end();
                break;
            }
            case -92: {
                ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence(this.filterType);
                aSN1Buffer.addOctetString(this.attrName);
                ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
                if (this.subInitial != null) {
                    aSN1Buffer.addOctetString((byte)-128, this.subInitial.getValue());
                }
                for (ASN1OctetString aSN1OctetString : this.subAny) {
                    aSN1Buffer.addOctetString((byte)-127, aSN1OctetString.getValue());
                }
                if (this.subFinal != null) {
                    aSN1Buffer.addOctetString((byte)-126, this.subFinal.getValue());
                }
                aSN1BufferSequence2.end();
                aSN1BufferSequence.end();
                break;
            }
            case -121: {
                aSN1Buffer.addOctetString(this.filterType, this.attrName);
                break;
            }
            case -87: {
                ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence(this.filterType);
                if (this.matchingRuleID != null) {
                    aSN1Buffer.addOctetString((byte)-127, this.matchingRuleID);
                }
                if (this.attrName != null) {
                    aSN1Buffer.addOctetString((byte)-126, this.attrName);
                }
                aSN1Buffer.addOctetString((byte)-125, this.assertionValue.getValue());
                if (this.dnAttributes) {
                    aSN1Buffer.addBoolean((byte)-124, true);
                }
                aSN1BufferSequence.end();
            }
        }
    }

    public ASN1Element encode() {
        switch (this.filterType) {
            case -96: 
            case -95: {
                ASN1Element[] aSN1ElementArray = new ASN1Element[this.filterComps.length];
                for (int i = 0; i < this.filterComps.length; ++i) {
                    aSN1ElementArray[i] = this.filterComps[i].encode();
                }
                return new ASN1Set(this.filterType, aSN1ElementArray);
            }
            case -94: {
                return new ASN1Element(this.filterType, this.notComp.encode().encode());
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                ASN1Element[] aSN1ElementArray = new ASN1OctetString[]{new ASN1OctetString(this.attrName), this.assertionValue};
                return new ASN1Sequence(this.filterType, aSN1ElementArray);
            }
            case -92: {
                ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(2 + this.subAny.length);
                if (this.subInitial != null) {
                    arrayList.add(new ASN1OctetString(-128, this.subInitial.getValue()));
                }
                for (ASN1OctetString aSN1OctetString : this.subAny) {
                    arrayList.add(new ASN1OctetString(-127, ((ASN1Element)aSN1OctetString).getValue()));
                }
                if (this.subFinal != null) {
                    arrayList.add(new ASN1OctetString(-126, this.subFinal.getValue()));
                }
                ASN1Element[] aSN1ElementArray = new ASN1Element[]{new ASN1OctetString(this.attrName), new ASN1Sequence(arrayList)};
                return new ASN1Sequence(this.filterType, aSN1ElementArray);
            }
            case -121: {
                return new ASN1OctetString(this.filterType, this.attrName);
            }
            case -87: {
                ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(4);
                if (this.matchingRuleID != null) {
                    arrayList.add(new ASN1OctetString(-127, this.matchingRuleID));
                }
                if (this.attrName != null) {
                    arrayList.add(new ASN1OctetString(-126, this.attrName));
                }
                arrayList.add(new ASN1OctetString(-125, this.assertionValue.getValue()));
                if (this.dnAttributes) {
                    arrayList.add(new ASN1Boolean(-124, true));
                }
                return new ASN1Sequence(this.filterType, arrayList);
            }
        }
        throw new AssertionError((Object)LDAPMessages.ERR_FILTER_INVALID_TYPE.get(StaticUtils.toHex(this.filterType)));
    }

    public static Filter readFrom(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            boolean bl;
            String string;
            ASN1OctetString aSN1OctetString;
            ASN1OctetString[] aSN1OctetStringArray;
            ASN1OctetString aSN1OctetString2;
            ASN1OctetString aSN1OctetString3;
            String string2;
            Filter filter;
            Filter[] filterArray;
            byte by = (byte)aSN1StreamReader.peek();
            switch (by) {
                case -96: 
                case -95: {
                    ArrayList<Filter> arrayList = new ArrayList<Filter>(5);
                    ASN1StreamReaderSet aSN1StreamReaderSet = aSN1StreamReader.beginSet();
                    while (aSN1StreamReaderSet.hasMoreElements()) {
                        arrayList.add(Filter.readFrom(aSN1StreamReader));
                    }
                    filterArray = new Filter[arrayList.size()];
                    arrayList.toArray(filterArray);
                    filter = null;
                    string2 = null;
                    aSN1OctetString3 = null;
                    aSN1OctetString2 = null;
                    aSN1OctetStringArray = NO_SUB_ANY;
                    aSN1OctetString = null;
                    string = null;
                    bl = false;
                    break;
                }
                case -94: {
                    ASN1Element aSN1Element;
                    try {
                        ASN1Element aSN1Element2 = aSN1StreamReader.readElement();
                        aSN1Element = ASN1Element.decode(aSN1Element2.getValue());
                    }
                    catch (ASN1Exception aSN1Exception) {
                        Debug.debugException(aSN1Exception);
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE_NOT_COMP.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                    }
                    filter = Filter.decode(aSN1Element);
                    filterArray = NO_FILTERS;
                    string2 = null;
                    aSN1OctetString3 = null;
                    aSN1OctetString2 = null;
                    aSN1OctetStringArray = NO_SUB_ANY;
                    aSN1OctetString = null;
                    string = null;
                    bl = false;
                    break;
                }
                case -93: 
                case -91: 
                case -90: 
                case -88: {
                    aSN1StreamReader.beginSequence();
                    string2 = aSN1StreamReader.readString();
                    aSN1OctetString3 = new ASN1OctetString(aSN1StreamReader.readBytes());
                    filterArray = NO_FILTERS;
                    filter = null;
                    aSN1OctetString2 = null;
                    aSN1OctetStringArray = NO_SUB_ANY;
                    aSN1OctetString = null;
                    string = null;
                    bl = false;
                    break;
                }
                case -92: {
                    aSN1StreamReader.beginSequence();
                    string2 = aSN1StreamReader.readString();
                    ASN1OctetString aSN1OctetString4 = null;
                    ASN1OctetString aSN1OctetString5 = null;
                    ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(1);
                    ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
                    block25: while (aSN1StreamReaderSequence.hasMoreElements()) {
                        byte by2 = (byte)aSN1StreamReader.peek();
                        ASN1OctetString aSN1OctetString6 = new ASN1OctetString(by2, aSN1StreamReader.readBytes());
                        switch (by2) {
                            case -128: {
                                aSN1OctetString4 = aSN1OctetString6;
                                continue block25;
                            }
                            case -127: {
                                arrayList.add(aSN1OctetString6);
                                continue block25;
                            }
                            case -126: {
                                aSN1OctetString5 = aSN1OctetString6;
                                continue block25;
                            }
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_INVALID_SUBSTR_TYPE.get(StaticUtils.toHex(by2)));
                    }
                    aSN1OctetString2 = aSN1OctetString4;
                    aSN1OctetString = aSN1OctetString5;
                    aSN1OctetStringArray = new ASN1OctetString[arrayList.size()];
                    arrayList.toArray(aSN1OctetStringArray);
                    filterArray = NO_FILTERS;
                    filter = null;
                    aSN1OctetString3 = null;
                    string = null;
                    bl = false;
                    break;
                }
                case -121: {
                    string2 = aSN1StreamReader.readString();
                    filterArray = NO_FILTERS;
                    filter = null;
                    aSN1OctetString3 = null;
                    aSN1OctetString2 = null;
                    aSN1OctetStringArray = NO_SUB_ANY;
                    aSN1OctetString = null;
                    string = null;
                    bl = false;
                    break;
                }
                case -87: {
                    String string3 = null;
                    ASN1OctetString aSN1OctetString7 = null;
                    String string4 = null;
                    boolean bl2 = false;
                    ASN1StreamReaderSequence aSN1StreamReaderSequence = aSN1StreamReader.beginSequence();
                    block26: while (aSN1StreamReaderSequence.hasMoreElements()) {
                        byte by3 = (byte)aSN1StreamReader.peek();
                        switch (by3) {
                            case -126: {
                                string3 = aSN1StreamReader.readString();
                                continue block26;
                            }
                            case -127: {
                                string4 = aSN1StreamReader.readString();
                                continue block26;
                            }
                            case -125: {
                                aSN1OctetString7 = new ASN1OctetString(by3, aSN1StreamReader.readBytes());
                                continue block26;
                            }
                            case -124: {
                                bl2 = aSN1StreamReader.readBoolean();
                                continue block26;
                            }
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_INVALID_TYPE.get(StaticUtils.toHex(by3)));
                    }
                    if (string3 == null && string4 == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_NO_ATTR_OR_MRID.get());
                    }
                    if (aSN1OctetString7 == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_NO_VALUE.get());
                    }
                    string2 = string3;
                    aSN1OctetString3 = aSN1OctetString7;
                    string = string4;
                    bl = bl2;
                    filterArray = NO_FILTERS;
                    filter = null;
                    aSN1OctetString2 = null;
                    aSN1OctetStringArray = NO_SUB_ANY;
                    aSN1OctetString = null;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_ELEMENT_INVALID_TYPE.get(StaticUtils.toHex(by)));
                }
            }
            return new Filter(null, by, filterArray, filter, string2, aSN1OctetString3, aSN1OctetString2, aSN1OctetStringArray, aSN1OctetString, string, bl);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public static Filter decode(ASN1Element aSN1Element) throws LDAPException {
        Filter[] filterArray;
        boolean bl;
        String string;
        ASN1OctetString aSN1OctetString;
        ASN1OctetString[] aSN1OctetStringArray;
        ASN1OctetString aSN1OctetString2;
        ASN1OctetString aSN1OctetString3;
        String string2;
        Filter filter;
        byte by = aSN1Element.getType();
        switch (by) {
            case -96: 
            case -95: {
                ASN1Set aSN1Set;
                filter = null;
                string2 = null;
                aSN1OctetString3 = null;
                aSN1OctetString2 = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                aSN1OctetString = null;
                string = null;
                bl = false;
                try {
                    aSN1Set = ASN1Set.decodeAsSet(aSN1Element);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.debugException(aSN1Exception);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE_COMPS.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                }
                ASN1Element[] aSN1ElementArray = aSN1Set.elements();
                filterArray = new Filter[aSN1ElementArray.length];
                for (int i = 0; i < aSN1ElementArray.length; ++i) {
                    filterArray[i] = Filter.decode(aSN1ElementArray[i]);
                }
                break;
            }
            case -94: {
                ASN1Element aSN1Element2;
                filterArray = NO_FILTERS;
                string2 = null;
                aSN1OctetString3 = null;
                aSN1OctetString2 = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                aSN1OctetString = null;
                string = null;
                bl = false;
                try {
                    aSN1Element2 = ASN1Element.decode(aSN1Element.getValue());
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.debugException(aSN1Exception);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE_NOT_COMP.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                }
                filter = Filter.decode(aSN1Element2);
                break;
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                ASN1Sequence aSN1Sequence;
                filterArray = NO_FILTERS;
                filter = null;
                aSN1OctetString2 = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                aSN1OctetString = null;
                string = null;
                bl = false;
                try {
                    aSN1Sequence = ASN1Sequence.decodeAsSequence(aSN1Element);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.debugException(aSN1Exception);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE_AVA.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                }
                ASN1Element[] aSN1ElementArray = aSN1Sequence.elements();
                if (aSN1ElementArray.length != 2) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_INVALID_AVA_ELEMENT_COUNT.get(aSN1ElementArray.length));
                }
                string2 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[0]).stringValue();
                aSN1OctetString3 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray[1]);
                break;
            }
            case -92: {
                ASN1Element[] aSN1ElementArray;
                ASN1Sequence aSN1Sequence;
                ASN1Sequence aSN1Sequence2;
                filterArray = NO_FILTERS;
                filter = null;
                aSN1OctetString3 = null;
                string = null;
                bl = false;
                try {
                    aSN1Sequence2 = ASN1Sequence.decodeAsSequence(aSN1Element);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.debugException(aSN1Exception);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE_SUBSTRING.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                }
                ASN1Element[] aSN1ElementArray2 = aSN1Sequence2.elements();
                if (aSN1ElementArray2.length != 2) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_INVALID_SUBSTR_ASSERTION_COUNT.get(aSN1ElementArray2.length));
                }
                string2 = ASN1OctetString.decodeAsOctetString(aSN1ElementArray2[0]).stringValue();
                try {
                    aSN1Sequence = ASN1Sequence.decodeAsSequence(aSN1ElementArray2[1]);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.debugException(aSN1Exception);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE_SUBSTRING.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                }
                ASN1OctetString aSN1OctetString4 = null;
                ASN1OctetString aSN1OctetString5 = null;
                ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(1);
                block34: for (ASN1Element aSN1Element3 : aSN1ElementArray = aSN1Sequence.elements()) {
                    switch (aSN1Element3.getType()) {
                        case -128: {
                            if (aSN1OctetString4 == null) {
                                aSN1OctetString4 = ASN1OctetString.decodeAsOctetString(aSN1Element3);
                                continue block34;
                            }
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_MULTIPLE_SUBINITIAL.get());
                        }
                        case -127: {
                            arrayList.add(ASN1OctetString.decodeAsOctetString(aSN1Element3));
                            continue block34;
                        }
                        case -126: {
                            if (aSN1OctetString5 == null) {
                                aSN1OctetString5 = ASN1OctetString.decodeAsOctetString(aSN1Element3);
                                continue block34;
                            }
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_MULTIPLE_SUBFINAL.get());
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_INVALID_SUBSTR_TYPE.get(StaticUtils.toHex(aSN1Element3.getType())));
                        }
                    }
                }
                aSN1OctetString2 = aSN1OctetString4;
                aSN1OctetStringArray = arrayList.toArray(new ASN1OctetString[arrayList.size()]);
                aSN1OctetString = aSN1OctetString5;
                break;
            }
            case -121: {
                filterArray = NO_FILTERS;
                filter = null;
                aSN1OctetString3 = null;
                aSN1OctetString2 = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                aSN1OctetString = null;
                string = null;
                bl = false;
                string2 = ASN1OctetString.decodeAsOctetString(aSN1Element).stringValue();
                break;
            }
            case -87: {
                ASN1Sequence aSN1Sequence;
                filterArray = NO_FILTERS;
                filter = null;
                aSN1OctetString2 = null;
                aSN1OctetStringArray = NO_SUB_ANY;
                aSN1OctetString = null;
                try {
                    aSN1Sequence = ASN1Sequence.decodeAsSequence(aSN1Element);
                }
                catch (ASN1Exception aSN1Exception) {
                    Debug.debugException(aSN1Exception);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_CANNOT_DECODE_EXTMATCH.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                }
                String string3 = null;
                ASN1OctetString aSN1OctetString6 = null;
                String string4 = null;
                boolean bl2 = false;
                block35: for (ASN1Element aSN1Element4 : aSN1Sequence.elements()) {
                    switch (aSN1Element4.getType()) {
                        case -126: {
                            if (string3 == null) {
                                string3 = ASN1OctetString.decodeAsOctetString(aSN1Element4).stringValue();
                                continue block35;
                            }
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_MULTIPLE_ATTRS.get());
                        }
                        case -127: {
                            if (string4 == null) {
                                string4 = ASN1OctetString.decodeAsOctetString(aSN1Element4).stringValue();
                                continue block35;
                            }
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_MULTIPLE_MRIDS.get());
                        }
                        case -125: {
                            if (aSN1OctetString6 == null) {
                                aSN1OctetString6 = ASN1OctetString.decodeAsOctetString(aSN1Element4);
                                continue block35;
                            }
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_MULTIPLE_VALUES.get());
                        }
                        case -124: {
                            try {
                                if (bl2) {
                                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_MULTIPLE_DNATTRS.get());
                                }
                                bl2 = ASN1Boolean.decodeAsBoolean(aSN1Element4).booleanValue();
                                continue block35;
                            }
                            catch (ASN1Exception aSN1Exception) {
                                Debug.debugException(aSN1Exception);
                                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_DNATTRS_NOT_BOOLEAN.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
                            }
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_INVALID_TYPE.get(StaticUtils.toHex(aSN1Element4.getType())));
                        }
                    }
                }
                if (string3 == null && string4 == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_NO_ATTR_OR_MRID.get());
                }
                if (aSN1OctetString6 == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_EXTMATCH_NO_VALUE.get());
                }
                string2 = string3;
                aSN1OctetString3 = aSN1OctetString6;
                string = string4;
                bl = bl2;
                break;
            }
            default: {
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_FILTER_ELEMENT_INVALID_TYPE.get(StaticUtils.toHex(aSN1Element.getType())));
            }
        }
        return new Filter(null, by, filterArray, filter, string2, aSN1OctetString3, aSN1OctetString2, aSN1OctetStringArray, aSN1OctetString, string, bl);
    }

    public byte getFilterType() {
        return this.filterType;
    }

    public Filter[] getComponents() {
        return this.filterComps;
    }

    public Filter getNOTComponent() {
        return this.notComp;
    }

    public String getAttributeName() {
        return this.attrName;
    }

    public String getAssertionValue() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.stringValue();
    }

    public byte[] getAssertionValueBytes() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.getValue();
    }

    public ASN1OctetString getRawAssertionValue() {
        return this.assertionValue;
    }

    public String getSubInitialString() {
        if (this.subInitial == null) {
            return null;
        }
        return this.subInitial.stringValue();
    }

    public byte[] getSubInitialBytes() {
        if (this.subInitial == null) {
            return null;
        }
        return this.subInitial.getValue();
    }

    public ASN1OctetString getRawSubInitialValue() {
        return this.subInitial;
    }

    public String[] getSubAnyStrings() {
        String[] stringArray = new String[this.subAny.length];
        for (int i = 0; i < this.subAny.length; ++i) {
            stringArray[i] = this.subAny[i].stringValue();
        }
        return stringArray;
    }

    public byte[][] getSubAnyBytes() {
        byte[][] byArrayArray = new byte[this.subAny.length][];
        for (int i = 0; i < this.subAny.length; ++i) {
            byArrayArray[i] = this.subAny[i].getValue();
        }
        return byArrayArray;
    }

    public ASN1OctetString[] getRawSubAnyValues() {
        return this.subAny;
    }

    public String getSubFinalString() {
        if (this.subFinal == null) {
            return null;
        }
        return this.subFinal.stringValue();
    }

    public byte[] getSubFinalBytes() {
        if (this.subFinal == null) {
            return null;
        }
        return this.subFinal.getValue();
    }

    public ASN1OctetString getRawSubFinalValue() {
        return this.subFinal;
    }

    public String getMatchingRuleID() {
        return this.matchingRuleID;
    }

    public boolean getDNAttributes() {
        return this.dnAttributes;
    }

    public boolean matchesEntry(Entry entry) throws LDAPException {
        return this.matchesEntry(entry, entry.getSchema());
    }

    public boolean matchesEntry(Entry entry, Schema schema) throws LDAPException {
        Validator.ensureNotNull(entry);
        switch (this.filterType) {
            case -96: {
                for (Filter filter : this.filterComps) {
                    if (filter.matchesEntry(entry, schema)) continue;
                    return false;
                }
                return true;
            }
            case -95: {
                for (Filter filter : this.filterComps) {
                    if (!filter.matchesEntry(entry, schema)) continue;
                    return true;
                }
                return false;
            }
            case -94: {
                return !this.notComp.matchesEntry(entry, schema);
            }
            case -93: {
                Attribute attribute = entry.getAttribute(this.attrName, schema);
                if (attribute == null) {
                    return false;
                }
                MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(this.attrName, schema);
                for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                    if (!matchingRule.valuesMatch(aSN1OctetString, this.assertionValue)) continue;
                    return true;
                }
                return false;
            }
            case -92: {
                Attribute attribute = entry.getAttribute(this.attrName, schema);
                if (attribute == null) {
                    return false;
                }
                MatchingRule matchingRule = MatchingRule.selectSubstringMatchingRule(this.attrName, schema);
                for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                    if (!matchingRule.matchesSubstring(aSN1OctetString, this.subInitial, this.subAny, this.subFinal)) continue;
                    return true;
                }
                return false;
            }
            case -91: {
                Attribute attribute = entry.getAttribute(this.attrName, schema);
                if (attribute == null) {
                    return false;
                }
                MatchingRule matchingRule = MatchingRule.selectOrderingMatchingRule(this.attrName, schema);
                for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                    if (matchingRule.compareValues(aSN1OctetString, this.assertionValue) < 0) continue;
                    return true;
                }
                return false;
            }
            case -90: {
                Attribute attribute = entry.getAttribute(this.attrName, schema);
                if (attribute == null) {
                    return false;
                }
                MatchingRule matchingRule = MatchingRule.selectOrderingMatchingRule(this.attrName, schema);
                for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                    if (matchingRule.compareValues(aSN1OctetString, this.assertionValue) > 0) continue;
                    return true;
                }
                return false;
            }
            case -121: {
                return entry.hasAttribute(this.attrName);
            }
            case -88: {
                throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_FILTER_APPROXIMATE_MATCHING_NOT_SUPPORTED.get());
            }
            case -87: {
                throw new LDAPException(ResultCode.NOT_SUPPORTED, LDAPMessages.ERR_FILTER_EXTENSIBLE_MATCHING_NOT_SUPPORTED.get());
            }
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_FILTER_INVALID_TYPE.get());
    }

    public static Filter simplifyFilter(Filter filter, boolean bl) {
        Serializable serializable;
        byte by = filter.filterType;
        switch (by) {
            case -96: 
            case -95: {
                break;
            }
            case -94: {
                return Filter.createNOTFilter(Filter.simplifyFilter(filter.notComp, bl));
            }
            default: {
                return filter;
            }
        }
        Filter[] filterArray = filter.filterComps;
        if (filterArray == null || filterArray.length == 0) {
            return filter;
        }
        if (filterArray.length == 1) {
            return Filter.simplifyFilter(filterArray[0], bl);
        }
        LinkedHashSet<Filter> linkedHashSet = new LinkedHashSet<Filter>(10);
        for (Filter filter2 : filterArray) {
            serializable = Filter.simplifyFilter(filter2, bl);
            if (((Filter)serializable).filterType == -96) {
                if (by == -96) {
                    linkedHashSet.addAll(Arrays.asList(((Filter)serializable).filterComps));
                    continue;
                }
                linkedHashSet.add((Filter)serializable);
                continue;
            }
            if (((Filter)serializable).filterType == -95) {
                if (by == -95) {
                    linkedHashSet.addAll(Arrays.asList(((Filter)serializable).filterComps));
                    continue;
                }
                linkedHashSet.add((Filter)serializable);
                continue;
            }
            linkedHashSet.add((Filter)serializable);
        }
        if (linkedHashSet.size() == 1) {
            return (Filter)linkedHashSet.iterator().next();
        }
        if (bl) {
            TreeMap treeMap = new TreeMap();
            for (Filter filter3 : linkedHashSet) {
                Filter filter2;
                filter2 = filter3.filterType == -96 || filter3.filterType == -95 ? (filter3.filterComps.length > 0 ? filter3.filterComps[0] : filter3) : filter3;
                switch (filter2.filterType) {
                    case -93: {
                        if (filter2.attrName.equalsIgnoreCase("objectClass")) {
                            serializable = Integer.valueOf(2);
                            break;
                        }
                        serializable = Integer.valueOf(1);
                        break;
                    }
                    case -88: {
                        serializable = Integer.valueOf(3);
                        break;
                    }
                    case -121: {
                        if (filter2.attrName.equalsIgnoreCase("objectClass")) {
                            serializable = Integer.valueOf(9);
                            break;
                        }
                        serializable = Integer.valueOf(4);
                        break;
                    }
                    case -92: {
                        if (filter2.subInitial == null) {
                            serializable = Integer.valueOf(6);
                            break;
                        }
                        serializable = Integer.valueOf(5);
                        break;
                    }
                    case -91: 
                    case -90: {
                        serializable = Integer.valueOf(7);
                        break;
                    }
                    case -87: {
                        serializable = Integer.valueOf(8);
                        break;
                    }
                    default: {
                        serializable = Integer.valueOf(10);
                    }
                }
                LinkedHashSet<Filter> linkedHashSet2 = (LinkedHashSet<Filter>)treeMap.get((Integer)serializable - 1);
                if (linkedHashSet2 == null) {
                    linkedHashSet2 = new LinkedHashSet<Filter>(10);
                    treeMap.put((Integer)serializable - 1, linkedHashSet2);
                }
                linkedHashSet2.add(filter3);
            }
            linkedHashSet.clear();
            for (LinkedHashSet linkedHashSet3 : treeMap.values()) {
                linkedHashSet.addAll(linkedHashSet3);
            }
        }
        if (by == -96) {
            return Filter.createANDFilter(linkedHashSet);
        }
        return Filter.createORFilter(linkedHashSet);
    }

    public int hashCode() {
        CaseIgnoreStringMatchingRule caseIgnoreStringMatchingRule = CaseIgnoreStringMatchingRule.getInstance();
        int n = this.filterType;
        switch (this.filterType) {
            case -96: 
            case -95: {
                for (Filter filter : this.filterComps) {
                    n += filter.hashCode();
                }
                break;
            }
            case -94: {
                n += this.notComp.hashCode();
                break;
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                n += StaticUtils.toLowerCase(this.attrName).hashCode();
                n += caseIgnoreStringMatchingRule.normalize(this.assertionValue).hashCode();
                break;
            }
            case -92: {
                n += StaticUtils.toLowerCase(this.attrName).hashCode();
                if (this.subInitial != null) {
                    n += caseIgnoreStringMatchingRule.normalizeSubstring(this.subInitial, (byte)-128).hashCode();
                }
                for (ASN1OctetString aSN1OctetString : this.subAny) {
                    n += caseIgnoreStringMatchingRule.normalizeSubstring(aSN1OctetString, (byte)-127).hashCode();
                }
                if (this.subFinal == null) break;
                n += caseIgnoreStringMatchingRule.normalizeSubstring(this.subFinal, (byte)-126).hashCode();
                break;
            }
            case -121: {
                n += StaticUtils.toLowerCase(this.attrName).hashCode();
                break;
            }
            case -87: {
                if (this.attrName != null) {
                    n += StaticUtils.toLowerCase(this.attrName).hashCode();
                }
                if (this.matchingRuleID != null) {
                    n += StaticUtils.toLowerCase(this.matchingRuleID).hashCode();
                }
                if (this.dnAttributes) {
                    ++n;
                }
                n += caseIgnoreStringMatchingRule.normalize(this.assertionValue).hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Filter)) {
            return false;
        }
        Filter filter = (Filter)object;
        if (this.filterType != filter.filterType) {
            return false;
        }
        CaseIgnoreStringMatchingRule caseIgnoreStringMatchingRule = CaseIgnoreStringMatchingRule.getInstance();
        switch (this.filterType) {
            case -96: 
            case -95: {
                if (this.filterComps.length != filter.filterComps.length) {
                    return false;
                }
                HashSet<Filter> hashSet = new HashSet<Filter>();
                hashSet.addAll(Arrays.asList(this.filterComps));
                for (Filter filter2 : filter.filterComps) {
                    if (hashSet.remove(filter2)) continue;
                    return false;
                }
                return true;
            }
            case -94: {
                return this.notComp.equals(filter.notComp);
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                return this.attrName.equalsIgnoreCase(filter.attrName) && caseIgnoreStringMatchingRule.valuesMatch(this.assertionValue, filter.assertionValue);
            }
            case -92: {
                ASN1OctetString aSN1OctetString;
                if (!this.attrName.equalsIgnoreCase(filter.attrName)) {
                    return false;
                }
                if (this.subAny.length != filter.subAny.length) {
                    return false;
                }
                if (this.subInitial == null) {
                    if (filter.subInitial != null) {
                        return false;
                    }
                } else {
                    if (filter.subInitial == null) {
                        return false;
                    }
                    ASN1OctetString aSN1OctetString2 = caseIgnoreStringMatchingRule.normalizeSubstring(this.subInitial, (byte)-128);
                    if (!aSN1OctetString2.equals(aSN1OctetString = caseIgnoreStringMatchingRule.normalizeSubstring(filter.subInitial, (byte)-128))) {
                        return false;
                    }
                }
                for (int i = 0; i < this.subAny.length; ++i) {
                    ASN1OctetString aSN1OctetString3;
                    aSN1OctetString = caseIgnoreStringMatchingRule.normalizeSubstring(this.subAny[i], (byte)-127);
                    if (aSN1OctetString.equals(aSN1OctetString3 = caseIgnoreStringMatchingRule.normalizeSubstring(filter.subAny[i], (byte)-127))) continue;
                    return false;
                }
                if (this.subFinal == null) {
                    if (filter.subFinal != null) {
                        return false;
                    }
                } else {
                    if (filter.subFinal == null) {
                        return false;
                    }
                    ASN1OctetString aSN1OctetString4 = caseIgnoreStringMatchingRule.normalizeSubstring(this.subFinal, (byte)-126);
                    if (!aSN1OctetString4.equals(aSN1OctetString = caseIgnoreStringMatchingRule.normalizeSubstring(filter.subFinal, (byte)-126))) {
                        return false;
                    }
                }
                return true;
            }
            case -121: {
                return this.attrName.equalsIgnoreCase(filter.attrName);
            }
            case -87: {
                if (this.attrName == null) {
                    if (filter.attrName != null) {
                        return false;
                    }
                } else {
                    if (filter.attrName == null) {
                        return false;
                    }
                    if (!this.attrName.equalsIgnoreCase(filter.attrName)) {
                        return false;
                    }
                }
                if (this.matchingRuleID == null) {
                    if (filter.matchingRuleID != null) {
                        return false;
                    }
                } else {
                    if (filter.matchingRuleID == null) {
                        return false;
                    }
                    if (!this.matchingRuleID.equalsIgnoreCase(filter.matchingRuleID)) {
                        return false;
                    }
                }
                if (this.dnAttributes != filter.dnAttributes) {
                    return false;
                }
                return caseIgnoreStringMatchingRule.valuesMatch(this.assertionValue, filter.assertionValue);
            }
        }
        return false;
    }

    public String toString() {
        if (this.filterString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            this.filterString = stringBuilder.toString();
        }
        return this.filterString;
    }

    public void toString(StringBuilder stringBuilder) {
        switch (this.filterType) {
            case -96: {
                stringBuilder.append("(&");
                for (Filter filter : this.filterComps) {
                    filter.toString(stringBuilder);
                }
                stringBuilder.append(')');
                break;
            }
            case -95: {
                stringBuilder.append("(|");
                for (Filter filter : this.filterComps) {
                    filter.toString(stringBuilder);
                }
                stringBuilder.append(')');
                break;
            }
            case -94: {
                stringBuilder.append("(!");
                this.notComp.toString(stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -93: {
                stringBuilder.append('(');
                stringBuilder.append(this.attrName);
                stringBuilder.append('=');
                Filter.encodeValue(this.assertionValue, stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -92: {
                stringBuilder.append('(');
                stringBuilder.append(this.attrName);
                stringBuilder.append('=');
                if (this.subInitial != null) {
                    Filter.encodeValue(this.subInitial, stringBuilder);
                }
                stringBuilder.append('*');
                for (ASN1OctetString aSN1OctetString : this.subAny) {
                    Filter.encodeValue(aSN1OctetString, stringBuilder);
                    stringBuilder.append('*');
                }
                if (this.subFinal != null) {
                    Filter.encodeValue(this.subFinal, stringBuilder);
                }
                stringBuilder.append(')');
                break;
            }
            case -91: {
                stringBuilder.append('(');
                stringBuilder.append(this.attrName);
                stringBuilder.append(">=");
                Filter.encodeValue(this.assertionValue, stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -90: {
                stringBuilder.append('(');
                stringBuilder.append(this.attrName);
                stringBuilder.append("<=");
                Filter.encodeValue(this.assertionValue, stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -121: {
                stringBuilder.append('(');
                stringBuilder.append(this.attrName);
                stringBuilder.append("=*)");
                break;
            }
            case -88: {
                stringBuilder.append('(');
                stringBuilder.append(this.attrName);
                stringBuilder.append("~=");
                Filter.encodeValue(this.assertionValue, stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -87: {
                stringBuilder.append('(');
                if (this.attrName != null) {
                    stringBuilder.append(this.attrName);
                }
                if (this.dnAttributes) {
                    stringBuilder.append(":dn");
                }
                if (this.matchingRuleID != null) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.matchingRuleID);
                }
                stringBuilder.append(":=");
                Filter.encodeValue(this.assertionValue, stringBuilder);
                stringBuilder.append(')');
            }
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toNormalizedString(stringBuilder);
            this.normalizedString = stringBuilder.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        CaseIgnoreStringMatchingRule caseIgnoreStringMatchingRule = CaseIgnoreStringMatchingRule.getInstance();
        switch (this.filterType) {
            case -96: {
                stringBuilder.append("(&");
                for (Filter filter : this.filterComps) {
                    filter.toNormalizedString(stringBuilder);
                }
                stringBuilder.append(')');
                break;
            }
            case -95: {
                stringBuilder.append("(|");
                for (Filter filter : this.filterComps) {
                    filter.toNormalizedString(stringBuilder);
                }
                stringBuilder.append(')');
                break;
            }
            case -94: {
                stringBuilder.append("(!");
                this.notComp.toNormalizedString(stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -93: {
                stringBuilder.append('(');
                stringBuilder.append(StaticUtils.toLowerCase(this.attrName));
                stringBuilder.append('=');
                Filter.encodeValue(caseIgnoreStringMatchingRule.normalize(this.assertionValue), stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -92: {
                stringBuilder.append('(');
                stringBuilder.append(StaticUtils.toLowerCase(this.attrName));
                stringBuilder.append('=');
                if (this.subInitial != null) {
                    Filter.encodeValue(caseIgnoreStringMatchingRule.normalizeSubstring(this.subInitial, (byte)-128), stringBuilder);
                }
                stringBuilder.append('*');
                for (ASN1OctetString aSN1OctetString : this.subAny) {
                    Filter.encodeValue(caseIgnoreStringMatchingRule.normalizeSubstring(aSN1OctetString, (byte)-127), stringBuilder);
                    stringBuilder.append('*');
                }
                if (this.subFinal != null) {
                    Filter.encodeValue(caseIgnoreStringMatchingRule.normalizeSubstring(this.subFinal, (byte)-126), stringBuilder);
                }
                stringBuilder.append(')');
                break;
            }
            case -91: {
                stringBuilder.append('(');
                stringBuilder.append(StaticUtils.toLowerCase(this.attrName));
                stringBuilder.append(">=");
                Filter.encodeValue(caseIgnoreStringMatchingRule.normalize(this.assertionValue), stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -90: {
                stringBuilder.append('(');
                stringBuilder.append(StaticUtils.toLowerCase(this.attrName));
                stringBuilder.append("<=");
                Filter.encodeValue(caseIgnoreStringMatchingRule.normalize(this.assertionValue), stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -121: {
                stringBuilder.append('(');
                stringBuilder.append(StaticUtils.toLowerCase(this.attrName));
                stringBuilder.append("=*)");
                break;
            }
            case -88: {
                stringBuilder.append('(');
                stringBuilder.append(StaticUtils.toLowerCase(this.attrName));
                stringBuilder.append("~=");
                Filter.encodeValue(caseIgnoreStringMatchingRule.normalize(this.assertionValue), stringBuilder);
                stringBuilder.append(')');
                break;
            }
            case -87: {
                stringBuilder.append('(');
                if (this.attrName != null) {
                    stringBuilder.append(StaticUtils.toLowerCase(this.attrName));
                }
                if (this.dnAttributes) {
                    stringBuilder.append(":dn");
                }
                if (this.matchingRuleID != null) {
                    stringBuilder.append(':');
                    stringBuilder.append(StaticUtils.toLowerCase(this.matchingRuleID));
                }
                stringBuilder.append(":=");
                Filter.encodeValue(caseIgnoreStringMatchingRule.normalize(this.assertionValue), stringBuilder);
                stringBuilder.append(')');
            }
        }
    }

    public static String encodeValue(String string) {
        Validator.ensureNotNull(string);
        StringBuilder stringBuilder = new StringBuilder();
        Filter.encodeValue(new ASN1OctetString(string), stringBuilder);
        return stringBuilder.toString();
    }

    public static String encodeValue(byte[] byArray) {
        Validator.ensureNotNull(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        Filter.encodeValue(new ASN1OctetString(byArray), stringBuilder);
        return stringBuilder.toString();
    }

    private static void encodeValue(ASN1OctetString aSN1OctetString, StringBuilder stringBuilder) {
        byte[] byArray = aSN1OctetString.getValue();
        block6: for (int i = 0; i < byArray.length; ++i) {
            switch (StaticUtils.numBytesInUTF8CharacterWithFirstByte(byArray[i])) {
                case 1: {
                    if (byArray[i] <= 31 || byArray[i] == 40 || byArray[i] == 41 || byArray[i] == 42 || byArray[i] == 92 || byArray[i] == 127) {
                        stringBuilder.append('\\');
                        StaticUtils.toHex(byArray[i], stringBuilder);
                        continue block6;
                    }
                    stringBuilder.append((char)byArray[i]);
                    continue block6;
                }
                case 2: {
                    stringBuilder.append('\\');
                    StaticUtils.toHex(byArray[i++], stringBuilder);
                    if (i >= byArray.length) continue block6;
                    stringBuilder.append('\\');
                    StaticUtils.toHex(byArray[i], stringBuilder);
                    continue block6;
                }
                case 3: {
                    stringBuilder.append('\\');
                    StaticUtils.toHex(byArray[i++], stringBuilder);
                    if (i < byArray.length) {
                        stringBuilder.append('\\');
                        StaticUtils.toHex(byArray[i++], stringBuilder);
                    }
                    if (i >= byArray.length) continue block6;
                    stringBuilder.append('\\');
                    StaticUtils.toHex(byArray[i], stringBuilder);
                    continue block6;
                }
                case 4: {
                    stringBuilder.append('\\');
                    StaticUtils.toHex(byArray[i++], stringBuilder);
                    if (i < byArray.length) {
                        stringBuilder.append('\\');
                        StaticUtils.toHex(byArray[i++], stringBuilder);
                    }
                    if (i < byArray.length) {
                        stringBuilder.append('\\');
                        StaticUtils.toHex(byArray[i++], stringBuilder);
                    }
                    if (i >= byArray.length) continue block6;
                    stringBuilder.append('\\');
                    StaticUtils.toHex(byArray[i], stringBuilder);
                    continue block6;
                }
                default: {
                    while (i < byArray.length) {
                        stringBuilder.append('\\');
                        StaticUtils.toHex(byArray[i++], stringBuilder);
                    }
                    break block0;
                }
            }
        }
    }

    public void toCode(List<String> list, int n, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        String string3 = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append(string3);
        if (string != null) {
            stringBuilder.append(string);
        }
        switch (this.filterType) {
            case -96: 
            case -95: {
                if (this.filterType == -96) {
                    stringBuilder.append("Filter.createANDFilter(");
                } else {
                    stringBuilder.append("Filter.createORFilter(");
                }
                if (this.filterComps.length == 0) {
                    stringBuilder.append(')');
                    if (string2 != null) {
                        stringBuilder.append(string2);
                    }
                    list.add(stringBuilder.toString());
                    return;
                }
                for (int i = 0; i < this.filterComps.length; ++i) {
                    String string4;
                    if (i == this.filterComps.length - 1) {
                        string4 = ")";
                        if (string2 != null) {
                            string4 = string4 + string2;
                        }
                    } else {
                        string4 = ",";
                    }
                    this.filterComps[i].toCode(list, n + 5, null, string4);
                }
                return;
            }
            case -94: {
                stringBuilder.append("Filter.createNOTFilter(");
                list.add(stringBuilder.toString());
                String string5 = string2 == null ? ")" : ')' + string2;
                this.notComp.toCode(list, n + 5, null, string5);
                return;
            }
            case -121: {
                stringBuilder.append("Filter.createPresenceFilter(");
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     \"");
                stringBuilder.append(this.attrName);
                stringBuilder.append("\")");
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                list.add(stringBuilder.toString());
                return;
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                if (this.filterType == -93) {
                    stringBuilder.append("Filter.createEqualityFilter(");
                } else if (this.filterType == -91) {
                    stringBuilder.append("Filter.createGreaterOrEqualFilter(");
                } else if (this.filterType == -90) {
                    stringBuilder.append("Filter.createLessOrEqualFilter(");
                } else {
                    stringBuilder.append("Filter.createApproximateMatchFilter(");
                }
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     \"");
                stringBuilder.append(this.attrName);
                stringBuilder.append("\",");
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (StaticUtils.isSensitiveToCodeAttribute(this.attrName)) {
                    stringBuilder.append("\"---redacted-value---\"");
                } else if (StaticUtils.isPrintableString(this.assertionValue.getValue())) {
                    stringBuilder.append('\"');
                    stringBuilder.append(this.assertionValue.stringValue());
                    stringBuilder.append('\"');
                } else {
                    StaticUtils.byteArrayToCode(this.assertionValue.getValue(), stringBuilder);
                }
                stringBuilder.append(')');
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                list.add(stringBuilder.toString());
                return;
            }
            case -92: {
                stringBuilder.append("Filter.createSubstringFilter(");
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     \"");
                stringBuilder.append(this.attrName);
                stringBuilder.append("\",");
                list.add(stringBuilder.toString());
                boolean bl = StaticUtils.isSensitiveToCodeAttribute(this.attrName);
                boolean bl2 = true;
                if (this.subInitial != null) {
                    bl2 = StaticUtils.isPrintableString(this.subInitial.getValue());
                }
                if (bl2 && this.subAny != null) {
                    for (ASN1OctetString aSN1OctetString : this.subAny) {
                        if (StaticUtils.isPrintableString(aSN1OctetString.getValue())) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (bl2 && this.subFinal != null) {
                    bl2 = StaticUtils.isPrintableString(this.subFinal.getValue());
                }
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (this.subInitial == null) {
                    stringBuilder.append("null");
                } else if (bl) {
                    stringBuilder.append("\"---redacted-subInitial---\"");
                } else if (bl2) {
                    stringBuilder.append('\"');
                    stringBuilder.append(this.subInitial.stringValue());
                    stringBuilder.append('\"');
                } else {
                    StaticUtils.byteArrayToCode(this.subInitial.getValue(), stringBuilder);
                }
                stringBuilder.append(',');
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (this.subAny == null || this.subAny.length == 0) {
                    stringBuilder.append("null,");
                    list.add(stringBuilder.toString());
                } else if (bl) {
                    stringBuilder.append("new String[]");
                    list.add(stringBuilder.toString());
                    list.add(string3 + "     {");
                    for (int i = 0; i < this.subAny.length; ++i) {
                        stringBuilder.setLength(0);
                        stringBuilder.append(string3);
                        stringBuilder.append("       \"---redacted-subAny-");
                        stringBuilder.append(i + 1);
                        stringBuilder.append("---\"");
                        if (i < this.subAny.length - 1) {
                            stringBuilder.append(',');
                        }
                        list.add(stringBuilder.toString());
                    }
                    list.add(string3 + "     },");
                } else if (bl2) {
                    stringBuilder.append("new String[]");
                    list.add(stringBuilder.toString());
                    list.add(string3 + "     {");
                    for (int i = 0; i < this.subAny.length; ++i) {
                        stringBuilder.setLength(0);
                        stringBuilder.append(string3);
                        stringBuilder.append("       \"");
                        stringBuilder.append(this.subAny[i].stringValue());
                        stringBuilder.append('\"');
                        if (i < this.subAny.length - 1) {
                            stringBuilder.append(',');
                        }
                        list.add(stringBuilder.toString());
                    }
                    list.add(string3 + "     },");
                } else {
                    stringBuilder.append("new String[]");
                    list.add(stringBuilder.toString());
                    list.add(string3 + "     {");
                    for (int i = 0; i < this.subAny.length; ++i) {
                        stringBuilder.setLength(0);
                        stringBuilder.append(string3);
                        stringBuilder.append("       ");
                        StaticUtils.byteArrayToCode(this.subAny[i].getValue(), stringBuilder);
                        if (i < this.subAny.length - 1) {
                            stringBuilder.append(',');
                        }
                        list.add(stringBuilder.toString());
                    }
                    list.add(string3 + "     },");
                }
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (this.subFinal == null) {
                    stringBuilder.append("null)");
                } else if (bl) {
                    stringBuilder.append("\"---redacted-subFinal---\")");
                } else if (bl2) {
                    stringBuilder.append('\"');
                    stringBuilder.append(this.subFinal.stringValue());
                    stringBuilder.append("\")");
                } else {
                    StaticUtils.byteArrayToCode(this.subFinal.getValue(), stringBuilder);
                    stringBuilder.append(')');
                }
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                list.add(stringBuilder.toString());
                return;
            }
            case -87: {
                stringBuilder.append("Filter.createExtensibleMatchFilter(");
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (this.attrName == null) {
                    stringBuilder.append("null, // Attribute Description");
                } else {
                    stringBuilder.append('\"');
                    stringBuilder.append(this.attrName);
                    stringBuilder.append("\",");
                }
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (this.matchingRuleID == null) {
                    stringBuilder.append("null, // Matching Rule ID");
                } else {
                    stringBuilder.append('\"');
                    stringBuilder.append(this.matchingRuleID);
                    stringBuilder.append("\",");
                }
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                stringBuilder.append(this.dnAttributes);
                stringBuilder.append(", // DN Attributes");
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (this.attrName != null && StaticUtils.isSensitiveToCodeAttribute(this.attrName)) {
                    stringBuilder.append("\"---redacted-value---\")");
                } else if (StaticUtils.isPrintableString(this.assertionValue.getValue())) {
                    stringBuilder.append('\"');
                    stringBuilder.append(this.assertionValue.stringValue());
                    stringBuilder.append("\")");
                } else {
                    StaticUtils.byteArrayToCode(this.assertionValue.getValue(), stringBuilder);
                    stringBuilder.append(')');
                }
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                list.add(stringBuilder.toString());
                return;
            }
        }
    }
}

